<?php

require_once XOOPS_ROOT_PATH.'/header.php';
require_once(dirname(dirname(__FILE__)) . '/include/groupperm_function.php');
require_once(dirname(dirname(__FILE__)) . '/include/misc.php');
require_once(dirname(dirname(__FILE__)) . '/include/db.php');

$constpref = strtoupper( $mydirname ) ;

spicky_main_css($mydirname);
spicky_set_gperm($mydirname);

if (defined('DIRCUT')) {
    $return_url = XOOPS_URL . '/';
} else {
    $return_url = XOOPS_URL . '/modules/' . $mydirname . '/';
}

if (@$_GET['id'] == 0) {
    redirect_header($return_url, 2, _MD_SPICKY_IMAGE_NOT_FOUND);
    exit();
}

$image = spicky_get_image($_GET['id']);

if (@$image['id'] == 0) {
    redirect_header($return_url, 2, _MD_SPICKY_IMAGE_NOT_FOUND);
    exit();
}

if ($image['status'] == SPICKY_STATUS_OK && $image['time_limit'] != 0 && $image['time_limit'] < time()) {
	spicky_delete_image_func($mydirname, $_GET['id'], true);
	$image = spicky_get_image($_GET['id']);
	if (@$image['id'] == 0) {
		redirect_header($return_url, 2, _MD_SPICKY_IMAGE_NOT_FOUND);
		exit();
	}
}

if (0 < @$image['reg_user']) {
	$member_handler =& xoops_gethandler('member');
	$user = $member_handler->getUser($image['reg_user']);
	$xoopsTpl->assign('image_uid', $user->getVar('uid'));
	$xoopsTpl->assign('image_uname', $user->getVar('uname'));
}

if (is_object($xoopsUser)) {
	$user_id = $xoopsUser->getVar('uid');
	if (@$_COOKIE['spicky_comment_name']) {
		$xoopsTpl->assign('user_name', $_COOKIE['spicky_comment_name']);
	} else if ($xoopsUser->getVar('name')) {
		$xoopsTpl->assign('user_name', $xoopsUser->getVar('name'));
	} else {
		$xoopsTpl->assign('user_name', $xoopsUser->getVar('uname'));
	}
} else {
	$user_id = 0;
}

if ($image['public_level'] != 1 && $image['reg_user'] != $user_id) {
    redirect_header($return_url, 2, _MD_SPICKY_NO_RIGHT);
    exit();
}

$image_list = spicky_get_exists_image_list($mydirname, $image);

$paint_list = spicky_get_image_where('paint_from_id = ' . intval($image['id']), 0, 3);

$tool_list = spicky_get_tool_image($image['id']);
$xoopsTpl->assign('tool_list', $tool_list);

$bookmark_list = spicky_get_bookmarklist_list($user_id);

if (count(@$bookmark_list) == 0) {
	$bookmark_list_id = spicky_add_bookmarklist(_MD_SPICKY_BOOKMARK_DFT_NAME, '', $user_id);
	$bookmark_list = spicky_get_bookmarklist_list($user_id);
}

$xoopsTpl->assign('bookmark_list', $bookmark_list);

$xoopsTpl->assign('paint_list', $paint_list);

if (@$image['paint_from_id'] != '') {
	$paint_from_image = spicky_get_image($image['paint_from_id']);
	$xoopsTpl->assign('paint_from_image', $paint_from_image);
}

$xoopsTpl->assign('image_list', $image_list);

if (isset($_GET['size']) && 0 < $_GET['size']) {
	$size = $_GET['size'];
} else {
	$size = $xoopsModuleConfig['size_of_main_image'];
}
$xoopsTpl->assign('size', $size);

$gperm_super_user = spicky_checkright($mydirname, SPICKY_GPERM_SUPER_USER);
if (($gperm_super_user || ($image['reg_user'] == $user_id)) && $user_id != 0) {
    $xoopsTpl->assign('can_lock', 1);
    $xoopsTpl->assign('can_edit', 1);
}

$t = time();
$tm = localtime($t);
$year = $tm[5] + 1900;
$month = $tm[4] + 1;
$day = $tm[3];

$day_key = sprintf('%04d%02d%02d', $year, $month, $day);

if (isset($_SESSION['spicky_pv'][$day_key][$image['id']]) == false) {
	spicky_countup_image($_GET['id']);
	$old = @$_SESSION['spicky_pv'][$day_key];
	unset($_SESSION['spicky_pv']);
	$_SESSION['spicky_pv'][$day_key] = $old;
	$_SESSION['spicky_pv'][$day_key][$image['id']] = 1;
	
	$image['view']++;
}

$tag_list = spicky_get_tag_by_image_id($_GET['id']);
$tag = '';
foreach ($tag_list as $val) {
    $tag .= ' &nbsp; <A HREF="';
    if (@$_GET['m']) {
        $tag .= 'index.php?page=image_list&tag=' . urlencode($val['name']) . '&m=1';
    } else {
        if (SPICKY_DIRCUT_URL) {
            $tag .= XOOPS_URL . '/images/tag/' . urlencode($val['name']) . '/';
        } else if (SPICKY_SHORT_URL) {
            $tag .= XOOPS_URL . '/modules/' . $mydirname . '/images/tag/' . urlencode($val['name']) . '/';
        } else {
            $tag .= 'index.php?page=image_list&tag=' . urlencode($val['name']);
            if (@$_GET['m']) {
                $tag .= '&m=1';
            }
        }
    }
    $tag .= '" style="text-decoration:underline;">';
    $tag .= htmlspecialchars($val['name']) . "</A>\n";
}

if (@$_SESSION['spicky_sort'] == 0) {
	$sort = 1;
} else {
	$sort = @$_SESSION['spicky_sort'];
}
if (@$_SESSION['spicky_rating'] == 0) {
	$rating = 1;
} else {
	$raing = @$_SESSION['spicky_rating'];
}

if (@$_SESSION['spicky_keyword'] != '') {
	$prev_image_list = spicky_search_image_list($mydirname, @$_SESSION['spicky_keyword'], 'AND', 1, 0, '', $sort, @$_SESSION['spicky_tag'], $rating, 1, $image['id'], 0);
	$next_image_list = spicky_search_image_list($mydirname, @$_SESSION['spicky_keyword'], 'AND', 1, 0, '', $sort, @$_SESSION['spicky_tag'], $rating, 1, $image['id'], 1);
} else {
	$prev_image_list = spicky_get_image_list($mydirname, 0, 1, $sort, '', @$_SESSION['spicky_tag_id'], 1, $rating, @$_SESSION['spicy_tool_id'], 1, $image['id'], 0);
	$next_image_list = spicky_get_image_list($mydirname, 0, 1, $sort, '', @$_SESSION['spicky_tag_id'], 1, $rating, @$_SESSION['spicy_tool_id'], 1, $image['id'], 1);
}
$xoopsTpl->assign('prev_image', @$prev_image_list[0]);
$xoopsTpl->assign('next_image', @$next_image_list[0]);

if (@$xoopsModuleConfig['use_mini_comment']) {
    $gperm_mini_comment = spicky_checkright($mydirname, SPICKY_GPERM_MINI_COMMENT);
    $gperm_mini_comment_delete = spicky_checkright($mydirname, SPICKY_GPERM_MINI_COMMENT_DELETE);

    $comment_list = spicky_get_comment_list($image['id']);
    $xoopsTpl->assign('comment_list', $comment_list);
    $max = 0;
    foreach ($comment_list as $comment) {
        if ($max < $comment['disp_id']) {
            $max = $comment['disp_id'];
        }
    }
    
    if ($xoopsModuleConfig['use_mini_comment_max'] <= $max) {
        $gperm_mini_comment = 0;
        $xoopsTpl->assign('mini_comment_full', 1);
    }
    
    if (isset($_COOKIE['spicky_comment']) == false) {
        $_COOKIE['spicky_comment'] = $xoopsModuleConfig['use_mini_comment_show'];
    }

    $xoopsTpl->assign('gperm_mini_comment', $gperm_mini_comment);
    $xoopsTpl->assign('gperm_mini_comment_delete', $gperm_mini_comment_delete);
}


$xoopsTpl->assign('tag', $tag);
$xoopsTpl->assign('num_of_tag', count($tag_list));
$xoopsTpl->assign('mydirname', $mydirname);
$xoopsTpl->assign('image', $image);
$xoopsTpl->assign('xoops_config', $xoopsConfig);

$xoopsTpl->assign('mod_config', $xoopsModuleConfig);
if (@$image['title']) {
  $xoopsTpl->assign('xoops_pagetitle', $image['title']);
}

if (@$_GET['m']) {
	if (isset($_GET['size']) && 0 < $_GET['size']) {
		$size = $_GET['size'];
	} else {
		$size = 240;
	}
	$xoopsTpl->assign('size', $size);

	$xoopsTpl->assign('mobile_page', 'm_image.html');
	$xoopsTpl->display('db:' . $mydirname . '_m_main.html');
	exit();
}

$xoopsOption['template_main'] = $mydirname.'_image.html';

include XOOPS_ROOT_PATH.'/include/comment_view.php';

require_once XOOPS_ROOT_PATH.'/footer.php';

