<?php

if (defined('__SPICKY_MISC_PHP__')) {
    return;
}
define('__SPICKY_MISC_PHP__', 1);

require_once(dirname(dirname(__FILE__)) . '/constants.php');

function spicky_main_css($mydirname)
{
	global $xoopsTpl;
	
	$header = $xoopsTpl->get_template_vars( 'xoops_module_header' ) . "\n";
	
	if (preg_match('/\/modules\/' . $mydirname . '\/index\.php/', $header)) {
		return;
	}

	if (preg_match('/jquery/', $header) == false) {
		$header .= '<script type="text/javascript" src="' . XOOPS_URL . '/modules/' . $mydirname . '/jquery-1.3.2.min.js"></script>' . "\n";
		$header .= '<script type="text/javascript" src="' . XOOPS_URL . '/modules/' . $mydirname . '/jquery.cookie.js"></script>' . "\n";
	}
	
	$header .= "\n";
	$header .= '<link rel="stylesheet" type="text/css" media="all" href="' . XOOPS_URL . '/modules/' . $mydirname . '/index.php?page=main_css" />';
	$header .= "\n";

	$xoopsTpl->assign( 'xoops_module_header', $header);

}

function spicky_mkdir_p()
{
    global $mydirname;
    
    if (file_exists(XOOPS_ROOT_PATH . '/uploads/'. $mydirname) == false) {
        mkdir(XOOPS_ROOT_PATH . '/uploads/' . $mydirname);
    }

    if (file_exists(XOOPS_ROOT_PATH . '/uploads/'. $mydirname . '/tmp/') == false) {
        mkdir(XOOPS_ROOT_PATH . '/uploads/' . $mydirname . '/tmp/');
    }
}

function spicky_mkdir_p_number($id, $tmp=0)
{
    global $mydirname;
    
    spicky_mkdir_p();
    
    if ($tmp) {
    	$dir_tmp = '/tmp/';
    } else {
    	$dir_tmp = '/';
    }
    
    if (SPICKY_FLAT_DIR) {
    	return XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp;
    }
    
    $num1 = substr($id, -1, 1);
    $dir = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1;
    
    if (10 <= $id) {
        $num2 = substr($id, -2, 1);
        $dir = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1 . '/' . $num2;
    }
    if (100 <= $id) {
        $num3 = substr($id, -3, 1);
        $dir = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1 . '/' . $num2 . '/' . $num3;
    }
    
    if (@$num1 != '' && file_exists(XOOPS_ROOT_PATH . '/uploads/'. $mydirname . $dir_tmp . $num1) == false) {
        mkdir(XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1);
    }
    
    if (@$num2 != '' && file_exists(XOOPS_ROOT_PATH . '/uploads/'. $mydirname . $dir_tmp . $num1 . '/' . $num2) == false) {
        mkdir(XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1 . '/' . $num2);
    }
    
    if (@$num3 != '' && file_exists(XOOPS_ROOT_PATH . '/uploads/'. $mydirname . $dir_tmp . $num1 . '/' . $num2 . '/' . $num3) == false) {
        mkdir(XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $dir_tmp . $num1 . '/' . $num2 . '/' . $num3);
    }

    return $dir;
}

function spicky_move_tmp_to_image($src_id, $dest_id, $code, $type)
{
    global $mydirname;
    
    spicky_mkdir_p_number($dest_id);
    
    $src_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . '/tmp' . spicky_number_str($src_id) . '/' . $src_id . '_' . $code . '.' . $GLOBALS['spicky_image_ext'][$type];
    $dest_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . spicky_number_str($dest_id) . '/' . $dest_id . '_' . $code . '.' . $GLOBALS['spicky_image_ext'][$type];
    
    if (is_readable($src_file)) {
        copy($src_file, $dest_file);
        unlink($src_file);
    }
    
    foreach ($GLOBALS['spicky_max_xy'] as $size) {
	    $src_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . '/tmp' . spicky_number_str($src_id) . '/' . $src_id . '_' . $code . '_' . $size . '.' . $GLOBALS['spicky_image_ext'][$type];
    	$dest_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . spicky_number_str($dest_id) . '/' . $dest_id . '_' . $code . '_' . $size . '.' . $GLOBALS['spicky_image_ext'][$type];
    	if (is_readable($src_file)) {
            copy($src_file, $dest_file);
            unlink($src_file);
    	}
    }
}

function spicky_number_str($id)
{
    if (SPICKY_FLAT_DIR) {
    	return '/';
    }
    
    $num1 = substr($id, -1, 1);
    $str = '/' . $num1;
    
    if (10 <= $id) {
        $num2 = substr($id, -2, 1);
        $str .= '/' . $num2;
    }
    if (100 <= $id) {
        $num3 = substr($id, -3, 1);
        $str .= '/' . $num3;
    }
    
    return $str;
}

function spicky_make_image_path($mydirname, $image, $size=0, $tmp=0)
{
	if ($tmp) {
		$tmp_dir = '/tmp';
	} else {
		$tmp_dir = '';
	}
	
	$path = '/uploads/' . $mydirname . $tmp_dir . spicky_number_str($image['id']) . '/' . $image['id'] . '_' . $image['code'];

	$ext = $GLOBALS['spicky_image_ext'][$image['type']];

	if ($size) {
		$path .= '_' . $size;
	}
	$path .= '.' . $ext;
	
	return $path;
}

function spicky_make_image_url($mydirname, $image, $size=0)
{
	return XOOPS_URL . spicky_make_image_path($mydirname, $image, $size);
}

function spicky_get_randam_code()
{
    $str = '0123456789';
    $str .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $str .= 'abcdefghijklmnopqrstuvwxyz';

    $ret = '';
    for ($i=0; $i<8; $i++) {
        $ret .= substr($str, mt_rand(0, strlen($str)), 1);
    }
    
    return $ret;
}

function spicky_is_image_file($filename)
{
	$xy = @getimagesize($filename);

	if ($xy == false) {
		return 0;
	}
	
	if (@ImageCreateFromJpeg($filename) != 0) {
		return SPICKY_JPG_FILE;
	} else if (@ImageCreateFromPng($filename) != 0) {
		return SPICKY_PNG_FILE;
	} else if (@ImageCreateFromGif($filename) != 0) {
		return SPICKY_GIF_FILE;
	} else  {
		return 0;
	}
}

function spicky_check_image_width_height($filename, $max_width, $max_height)
{
	$size = getimagesize($filename);
	
	$width = $size[0];
	$height = $size[1];
	
	if ($max_width < $width || $max_height < $height) {
		// OK
		return false;
	} else {
		// NG
		return true;
	}
}

function spicky_image_resize($type, $src_image, $dest_image, $max_size)
{
	global $constpref;
	
    if (function_exists('ImageCreateTrueColor') == false) {
        return;
    }
    
    if (is_readable($src_image) == false) {
        return;
    }
    
    if ($type == SPICKY_JPG_FILE){
        $function_image_create = 'ImageCreateFromJpeg';
        $function_image = 'ImageJpeg';
    } elseif ($type == SPICKY_PNG_FILE) {
        $function_image_create = 'ImageCreateFromPng';
        $function_image = 'ImagePng';
    } elseif ($type == SPICKY_GIF_FILE) {
        $function_image_create = 'ImageCreateFromGif';
        $function_image = 'ImageGif';
    }

    $im_in = @$function_image_create($src_image);
    $size = getimagesize($src_image);
        
    if ($size == false) {
        // not image file
        return;
    }
    
    $width = $size[0];
    $height = $size[1];
    
    if ($max_size != 120 && ($width < $max_size && $height < $max_size)) {
    	return;
    }
    
    if ($width < $height) {
        $out_w = $max_size * ($width / $height);
        $out_h = $max_size;
    } else if ($width > $height) {
        $out_w = $max_size;
        $out_h = $max_size * ($height / $width);
    } else {
        // $width == $height
        $out_w = $max_size;
        $out_h = $max_size;
    }
    
    $im_out = imagecreatetruecolor($out_w, $out_h);
    $resize = imagecopyresampled($im_out, $im_in, 0, 0, 0, 0, $out_w, $out_h, $width, $height);
    
    $function_image($im_out, $dest_image);
    
    imagedestroy($im_in);
    imagedestroy($im_out);
}

function spicky_upload_image_resize($type, $src_image, $max_size, $org_size=0)
{
	global $spicky_image_ext;

    $dirname = dirname($src_image);
    $basename = basename($src_image);
    
    $arr = split('\.', $basename);
    
    if ($org_size) {
    	$filename = $arr[0] . '_org.' . $spicky_image_ext[$type];
    } else {
    	$filename = $arr[0] . '_' . $max_size . '.' . $spicky_image_ext[$type];
    }
    
    spicky_image_resize($type, $src_image, $dirname . '/' . $filename, $max_size);
}

function spicky_upload_image_resize_regular($type, $src_image)
{
	global $spicky_max_xy;
	
	foreach ($spicky_max_xy as $val) {
		spicky_upload_image_resize($type, $src_image, $val);
	}
}

function spicky_create_image_url($mydirname, $image, $size=640, $org=0, $tmp=0)
{
	$image_id = $image['id'];
	$width = $image['width'];
	$height = $image['height'];
	$code = $image['code'];
	$type = $image['type'];
	$alt = $image['title'];
	
	$xy = array_reverse($GLOBALS['spicky_max_xy']);
	
	$ext = $GLOBALS['spicky_image_ext'][$type];
	
	if (isset($params['tmp'])) {
		$dir_tmp = '/tmp';
	} else {
		$dir_tmp = '';
	}
	
	$dir = '/uploads/' . $mydirname . $dir_tmp;

	$dir = $dir . spicky_number_str($image_id);

	$image_file = XOOPS_ROOT_PATH . $dir . '/' . intval($image_id) . '_' . $code . '_';

	$flg_org = false;
	if ($org) {
		$flg_org = true;
		$out_w = $width;
		$out_h = $height;
	} else if ($width <= $size && $height <= $size) {
		$flg_org = true;
		$out_w = $width;
		$out_h = $height;
	} else {
		$flg = false;
		foreach ($xy as $val) {
			if ($size < $val) {
				continue;
			}
			if (is_readable($image_file . $val . '.' . $ext)) {
				$flg = true;
				$size = $val;
				break;
			}
		}
		
		if ($flg == false) {
			return array();
		}
		
	    if ($width < $height) {
	        $out_w = $size * ($width / $height);
    	    $out_h = $size;
	    } else if ($width > $height) {
	        $out_w = $size;
    	    $out_h = $size * ($height / $width);
	    } else {
	        // $width == $height
    	    $out_w = $size;
        	$out_h = $size;
	    }
	}
	
	$path = $dir . '/' . intval($image_id) . '_' . $code;
	if ($flg_org == false) {
		$path .= '_' . $size;
	}
	$path .= '.' . $ext;
	
	$url = XOOPS_URL . $path;
	$file = XOOPS_ROOT_PATH . $path;
	
	$ret = array('url' => $url, 'file' => $file, 'width' => $out_w, 'height' => $out_h);
	
	return $ret;
}

function spicky_tag_rate($tag_list)
{
	$max = array_shift($tag_list);
	
	if ($max == 0) {
		foreach ($tag_list as &$tag) {
			$tag['rate'] = 0.5;
		}
		return $tag_list;
	}
	
	$sqrt_max = sqrt($max);
	$sqrt_min = 0;
	
	foreach ($tag_list as $key => $tag) {
		$sqrt_count = sqrt($tag_list[$key]['count']);
		$tag_list[$key]['rate'] = ($sqrt_count - $sqrt_min) / ($sqrt_max - $sqrt_min);
	}
	
	$font_min_size = 9;
	$font_max_size = 28;
	foreach($tag_list as $key => $tag){
		$tag_list[$key]['fontsize'] = intval($tag_list[$key]['rate'] * ($font_max_size - $font_min_size) + $font_min_size);
	}

	
	return $tag_list;
}

function spicky_image_tag_set($image_id, $tag_list=null)
{
	if ($tag_list == null) {
		$tag_list = spicky_get_tag_by_image_id($image_id);
	}
	
	$tag_s = '';
	foreach ($tag_list as $tag) {
		$tag_s .= $tag['name'] . ' ';
	}
	$tag_s = trim($tag_s);
	
	spicky_update_image_tag_for_search($image_id, $tag_s);
}

function spicky_get_exists_image_list($mydirname, $image)
{
	$image_list = array();
	foreach ($GLOBALS['spicky_max_xy'] as $size) {
		$tmp = '/uploads/' . $mydirname . spicky_number_str($image['id']) . '/' . $image['id'] . '_' . $image['code'] . '_' . $size . '.' . $GLOBALS['spicky_image_ext'][$image['type']];

		if (is_readable(XOOPS_ROOT_PATH . $tmp)) {
			$arr = array();
		
			$width = $image['width'];
			$height = $image['height'];
		
			if ($width < $height) {
				$out_w = $size * ($width / $height);
				$out_h = $size;
			} else if ($width > $height) {
				$out_w = $size;
				$out_h = $size * ($height / $width);
			} else {
				// $width == $height
				$out_w = $size;
				$out_h = $size;
			}
	
			$arr['size'] = $size;
			$arr['width'] = $out_w;
			$arr['height'] = $out_h;
			$arr['dir'] = spicky_number_str($image['id']);
		
			$image_list[] = $arr;
		}
	}

	return $image_list;
}

function spicky_delete_image_func($mydirname, $image_id, $time_limit=false)
{
	global $xoopsModuleConfig;
	global $xoopsUser;

	$image = spicky_get_image($image_id);
	if (@$image['id'] == '') {
		return;
	}
	
	if (is_object($xoopsUser)) {
		$user_id = $xoopsUser->getVar('uid');
	} else {
		$user_id = 0;
	}

	$image_list = spicky_get_exists_image_list($mydirname, $image);
	
	foreach ($image_list as $item) {
		$image_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . $item['dir'] . '/' . $image['id'] . '_' . $image['code'] . '_' . $item['size'] . '.' . $GLOBALS['spicky_image_ext'][$image['type']];
		unlink($image_file);
	}
	
	$image_file = XOOPS_ROOT_PATH . '/uploads/' . $mydirname . spicky_number_str($image['id']) . '/' . $image['id'] . '_' . $image['code'] . '.' . $GLOBALS['spicky_image_ext'][$image['type']];
	@unlink($image_file);
	
	$tag_list = spicky_get_tag_by_image_id($image_id);
	
	foreach ($tag_list as $tag) {
	    spicky_countup_tag($tag['name'], -1);
	    spicky_delete_tag_image_link($tag['tag_image_id']);
	}

	if ($xoopsModuleConfig['real_delete'] == 1) {

		spicky_delete_image($image_id);
		
	} else {
		if ($time_limit) {
			spicky_update_image_statuts($image_id, SPICKY_STATUS_TIME_LIMIT_DELETED);
		} else if ($image['reg_user'] == $user_id) {
			spicky_update_image_statuts($image_id, SPICKY_STATUS_OWNER_DELETED);
		} else {
			spicky_update_image_statuts($image_id, SPICKY_STATUS_ADMIN_DELETED);
		}
	}
}

