<?php

if (defined('__SPICKY_DB_PHP__')) {
        return;
}
define('__SPICKY_DB_PHP__', 1);

function spicky_db_escape($str)
{
	$myts =& MyTextSanitizer::getInstance();

	return mysql_real_escape_string($myts->stripSlashesGPC($str));
}

function spicky_insert_image_tmp($title, $code, $width, $height, $type, $user_id, $upload_type='', $ip_address='')
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "INSERT INTO ";
    $sql .= $xoopsDB->prefix($mydirname . '_image_tmp');
    $sql .= " (id, code, width, height, title, `desc`, `type`, ";
    if ($upload_type) {
    	$sql .= "`upload_type`, ";
    }
    if ($ip_address) {
    	$sql .= "`ip_address`, ";
    }
    $sql .= "reg_time, reg_user) VALUES ( ";
    $sql .= " NULL, ";
    $sql .= " '" . spicky_db_escape ($code) . "', ";
    $sql .= intval($width) . ", " . intval($height) . ", ";
    $sql .= " '" . spicky_db_escape ($title) . "', ";
    $sql .= " '', ";
    $sql .= intval($type) . ", ";
    if ($upload_type) {
    	$sql .= intval($upload_type) . ', ';
    }
    if ($ip_address) {
    	$sql .= "'" . spicky_db_escape($ip_address) . "', ";
    }
    $sql .= intval(time()) . ", " . intval($user_id) . " );";

    $xoopsDB->queryF($sql);
    return $xoopsDB->getInsertId();
}

function spicky_get_image_tmp($image_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_image_tmp');
    $sql .= " WHERE id = " . intval($image_id);
    $sql .= " LIMIT 0, 1";

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_update_image_tmp($image_id, $type)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image_tmp');
    $sql .= ' SET ';
    $sql .= ' `type` = ' . intval($type) . ' ';
    $sql .= " WHERE id = " . intval($image_id);
    $sql .= " LIMIT 0, 1";

    $result = $xoopsDB->queryF($sql);
}

function spicky_update_image_tmp_master_id($image_id, $master_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image_tmp');
    $sql .= ' SET ';
    $sql .= ' `master_id` = ' . intval($master_id) . ' ';
    $sql .= " WHERE id = " . intval($image_id);

    $result = $xoopsDB->queryF($sql);
}

function spicky_insert_image($title, $desc, $code, $width, $height, $type, $user_id, $paint_from_id='', $status=null, $upload_type='', $ip_address='')
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "INSERT INTO ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " (id, code, width, height, title, `desc`, `type`, ";
    if ($paint_from_id != '') {
    	$sql .= " paint_from_id, ";
    }
    if (isset($status)) {
    	$sql .= " status, ";
    }
    if ($upload_type) {
    	$sql .= " `upload_type`, ";
    }
    if ($ip_address) {
    	$sql .= " `ip_address`, ";
    }
    $sql .= " reg_time, reg_user) VALUES ( ";
    $sql .= " NULL, ";
    $sql .= " '" . spicky_db_escape($code) . "', ";
    $sql .= intval($width) . ", " . intval($height) . ", ";
    $sql .= " '" . spicky_db_escape($title) . "', ";
    $sql .= " '" . spicky_db_escape($desc) . "', ";
    $sql .= intval($type) . ", ";
    if ($paint_from_id != '') {
        $sql .= intval($paint_from_id) . ", ";
    }
    if (isset($status)) {
        $sql .= intval($status) . ", ";
    }
    if ($upload_type) {
    	$sql .= intval($upload_type) . ', ';
    }
    if ($ip_address) {
    	$sql .= "'" . spicky_db_escape($ip_address) . "', ";
    }
    $sql .= intval(time()) . ", " . intval($user_id) . " );";

    $xoopsDB->queryF($sql);
    return $xoopsDB->getInsertId();
}

function spicky_get_image($image_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " WHERE id = " . intval($image_id);
    $sql .= " LIMIT 0, 1";

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_get_image_where($where, $offset, $limit)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " WHERE " . $where;
    $sql .= " LIMIT " . intval($offset) . ", " . intval($limit);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    while ($row = $xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_get_image_count($tag='', $user_id='', $public_level=1, $limit_level='', $tool_id='', $status=1)
{
    global $xoopsDB;
    global $mydirname;

    if ($tool_id != '') {
        $sql = "SELECT count(t.id) as cnt FROM ";
        $sql .= $xoopsDB->prefix($mydirname . '_tool_image_link') . ' AS ti, ';
        $sql .= $xoopsDB->prefix($mydirname . '_image') . ' AS i ';
        $sql .= " WHERE ti.tool_id = " . intval($tool_id) . ' AND ';
        $sql .= ' ti.image_id = i.id ';
        $sql .= ' AND `status` = ' . intval($status);
    } else if ($tag != '') {
        $sql = "SELECT count(i.id) AS cnt FROM ";
        $sql .= $xoopsDB->prefix($mydirname . '_image') . ' as i , ';
        $sql .= $xoopsDB->prefix($mydirname . '_tag_image_link') . ' as ti, ';
        $sql .= $xoopsDB->prefix($mydirname . '_tag'). ' AS t ';
        $sql .= ' WHERE t.id = ti.tag_id AND ti.image_id = i.id AND t.id = ' . intval($tag);
        if ($public_level) {
        	$sql .= ' AND i.public_level = ' . intval($public_level);
        }
        if ($limit_level == 1) {
        	$sql .= ' AND i.limit_level = 1 ';
        } else if ($limit_level == 2) {
        	$sql .= ' AND i.limit_level <> 1 ';
        }
        
        $sql .= ' AND `status` = ' . intval($status);
    } else {
        $sql = "SELECT count(id) AS cnt FROM ";
        $sql .= $xoopsDB->prefix($mydirname . '_image');
        $sql .= ' WHERE 1 ';
        if ($user_id) {
            $sql .= ' AND reg_user = ' . intval($user_id);
        }
        if ($public_level) {
            $sql .= ' AND public_level = ' . intval($public_level);
        }
        if ($limit_level == 1) {
        	$sql .= ' AND limit_level = 1 ';
        } else if ($limit_level == 2) {
        	$sql .= ' AND limit_level <> 1 ';
        }

        $sql .= ' AND `status` = ' . intval($status);
    }

    $result = $xoopsDB->query($sql);
    
    $row = $xoopsDB->fetchArray($result);
    
    return $row['cnt'];
}

function spicky_countup_image($image_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " SET `view` = `view` + 1 ";
    $sql .= " WHERE id = " . intval($image_id);

    $result = $xoopsDB->queryF($sql);
    
    $t = time();
    $tm = localtime($t);
    $year = $tm[5] + 1900;
    $month = $tm[4] + 1;
    $day = $tm[3];
    
    $tm2 = localtime(mktime(0, 0, 0, 1, 1, $year));

    $week = intval(($tm[7] + (7 - $tm2[6])) / 7);
    
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_access_count_daily');
    $sql .= " SET `count` = `count` + 1 ";
    $sql .= " WHERE image_id = " . intval($image_id) . ' AND ';
    $sql .= ' year = ' . intval($year) . ' AND ';
    $sql .= ' month = ' . intval($month) . ' AND ';
    $sql .= ' day = ' . intval($day);

    $result = $xoopsDB->queryF($sql);
    
    if ($xoopsDB->getAffectedRows() == 0) {
        $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_access_count_daily');
        $sql .= ' (image_id, `count`, `year`, `month`, `day`, `epoctime`) VALUES ( ';
        $sql .= intval($image_id) . ', 1, ' . intval($year) . ', ' . intval($month) . ', ';
        $sql .= intval($day) . ', ' . intval($t) . ' ) ';
        
        $result = $xoopsDB->queryF($sql);
    }
    
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_access_count_weekly');
    $sql .= " SET `count` = `count` + 1 ";
    $sql .= " WHERE image_id = " . intval($image_id) . ' AND ';
    $sql .= ' year = ' . intval($year) . ' AND ';
    $sql .= ' `week` = ' . intval($week);

    $result = $xoopsDB->queryF($sql);
    
    if ($xoopsDB->getAffectedRows() == 0) {
        $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_access_count_weekly');
        $sql .= ' (image_id, `count`, `year`, `week`, `epoctime`) VALUES ( ';
        $sql .= intval($image_id) . ', 1, ' . intval($year) . ', ' . intval($week) . ', ';
        $sql .= intval($t) . ' ) ';
        
        $result = $xoopsDB->queryF($sql);
    }
    
    
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_access_count_monthly');
    $sql .= " SET `count` = `count` + 1 ";
    $sql .= " WHERE image_id = " . intval($image_id) . ' AND ';
    $sql .= ' year = ' . intval($year) . ' AND ';
    $sql .= ' `month` = ' . intval($month);

    $result = $xoopsDB->queryF($sql);
    
    if ($xoopsDB->getAffectedRows() == 0) {
        $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_access_count_monthly');
        $sql .= ' (image_id, `count`, `year`, `month`, `epoctime`) VALUES ( ';
        $sql .= intval($image_id) . ', 1, ' . intval($year) . ', ' . intval($month) . ', ';
        $sql .= intval($t) . ' ) ';
        
        $result = $xoopsDB->queryF($sql);
    }
    
}

function spicky_get_image_list($mydirname, $offset=0, $limit=25, $order='', $user_id='', $tag_id=0, $public_level=1, $limit_level='', $tool_id='', $status=1, $base_image_id=0, $dir=0)
{
    global $xoopsDB;
    
    if ($tool_id != '') {
        $sql = "SELECT i.id as id, i.title as title, i.desc as `desc`, i.reg_user as reg_user, i.reg_time as reg_time, i.code as code, i.width as width, i.height as height, i.type as type, i.bookmark as bookmark, i.view as `view`, i.paint_from_id as paint_from_id, i.public_level as public_level, i.pasteok as pasteok, i.limit_level as limit_level FROM ";
        $sql .= $xoopsDB->prefix($mydirname . '_tool_image_link') . ' AS ti, ';
        $sql .= $xoopsDB->prefix($mydirname . '_image') . ' AS i ';
        $sql .= " WHERE ti.tool_id = " . intval($tool_id) . ' AND ';
        $sql .= ' ti.image_id = i.id ';
        $sql .= ' AND `status` = ' . intval($status) . ' ';
        if ($public_level) {
            $sql .= ' AND i.public_level = 1 ';
        }
        if ($limit_level == 1) {
            $sql .= ' AND i.limit_level = 1 ';
        } else if ($limit_level == 2) {
            $sql .= ' AND i.limit_level <> 1 ';
        }
		if ($user_id != '') {
    		$sql .= ' AND i.reg_user = ' . intval($user_id);
    	}        
        if ($base_image_id != 0) {
            if ($dir == 0) {
                $sql .= ' AND i.id < ' . intval($base_image_id) . ' ';
            } else {
                $sql .= ' AND ' . intval($base_image_id) . ' < i.id ';
            }
        }
    	if ($order != '' && 0 < intval($order)) {
    		if ($base_image_id && $dir == 1) {

				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time, i.id ';
    			} else if ($order == 2) {
    				$sql .= 'reg_time DESC, i.id DESC ';
				} else if ($order == 3) {
					$sql .= '`view`, i.id ';
				} else if ($order == 4) {
					$sql .= '`view` DESC, i.id DESC ';
				} else if ($order == 5) {
					$sql .= 'bookmark, i.id ';
				} else if ($order == 6) {
					$sql .= 'bookmark DESC, i.id DESC ';
				}
			} else {
    	
				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time DESC, i.id DESC ';
				} else if ($order == 2) {
    				$sql .= 'reg_time, i.id ';
    			} else if ($order == 3) {
    				$sql .= '`view` DESC, i.id DESC ';
    			} else if ($order == 4) {
    				$sql .= '`view`, i.id ';
    			} else if ($order == 5) {
    				$sql .= 'bookmark DESC, i.id DESC ';
    			} else if ($order == 6) {
    				$sql .= 'bookmark, i.id ';
    			}
    		}
    	}
    	
    	if ($base_image_id != 0) {
    		$sql .= " LIMIT 0, 1 ";
    	} else {
    		$sql .= " LIMIT " . intval($offset) . ", " . intval($limit) . ' ';
    	}        
    } else if (0 < $tag_id) {
    	$sql = "SELECT i.id as id, i.code as code, i.width as width, i.height as height, i.title as title, i.desc as `desc`, i.type as type, i.reg_user as reg_user, i.reg_time as reg_time, i.bookmark as bookmark, i.view as `view`, i.paint_from_id as paint_from_id, i.public_level as public_level, i.pasteok as pasteok, i.limit_level as limit_level FROM ";
        $sql .= $xoopsDB->prefix($mydirname . '_image') . ' as i , ';
        $sql .= $xoopsDB->prefix($mydirname . '_tag_image_link') . ' as ti, ';
        $sql .= $xoopsDB->prefix($mydirname . '_tag'). ' AS t ';
        $sql .= ' WHERE 1 ';
        if ($public_level) {
            $sql .= ' AND i.public_level = 1 ';
        }
        if ($limit_level == 1) {
            $sql .= ' AND i.limit_level = 1 ';
        } else if ($limit_level == 2) {
            $sql .= ' AND i.limit_level <> 1 ';
        }
		if ($user_id != '') {
    		$sql .= ' AND i.reg_user = ' . intval($user_id);
    	}
    	if (0 < @$tag_id) {
       		$sql .= ' AND t.id = ti.tag_id AND ti.image_id = i.id AND t.id = ' . intval($tag_id) . ' ';
        }
        
        $sql .= ' AND `status` = ' . intval($status);
        
        if ($base_image_id != 0) {
            if ($dir == 0) {
                $sql .= ' AND i.id < ' . intval($base_image_id) . ' ';
            } else {
                $sql .= ' AND ' . intval($base_image_id) . ' < i.id ';
            }
        }
        
    	if ($order != '' && 0 < intval($order)) {
    		if ($base_image_id && $dir == 1) {

				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time, i.id ';
    			} else if ($order == 2) {
    				$sql .= 'reg_time DESC, i.id DESC ';
				} else if ($order == 3) {
					$sql .= '`view`, i.id ';
				} else if ($order == 4) {
					$sql .= '`view` DESC, i.id DESC ';
				} else if ($order == 5) {
					$sql .= 'bookmark, i.id ';
				} else if ($order == 6) {
					$sql .= 'bookmark DESC, i.id DESC ';
				}
			} else {
    	
				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time DESC, i.id DESC ';
				} else if ($order == 2) {
    				$sql .= 'reg_time, i.id ';
    			} else if ($order == 3) {
    				$sql .= '`view` DESC, i.id DESC ';
    			} else if ($order == 4) {
    				$sql .= '`view`, i.id ';
    			} else if ($order == 5) {
    				$sql .= 'bookmark DESC, i.id DESC ';
    			} else if ($order == 6) {
    				$sql .= 'bookmark, i.id ';
    			}
    		}
    	}
    	
    	if ($base_image_id != 0) {
    		$sql .= " LIMIT 0, 1 ";
    	} else {
    		$sql .= " LIMIT " . intval($offset) . ", " . intval($limit) . ' ';
    	}
    } else {
    	$sql = "SELECT * FROM ";
    	$sql .= $xoopsDB->prefix($mydirname . '_image');
    	$sql .= ' WHERE 1 ';
        if ($public_level) {
			$sql .= ' AND public_level = 1 ';
		}
        if ($limit_level == 1) {
            $sql .= ' AND limit_level = 1 ';
        } else if ($limit_level == 2) {
            $sql .= ' AND limit_level <> 1 ';
        }
    	if ($user_id != '') {
    		$sql .= ' AND reg_user = ' . intval($user_id);
    	}
    	
        $sql .= ' AND `status` = ' . intval($status) . ' ';
        
        if ($base_image_id != 0) {
            if ($dir == 0) {
                $sql .= ' AND `id` < ' . intval($base_image_id) . ' ';
            } else {
                $sql .= ' AND ' . intval($base_image_id) . ' < `id` ';
            }
        }
        
    	if ($order != '' && 0 < intval($order)) {
    	
    		if ($base_image_id && $dir == 1) {

				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time, id ';
    			} else if ($order == 2) {
    				$sql .= 'reg_time DESC, id DESC ';
				} else if ($order == 3) {
					$sql .= '`view`, id ';
				} else if ($order == 4) {
					$sql .= '`view` DESC, id DESC ';
				} else if ($order == 5) {
					$sql .= 'bookmark, id ';
				} else if ($order == 6) {
					$sql .= 'bookmark DESC, id DESC ';
				}
			} else {
    	
				$sql .= ' ORDER BY ';
    			if ($order == 1) {
    				$sql .= 'reg_time DESC, id DESC ';
				} else if ($order == 2) {
    				$sql .= 'reg_time, id ';
    			} else if ($order == 3) {
    				$sql .= '`view` DESC, id DESC ';
    			} else if ($order == 4) {
    				$sql .= '`view`, id ';
    			} else if ($order == 5) {
    				$sql .= 'bookmark DESC, id DESC ';
    			} else if ($order == 6) {
    				$sql .= 'bookmark, id ';
    			}
    		}
    	}
        if ($base_image_id != 0) {
			$sql .= " LIMIT 0, 1 ";
        } else {
			$sql .= " LIMIT " . intval($offset) . ", " . intval($limit);
    	}
    }

    $result = $xoopsDB->query($sql);
    
    $list = array();
    
    while ($row=$xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_search_image_count($mydirname, $queryarray, $andor, $limit, $offset, $userid, $tag='', $limit_level='', $status=1)
{
    global $xoopsDB;
    
    $sql = 'SELECT count(id) AS cnt ';
    $sql .= " FROM ";
    $sql .= $xoopsDB->prefix($mydirname . "_image") . " ";
    $sql .= " WHERE ";
    $sql .= " 1 ";
								       
    if ( $userid != 0 ) {
		$sql .= " AND reg_user=".intval($userid)." ";
    }
    
	$sql .= " AND public_level = 1 ";
	if ($limit_level == 1) {
		$sql .= ' AND limit_level = 1 ';
	} else if ($limit_level == 2) {
		$sql .= ' AND limit_level <> 1 ';
	}
	$sql .= " AND `status` = " . intval($status) . ' ';
	
    if ( is_array($queryarray) && $count = count($queryarray) ) {
    	if (@$tag) {
			$sql .= " AND ((tag_for_search LIKE '%$queryarray[0]%')";
			for($i=1;$i<$count;$i++){
			    $sql .= " $andor ";
			    $sql .= "(tag_for_search LIKE '%$queryarray[$i]%')";
			}
			$sql .= ") ";
		} else {
			$sql .= " AND ((title LIKE '%$queryarray[0]%' OR `desc` LIKE '%$queryarray[0]%')";
			for($i=1;$i<$count;$i++){
			    $sql .= " $andor ";
			    $sql .= "(title LIKE '%$queryarray[$i]%' OR `desc` LIKE '%$queryarray[$i]%')";
			}
			$sql .= ") ";
		}
    }

    $result = $xoopsDB->query($sql);
    $list = array();

    $row = $xoopsDB->fetchArray($result);

	return intval($row['cnt']);
}

function spicky_search_image_list($mydirname, $queryarray, $andor, $limit, $offset, $userid, $order='', $tag='', $limit_level='', $status=1, $base_image_id=0, $dir=0)
{
    global $xoopsDB;

    $sql = 'SELECT * ';
    $sql .= " FROM ";
    $sql .= $xoopsDB->prefix($mydirname . "_image") . " ";
    $sql .= " WHERE ";
    $sql .= " public_level = 1 ";
    
    if ($limit_level == 1) {
    	$sql .= ' AND limit_level = 1 ';
    } else if ($limit_level == 2) {
    	$sql .= ' AND limit_level <> 1 ';
    }
	
    if ( $userid != 0 ) {
		$sql .= " AND reg_user=".intval($userid)." ";
    }
    
    $sql .= ' AND `status` = ' . intval($status) . ' ';
	
    if ( is_array($queryarray) && $count = count($queryarray) ) {
    	if (@$tag) {
			$sql .= " AND ((tag_for_search LIKE '%$queryarray[0]%') ";
			for($i=1;$i<$count;$i++){
			    $sql .= " $andor ";
			    $sql .= "(tag_for_search LIKE '%$queryarray[$i]%') ";
			}
			$sql .= " ) ";
		} else {
			$sql .= " AND ((title LIKE '%$queryarray[0]%' OR `desc` LIKE '%$queryarray[0]%') ";
			for($i=1;$i<$count;$i++){
			    $sql .= " $andor ";
			    $sql .= " (title LIKE '%$queryarray[$i]%' OR `desc` LIKE '%$queryarray[$i]%') ";
			}
			$sql .= " ) ";
		}
	}
	
	if ($base_image_id != 0) {
		if ($dir == 0) {
			$sql .= ' AND `id` < ' . intval($base_image_id) . ' ';
		} else {
			$sql .= ' AND ' . intval($base_image_id) . ' < `id` ';
		}
	}

	if ($order != '' && 0 < intval($order)) {
		if ($dir == 1) {
			$sql .= ' ORDER BY ';
			if ($order == 1) {
				$sql .= 'reg_time, id ';
			} else if ($order == 2) {
				$sql .= 'reg_time DESC, id DESC ';
			} else if ($order == 3) {
				$sql .= '`view`, id ';
			} else if ($order == 4) {
				$sql .= '`view` DESC, id DESC ';
			} else if ($order == 5) {
				$sql .= 'bookmark, id ';
			} else if ($order == 6) {
				$sql .= 'bookmark DESC, id DESC ';
			}
		} else {
			$sql .= ' ORDER BY ';
			if ($order == 1) {
				$sql .= 'reg_time DESC, id DESC ';
			} else if ($order == 2) {
				$sql .= 'reg_time, id ';
			} else if ($order == 3) {
				$sql .= '`view` DESC, id DESC ';
			} else if ($order == 4) {
				$sql .= '`view`, id ';
			} else if ($order == 5) {
				$sql .= 'bookmark DESC, id DESC ';
			} else if ($order == 6) {
				$sql .= 'bookmark, id ';
			}
		}
	}

	if ($base_image_id) {
		$result = $xoopsDB->query($sql,1,0);
	} else {
		$result = $xoopsDB->query($sql,$limit,$offset);
    }
    $list = array();

    while($row = $xoopsDB->fetchArray($result)){
    	$list[] = $row;
	}

	return $list;
}

function spicky_update_image($id, $title, $desc, $public_level, $pasteok, $limit_level, $user_id, $guest_password='', $status='', $exif='', $camera_model='', $time_limit=0)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " SET ";
    $sql .= " `title` = '" . spicky_db_escape($title) . "', ";
    $sql .= " `desc` = '" . spicky_db_escape($desc) . "', ";
    $sql .= " `public_level` = '" . intval($public_level) . "', ";
    $sql .= " `pasteok` = '" . intval($pasteok) . "', ";
    $sql .= " `limit_level` = '" . intval($limit_level) . "', ";
    $sql .= " `mod_user` = '" . intval($user_id) . "', ";
    $sql .= " `mod_time` = '" . time() . "' ";
    if ($guest_password != '') {
        $sql .= ", `guest_password` = '" . spicky_db_escape($guest_password) . "' ";
    }
    if ($exif != '') {
        $sql .= ", `exif` = '" . spicky_db_escape($exif) . "' ";
    }
    if ($camera_model != '') {
        $sql .= ", `camera_model` = '" . spicky_db_escape($camera_model) . "' ";
    }
    if ($status != '') {
        $sql .= ", `status` = " . intval($status) . ' ';
    }
    if (0 < $time_limit) {
        $sql .= ", `time_limit` = " . intval($time_limit) . ' ';
    }
    $sql .= ' WHERE id = ' . intval($id);
    
    $xoopsDB->queryF($sql);
}

function spicky_update_image_tag_for_search($id, $tag_for_search)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " SET ";
    $sql .= " `tag_for_search` = '" . spicky_db_escape($tag_for_search) . "' ";
    $sql .= ' WHERE id = ' . intval($id);

    $xoopsDB->queryF($sql);
}

function spicky_update_image_bookmark($id, $plus_maenas)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " SET ";
    if (0 < $plus_maenas) {
        $sql .= ' bookmark = bookmark + 1 ';
    } else {
        $sql .= ' bookmark = bookmark - 1 ';
    }
    $sql .= ' WHERE id = ' . intval($id);

    $xoopsDB->queryF($sql);
}

function spicky_update_image_statuts($id, $status)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " SET ";
    $sql .= ' `status` = ' . intval($status);
    $sql .= ' WHERE id = ' . intval($id);

    $xoopsDB->queryF($sql);
}

function spicky_delete_image($id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= ' WHERE ';
    $sql .= ' image_id = ' . intval($id);
    
    $result = $xoopsDB->queryF($sql);

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_tool_image_link');
    $sql .= ' WHERE ';
    $sql .= ' image_id = ' . intval($id);
    
    $result = $xoopsDB->queryF($sql);

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE ';
    $sql .= ' image_id = ' . intval($id);
    
    $result = $xoopsDB->queryF($sql);

    $sql = "DELETE FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_image');
    $sql .= " WHERE id = " . intval($id);

    $result = $xoopsDB->queryF($sql);
    
    return $result;
}

function spicky_get_tool_list()
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');

    $result = $xoopsDB->query($sql);
    
    $list = array();
    
    while ($row=$xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_get_tool($id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');
    $sql .= " WHERE id = " . intval($id);

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_get_tool_by_name($name)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');
    $sql .= " WHERE name = '" . @spicky_db_escape ($name) . "'";

    $result = $xoopsDB->query($sql);
    $row = $xoopsDB->fetchArray($result);
    
    if (isset($row['id'])) {
    	return true;
    } else {
    	return false;
    }
}

function spicky_insert_tool($name, $group, $order, $user_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "INSERT INTO ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');
    $sql .= " (id, name, `group`, `order`, reg_time, reg_user) VALUES ( ";
    $sql .= " NULL, ";
    $sql .= " '" . spicky_db_escape ($name) . "', ";
    $sql .= intval($group) . ", " . intval($order) . ", ";
    $sql .= intval(time()) . ", " . intval($user_id) . " );";
    
    $xoopsDB->queryF($sql);
    return $xoopsDB->getInsertId();
}

function spicky_update_tool($id, $name, $group, $order, $user_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "UPDATE ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');
    $sql .= " SET ";
    $sql .= " `name` = '" . spicky_db_escape ($name) . "', ";
    $sql .= " `group` = '" . intval($group) . "', ";
    $sql .= " `order` = '" . intval($order) . "', ";
    $sql .= " `mod_user` = '" . intval($user_id) . "', ";
    $sql .= " `mod_time` = '" . time() . "' ";
    $sql .= ' WHERE id = ' . intval($id);
    $sql .= ' ORDER BY `group`, `order` ';
    
    $xoopsDB->queryF($sql);
}

function spicky_delete_tool($id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "DELETE FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool');
    $sql .= ' WHERE id = ' . intval($id);
    
    $xoopsDB->queryF($sql);
}

function spicky_delete_tool_image_link($image_id)
{
    global $xoopsDB;
    global $mydirname;
      
    $sql = "DELETE FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool_image_link');
    $sql .= ' WHERE image_id = ' . intval($image_id);
    
    $xoopsDB->queryF($sql);
    return $xoopsDB->getInsertId();
}

function spicky_insert_tool_image_link($image_id, $tool_check)
{
    global $xoopsDB;
    global $mydirname;
    
    foreach ($tool_check as $val) {
	    $sql = "INSERT INTO ";
    	$sql .= $xoopsDB->prefix($mydirname . '_tool_image_link');
    	$sql .= " (image_id, tool_id) VALUES ( ";
    	$sql .= intval($image_id) . ", " . intval($val) . " );";
    
    	$xoopsDB->queryF($sql);
    }
}

function spicky_select_tool_image_link($image_id)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = "SELECT * FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool_image_link');
    $sql .= " WHERE image_id = " . intval($image_id);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    while ($row = $xoopsDB->fetchArray($result)) {
    	$list[$row['tool_id']] = $row;
    }
    
    return $list;
}

function spicky_get_tool_image($image_id)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = "SELECT t.id as id, t.name as name FROM ";
    $sql .= $xoopsDB->prefix($mydirname . '_tool_image_link') . ' AS ti, ';
    $sql .= $xoopsDB->prefix($mydirname . '_tool') . ' AS t ';
    $sql .= " WHERE ti.image_id = " . intval($image_id) . ' AND ';
    $sql .= ' ti.tool_id = t.id ';

    $result = $xoopsDB->query($sql);
    
    $list = array();
    while ($row = $xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_get_tag_by_name($name)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = 'SELECT id FROM ' . $xoopsDB->prefix($mydirname . '_tag');
    $sql .= " WHERE name = '" . spicky_db_escape($name) . "'";
    
    $result = $xoopsDB->query($sql);
        
    $row = $xoopsDB->fetchArray($result);
        
    if ($row) {
	return $row['id'];
    } else {
	return '';
    }
}

function spicky_get_tag_hot_list($mydirname, $offset=0, $limit=100, $limit_level='', $sort='', $lowest='')
{
    global $xoopsDB;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_tag');
    $sql .= ' WHERE 0 < `count` ';
    if ($limit_level != '') {
        if ($limit_level == 1) {
            $sql .= ' AND limit_level = 1 ';
        } else if ($limit_level == 2) {
            $sql .= ' AND limit_level <> 1 ';
        }
    }
    if ($lowest != '') {
      $sql .= ' AND ' . intval($lowest) . ' <= `count` ';
    }
    if ($sort == 1 || $sort == '') {
        $sql .= ' ORDER BY hot_time DESC ';
    } else {
        $sql .= ' ORDER BY `count` DESC ';
    }
    $sql .= ' LIMIT ' . intval($offset) . ', ' . intval($limit);
    
    $result = $xoopsDB->query($sql);

    $list = array();
    $max = 0;
    
    while ($row = $xoopsDB->fetchArray($result)) {
        $list[] = $row;
        if ($max < $row['count']) {
            $max = $row['count'];
        }
    }
    
    array_unshift($list, $max);
    
    return $list;
}

function spicky_get_tag_by_id($id)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_tag');
    $sql .= " WHERE id = '" . intval($id) . "'";
    
    $result = $xoopsDB->query($sql);
        
    $row = $xoopsDB->fetchArray($result);
        
    return $row;
}

function spicky_get_tag_by_image_id($image_id)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = 'SELECT t.id AS id, ti.id AS tag_image_id, ti.tag_id AS tag_id, t.name AS name, ti.lock AS `lock` ';
    $sql .= 'FROM ' . $xoopsDB->prefix($mydirname . '_tag') . ' AS t, ';
    $sql .= $xoopsDB->prefix($mydirname . '_tag_image_link') . ' AS ti ';
    $sql .= ' WHERE ';
    $sql .= 'ti.image_id = ' . intval($image_id) . ' AND ';
    $sql .= 't.id = ti.tag_id ';

    $result = $xoopsDB->query($sql);
    
    $list = array();
    
    while ($row = $arr = $xoopsDB->fetchArray($result)) {
        $list[] = $row;
    }
    
    return $list;
}

function spicky_add_tag($tag_name, $user_id, $limit_level='')
{
    global $xoopsDB;
    global $mydirname;
    
    $id = spicky_get_tag_by_name($tag_name);

    if ($id) {
	// ϿѤ
	return $id;
    }
        
    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_tag');
    $sql .= ' ( ';
    $sql .= 'name, reg_time, reg_user ';
    if ($limit_level) {
        $sql .= ' , limit_level ';
    }
    $sql .= ' ) VALUES ( ';
    $sql .= "'" . spicky_db_escape($tag_name) . "', ";
    $sql .= time() . ', ';
    $sql .= intval($user_id) . ' ';
    if ($limit_level) {
        $sql .= ' , ' . intval($limit_level);
    }
    $sql .= ' ) ';
    
    $result = $xoopsDB->queryF($sql);
        
    return mysql_insert_id();
}

function spicky_countup_tag($tag_name, $plug)
{
    global $xoopsDB;
    global $mydirname;
    
//    $tag = spicky_get_tag_by_id($tag_id);
//    if (isset($tag['id'])) {
//        // ϿѤ
//        return $id;
//    }
        
    $sql = 'UPDATE ' . $xoopsDB->prefix($mydirname . '_tag');
    $sql .= ' SET ';
    if (0 < $plug) {
        $sql .= ' `count` = `count` + 1 ';
        $sql .= ' , hot_time = ' . time();
    } else {
        $sql .= ' `count` = `count` - 1 ';
    }
    $sql .= " WHERE name = '" . spicky_db_escape($tag_name) . "' ";
    
    $result = $xoopsDB->queryF($sql);
        
    return mysql_insert_id();
}

function spicky_add_tag_to_image($image_id, $tag_name, $user_id, $limit_level)
{
    global $xoopsDB;
    global $mydirname;

    $tag_id = spicky_add_tag($tag_name, $user_id, $limit_level);

    if (spicky_get_tag_image($image_id, $tag_id)) {
        // ϿѤ
        return $tag_id;
    }
        
    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= ' ( ';
    $sql .= 'tag_id, image_id, reg_time, reg_user ) VALUES ( ';
    $sql .= intval($tag_id) . ', ';
    $sql .= intval($image_id) . ', ';
    $sql .= time() . ', ';
    $sql .= intval($user_id) . ' ';
    $sql .= ' ) ';

    $result = $xoopsDB->queryF($sql);
    
    return mysql_insert_id();
}

function spicky_get_tag_image($image_id, $tag_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT id FROM ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= " WHERE tag_id = " . intval($tag_id) . ' AND ';
    $sql .= ' image_id = ' . intval($image_id);

    $result = $xoopsDB->query($sql);
        
    $row = $xoopsDB->fetchArray($result);
        
    if ($row) {
	return $row['id'];
    } else {
	return '';
    }
}

function spicky_get_tag_image_by_id($id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= " WHERE id = " . intval($id);

    $result = $xoopsDB->query($sql);
        
    $row = $xoopsDB->fetchArray($result);

    return $row;
}

function spicky_delete_tag_image_link($id)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= ' WHERE ';
    $sql .= ' id = ' . intval($id);
    
    $result = $xoopsDB->queryF($sql);
}

function spicky_lock_tag_image_link($id, $lock)
{
    global $xoopsDB;
    global $mydirname;
    
    $sql = 'UPDATE ' . $xoopsDB->prefix($mydirname . '_tag_image_link');
    $sql .= ' SET `lock` = ' . intval($lock);
    $sql .= ' WHERE ';
    $sql .= ' id = ' . intval($id);
    
    $result = $xoopsDB->queryF($sql);
}

function spicky_get_bookmark_list($bookmark_list_id, $offset, $limit, $order='')
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT b.image_id as id, i.code as code, i.reg_user as reg_user, ';
    $sql .= ' i.title as title, i.desc as `desc`, i.type as `type`, ';
    $sql .= ' i.width as width, i.height as height, i.view as `view`, ';
    $sql .= ' b.id as bookmark_id ';
    $sql .= ' FROM ';
    $sql .= $xoopsDB->prefix($mydirname . '_bookmark') . ' AS b, ';
    $sql .= $xoopsDB->prefix($mydirname . '_image') . ' AS i ';
    $sql .= ' WHERE ';
    $sql .= ' b.bookmark_list_id = '  . intval($bookmark_list_id) . ' AND ';
    $sql .= ' b.image_id = i.id ';
    if ($order != '' && 0 < intval($order)) {
    	$sql .= ' ORDER BY ';
    	if ($order == 1) {
    		$sql .= 'i.reg_time DESC ';
    	} else if ($order == 2) {
    		$sql .= 'i.reg_time ';
    	} else if ($order == 3) {
    		$sql .= 'i.view DESC ';
    	} else if ($order == 4) {
    		$sql .= 'i.view ';
    	} else if ($order == 5) {
    		$sql .= 'i.bookmark DESC ';
    	} else if ($order == 6) {
    		$sql .= 'i.bookmark ';
    	}
    }
    $sql .= ' LIMIT ' . intval($offset) . ', ' . intval($limit);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    
    while ($row = $xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_get_bookmark_count($bookmark_list_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT count(id) AS cnt FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE ';
    $sql .= ' bookmark_list_id = '  . intval($bookmark_list_id);

    $result = $xoopsDB->query($sql);
    
    $row = $xoopsDB->fetchArray($result);
    
    return intval($row['cnt']);
}

/*
function spicky_get_bookmark_by_image_id($image_id, $user_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE ';
    $sql .= ' user_id = '  . intval($user_id) . ' AND ';
    $sql .= ' image_id = ' . intval($image_id);

    $result = $xoopsDB->query($sql);
        
    return $xoopsDB->fetchArray($result);
}

function spicky_add_bookmark($image_id, $user_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' ( ';
    $sql .= 'user_id, image_id, reg_time, reg_user ) VALUES ( ';
    $sql .= intval($user_id) . ', ';
    $sql .= intval($image_id) . ', ';
    $sql .= time() . ', ';
    $sql .= intval($user_id) . ' ';
    $sql .= ' ) ';

    $result = $xoopsDB->queryF($sql);
        
    return mysql_insert_id();
}

function spicky_delete_bookmark($bookmark_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE id = ' . intval($bookmark_id);

    return $xoopsDB->queryF($sql);
}
*/

function spicky_get_bookmarklist_list($user_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_bookmark_list');
    $sql .= ' WHERE ';
    $sql .= ' user_id = '  . intval($user_id);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    while ($row = $xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_get_bookmarklist($bookmark_list_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_bookmark_list');
    $sql .= ' WHERE ';
    $sql .= ' id = '  . intval($bookmark_list_id);

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_add_bookmarklist($name, $desc, $user_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_bookmark_list');
    $sql .= ' ( ';
    $sql .= '`name`, `desc`, user_id, reg_time, reg_user ) VALUES ( ';
    $sql .= "'" . spicky_db_escape($name) . "', ";
    $sql .= "'" . spicky_db_escape($desc) . "', ";
    $sql .= intval($user_id) . ', ';
    $sql .= time() . ', ';
    $sql .= intval($user_id) . ' ';
    $sql .= ' ) ';

    $result = $xoopsDB->queryF($sql);
    
    return mysql_insert_id();
}

function spicky_get_bookmark_by_image_id($image_id, $bookmark_list_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE ';
    $sql .= ' bookmark_list_id = '  . intval($bookmark_list_id) . ' AND ';
    $sql .= ' image_id = ' . intval($image_id);

    $result = $xoopsDB->query($sql);
        
    return $xoopsDB->fetchArray($result);
}

function spicky_add_bookmark($image_id, $bookmark_list_id, $user_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' ( ';
    $sql .= 'bookmark_list_id, user_id, image_id, reg_time, reg_user ) VALUES ( ';
    $sql .= intval($bookmark_list_id) . ', ';
    $sql .= intval($user_id) . ', ';
    $sql .= intval($image_id) . ', ';
    $sql .= time() . ', ';
    $sql .= intval($user_id) . ' ';
    $sql .= ' ) ';

    $result = $xoopsDB->queryF($sql);
        
    return mysql_insert_id();
}

function spicky_delete_bookmark($bookmark_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE id = ' . intval($bookmark_id);

    return $xoopsDB->queryF($sql);
}

function spicky_get_bookmark($bookmark_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE id = ' . intval($bookmark_id);

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_delete_bookmarklist($bookmark_list_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_bookmark_list');
    $sql .= ' WHERE id = ' . intval($bookmark_list_id);
    
    return $xoopsDB->queryF($sql);

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_bookmark');
    $sql .= ' WHERE bookmark_list_id = ' . intval($bookmark_list_id);
    
    return $xoopsDB->queryF($sql);
}

function spicky_update_bookmarklist($bookmark_list_id, $name, $desc, $public_level)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'UPDATE ' . $xoopsDB->prefix($mydirname . '_bookmark_list');
    $sql .= ' SET ';
    $sql .= " name = '" . spicky_db_escape($name) . "', ";
    $sql .= " `desc` = '" . spicky_db_escape($desc) . "', ";
    $sql .= " public_level = '" . intval($public_level) . "' ";
    $sql .= ' WHERE id = ' . intval($bookmark_list_id);

    return $xoopsDB->queryF($sql);
}

function spicky_insert_comment($image_id, $user_id, $name, $body)
{
    global $xoopsDB;
    global $mydirname;
    
    $disp_id = spicky_get_comment_disp_id($image_id);
    $disp_id++;

    $sql = 'INSERT INTO ' . $xoopsDB->prefix($mydirname . '_comment');
    $sql .= ' ( `disp_id`, image_id, `name`, `body`, reg_time, reg_user ) VALUES ';
    $sql .= ' ( ' . intval($disp_id) . ', ' . intval($image_id) . ", '" . spicky_db_escape($name) . "', ";
    $sql .= "'" . spicky_db_escape($body) . "', ";
    $sql .= time() . ', ' . intval($user_id) . ')';

    return $xoopsDB->queryF($sql);
}

function spicky_get_comment($comment_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_comment');
    $sql .= ' WHERE ';
    $sql .= ' id = '  . intval($comment_id);

    $result = $xoopsDB->query($sql);
    
    return $xoopsDB->fetchArray($result);
}

function spicky_get_comment_disp_id($image_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT max(disp_id) as disp_id FROM ' . $xoopsDB->prefix($mydirname . '_comment');
    $sql .= ' WHERE ';
    $sql .= ' image_id = '  . intval($image_id);

    $result = $xoopsDB->query($sql);
    
    $row = $xoopsDB->fetchArray($result);
    
    if (intval($row['disp_id']) == 0) {
        return 0;
    } else {
        return intval($row['disp_id']);
    }
}

function spicky_get_comment_list($image_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_comment');
    $sql .= ' WHERE ';
    $sql .= ' image_id = '  . intval($image_id);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    while ($row=$xoopsDB->fetchArray($result)) {
    	$list[] = $row;
    }
    
    return $list;
}

function spicky_delete_comment($comment_id)
{
    global $xoopsDB;
    global $mydirname;

    $sql = 'DELETE FROM ' . $xoopsDB->prefix($mydirname . '_comment');
    $sql .= ' WHERE id = ' . intval($comment_id);
    
    return $xoopsDB->queryF($sql);
}

