<?php

require_once XOOPS_TRUST_PATH.'/modules/d3forum/class/D3commentAbstract.class.php' ;
require_once XOOPS_TRUST_PATH.'/modules/d3forum/include/comment_functions.php' ;


// a class for d3forum comment integration
class SpickyD3comment extends D3commentAbstract {

function fetchSummary( $external_link_id )
{
	global $xoopsDB;

	$db =& Database::getInstance() ;
	$myts =& MyTextsanitizer::getInstance() ;

	$module_handler =& xoops_gethandler( 'module' ) ;
	$module =& $module_handler->getByDirname( $this->mydirname ) ;

	$id = intval( $external_link_id ) ;
	$mydirname = $this->mydirname ;
	if( preg_match( '/[^0-9a-zA-Z_-]/' , $mydirname ) ) die( 'Invalid mydirname' ) ;

	$mytrustdirpath = dirname(dirname(__FILE__)) ;

    $sql = 'SELECT * FROM ' . $xoopsDB->prefix($mydirname . '_image');
    $sql .= ' WHERE ';
    $sql .= ' id = '  . intval($id);

    $result = $xoopsDB->query($sql);
    $image = $xoopsDB->fetchArray($result);
    
	if( $image ){

		$subject4assign = $image['title'];
		$summary4assign = $image['desc'];

	} else {

		$subject4assign = '' ;
		$summary4assign = '' ;

	}
	
	$subject4assign = '' ;
	$summary4assign = '' ;

	return array(
		'dirname' => $mydirname ,
		'module_name' => $module->getVar( 'name' ) ,
		'subject' => $subject4assign ,
		'uri' => XOOPS_URL.'/modules/'.$mydirname.'/index.php?page=image&amp;id='.$id ,
		'summary' => $summary4assign ,
	) ;


}


// get id from <{$image.id}>
function external_link_id( $params )
{
	$image = $this->smarty->get_template_vars( 'image' ) ;
	return intval( $image['id'] ) ;
}


// get escaped subject from <{$image.title}>
function getSubjectRaw( $params )
{
	$story = $this->smarty->get_template_vars( 'image' ) ;
	return $this->unhtmlspecialchars( $story['title'] , ENT_QUOTES ) ;
}



}

?>