<?php

function smarty_function_spicky_image($params, &$smarty)
{
	if (isset($params['mydirname']) == false) {
		return ' no set mydirname in ' . __FILE__ . ' ';
	}
	
	$mydirname = $params['mydirname'];
	
	require_once(XOOPS_TRUST_PATH . '/modules/spicky/constants.php');

	if (isset($params['image']) == false) {
		return 'syntax error ' . __FILE__;
	}
	
	$image_id = $params['image']['id'];
	$width = $params['image']['width'];
	$height = $params['image']['height'];
	$size = $params['image']['size'];
	$code = $params['image']['code'];
	$type = $params['image']['type'];
	$alt = @$params['image']['title'];
	$class = @$params['class'];
	
	if (isset($params['size'])) {
		$size = intval($params['size']);
	}
	
	$xy = array_reverse($GLOBALS['spicky_max_xy']);
	
	$arr = array(1 => 'gif', 2 => 'jpg', 3 => 'png');
	$ext = $arr[$type];
	
	if (isset($params['tmp'])) {
		$dir_tmp = '/tmp/';
	} else {
		$dir_tmp = '/';
	}
	
	$dir = '/uploads/' . $mydirname . $dir_tmp;
	
	if (SPICKY_FLAT_DIR) {
		// do nothing
	} else {
		$num1 = substr($image_id, -1, 1);
		$dir .= $num1;
		if (10 <= $image_id) {
			$num2 = substr($image_id, -2, 1);
			$dir .= '/' . $num2;
		}
		if (100 <= $image_id) {
			$num3 = substr($image_id, -3, 1);
			$dir .= '/' . $num3;
		}
	}

	$image_file = XOOPS_ROOT_PATH . $dir . '/' . intval($image_id) . '_' . $code . '_';

	$flg_org = false;
	if (@$params['org']) {
		$flg_org = true;
		$out_w = $width;
		$out_h = $height;
	} else if ($width <= $size && $height <= $size) {
		$flg_org = true;
		$out_w = $width;
		$out_h = $height;
	} else {
		$flg = false;
		
		foreach ($xy as $val) {
			if ($size < $val) {
				continue;
			}
			if (is_readable($image_file . $val . '.' . $ext)) {
				$flg = true;
				$size = $val;
				break;
			}
		}
		
		if ($flg == false) {
			// image not found 
		} else if ($width < $height) {
	        $out_w = $size * ($width / $height);
    	    $out_h = $size;
	    } else if ($width > $height) {
	        $out_w = $size;
    	    $out_h = $size * ($height / $width);
	    } else {
	        // $width == $height
    	    $out_w = $size;
        	$out_h = $size;
	    }
	}
		
	$url = $dir . '/' . intval($image_id) . '_' . $code;
	if ($flg_org == false) {
		$url .= '_' . $size;
	}
	$url .= '.' . $ext;
	
	if (is_readable(XOOPS_ROOT_PATH . $url) == false) {
		$url = XOOPS_URL . '/modules/' . $mydirname . '/image/noimage.png';
		$out_w = 100;
		$out_h = 100;
		$alt = 'no image';
	} else {
		$url = XOOPS_URL . $url;
	}
	
	$ret = '<img src="' . $url . '" width="' . intval($out_w);
	$ret .= '" height="' . intval($out_h) . '" alt="' . htmlspecialchars($alt) . '"';
	if ($param['border'] == 0) {
		$ret .= ' border="0"';
	}
	if (@$class != '') {
		$ret .= ' class="' . $class . '" ';
	}
	$ret .= ' />';
	
	return $ret;
}

