<?php
/*
 * Actung Baby - Kids Class by Yoshi Sakai ( a.k.a bluemoon )
 */

class ActionHandler {
	var $mTable = "";
	var $mPrimary = "";
	var $records = array();
	var $debstr = "";
	var $message = "";
	var $model = "";
	var $ctrl = "";
	var $criteria;
	var $iamadmin = false;
	var $_post = array();
	/*
	 *  Initial Handler Section
	 */	
	function ActionHandler($ctrl=""){
		global $xoopsUserIsAdmin;
		//$this->ctrl = "edit" ;
		$this->iamadmin = $xoopsUserIsAdmin;
		$this->model = "searchresults" ;
		$this->ctrl = "sendPM" ;
	}
	/*
	 *  Global Task Section
	 */	
	function load(){
		return 1;
	}
	function assignRecords(){
		global $xoopsTpl;
		$debstr = "";	//$this->debstr;
		$xoopsTpl->assign( 'debstr', $debstr );		// assign debug strings
		$xoopsTpl->assign( 'message', $this->message );
		$xoopsTpl->assign( 'model', $this->model );
		$xoopsTpl->assign( 'ctrl', $this->ctrl );
		/*
		 * from old xoopsmembers source
		 */
		$xoopsTpl->assign('lang_search', _MM_SEARCH);
		$xoopsTpl->assign('lang_results', _MM_RESULTS);
		$xoopsTpl->assign('lang_username', _MM_UNAME);
		$xoopsTpl->assign('lang_realname', _MM_REALNAME);
		$xoopsTpl->assign('lang_avatar', _MM_AVATAR);
		$xoopsTpl->assign('lang_email', _MM_EMAIL);
		$xoopsTpl->assign('lang_privmsg', _MM_PM);
		$xoopsTpl->assign('lang_regdate', _MM_REGDATE);
		$xoopsTpl->assign('lang_lastlogin', _MM_LASTLOGIN);
		$xoopsTpl->assign('lang_posts', _MM_POSTS);
		$xoopsTpl->assign('lang_url', _MM_URL);
		$xoopsTpl->assign('lang_admin', _MM_ADMIN);
		if ( $this->iamadmin ) {
			$xoopsTpl->assign('is_admin', true);
		}
	}
	function debug(){
		return $this->debstr;
	}
	/*
	 *  Private Task Section
	 */	
	private function AddCriteriaWithTime($cname,$param,$cal){
		$time = time() - (60 * 60 * 24 * $param);
		if ( $time > 0 ) {
			$this->criteria->add(new Criteria($cname, $time, $cal));
		}
	}
	private function AddCriteriaWithMatch($cname, $param, $match= XOOPS_MATCH_START){
		switch ( $match ) {
			case XOOPS_MATCH_START:
				$this->criteria->add(new Criteria($cname, $param .'%', 'LIKE'));
				break;
			case XOOPS_MATCH_END:
				$this->criteria->add(new Criteria($cname, '%'.$param, 'LIKE'));
				break;
			case XOOPS_MATCH_EQUAL:
				$this->criteria->add(new Criteria($cname, $param));
				break;
			case XOOPS_MATCH_CONTAIN:
				$this->criteria->add(new Criteria($cname, '%'.$param.'%', 'LIKE'));
				break;
		}
		
	}
	private function getParam(){
		$myts =& MyTextSanitizer::getInstance();
		/*
		 * Page ctrl
		 */
		$validsort = array("uname", "email", "last_login", "user_regdate", "posts");
		$this->_post['user_sort'] = (!in_array($_POST['user_sort'], $validsort)) ? "uname" : $_POST['user_sort'];
		$this->_post['user_order'] = "ASC";
		if ( isset($_POST['user_order']) && $_POST['user_order'] == "DESC") {
			$this->_post['user_order'] = "DESC";
		}
		$this->_post['limit'] = (!empty($_POST['limit'])) ? intval($_POST['limit']) : 20;
		if ( $this->_post['limit'] == 0 || $this->_post['limit'] > 50 ) {
			$this->_post['limit'] = 50;
		}
		$this->_post['start'] = (!empty($_POST['start'])) ? intval($_POST['start']) : 0;		
		/*
		 * From input
		 */	
		if ( !empty($_POST['user_uname']) ) {
			$this->_post['user_uname_match'] = (!empty($_POST['user_uname_match'])) ? intval($_POST['user_uname_match']) : XOOPS_MATCH_START;
			$this->_post['user_uname'] = $myts->addSlashes( trim( $_POST['user_uname']) );
		}
		if ( !empty($_POST['user_name']) ) {
			$this->_post['user_name_match'] = (!empty($_POST['user_name_match'])) ? intval($_POST['user_name_match']) : XOOPS_MATCH_START;
			$this->_post['user_name'] = $myts->addSlashes( trim( $_POST['user_name']) );
		}
		if ( !empty($_POST['user_email']) ) {
			$this->_post['user_email_match'] = (!empty($_POST['user_email_match'])) ? intval($_POST['user_email_match']) : XOOPS_MATCH_START;
			$this->_post['user_email'] = $myts->addSlashes( trim( $_POST['user_email']) );
		}
		if ( !empty($_POST['user_url']) ) {
			$this->_post['user_url'] = $myts->addSlashes(formatURL(trim($_POST['user_url'])));
		}
		if ( !empty($_POST['user_icq']) ) {
			$this->_post['user_icq_match'] = (!empty($_POST['user_icq_match'])) ? intval($_POST['user_icq_match']) : XOOPS_MATCH_START;
			$this->_post['user_icq'] = $myts->addSlashes( trim( $_POST['user_icq']) );
		}
		if ( !empty($_POST['user_aim']) ) {
			$this->_post['user_aim_match'] = (!empty($_POST['user_aim_match'])) ? intval($_POST['user_aim_match']) : XOOPS_MATCH_START;
			$this->_post['user_aim'] = $myts->addSlashes( trim( $_POST['user_aim']) );
		}
		if ( !empty($_POST['user_yim']) ) {
			$this->_post['user_yim_match'] = (!empty($_POST['user_yim_match'])) ? intval($_POST['user_yim_match']) : XOOPS_MATCH_START;
			$this->_post['user_yim'] = $myts->addSlashes( trim( $_POST['user_yim']) );
		}
		if ( !empty($_POST['user_msnm']) ) {
			$this->_post['user_msnm_match'] = (!empty($_POST['user_msnm_match'])) ? intval($_POST['user_msnm_match']) : XOOPS_MATCH_START;
			$this->_post['user_msnm'] = $myts->addSlashes( trim( $_POST['user_msnm']) );
		}
		if ( !empty($_POST['user_from']) ) {
			$this->_post['user_from'] = $myts->addSlashes(formatfrom(trim($_POST['user_from'])));
		}
		if ( !empty($_POST['user_intrest']) ) {
			$this->_post['user_intrest'] = $myts->addSlashes(formatintrest(trim($_POST['user_intrest'])));
		}
		if ( !empty($_POST['user_occ']) ) {
			$this->_post['user_occ'] = $myts->addSlashes(formatocc(trim($_POST['user_occ'])));
		}
		if ( !empty($_POST['user_lastlog_more']) && is_numeric($_POST['user_lastlog_more']) ) {
			$this->_post['user_lastlog_more'] = intval(trim($_POST['user_lastlog_more']));
		}
		if ( !empty($_POST['user_lastlog_less']) && is_numeric($_POST['user_lastlog_less']) ) {
			$this->_post['user_lastlog_less'] = intval(trim($_POST['user_lastlog_less']));
		}
		if ( !empty($_POST['user_reg_more']) && is_numeric($_POST['user_reg_more']) ) {
			$this->_post['user_reg_more'] = intval(trim($_POST['user_reg_more']));
		}
		if ( !empty($_POST['user_reg_less']) && is_numeric($_POST['user_reg_less']) ) {
			$this->_post['user_reg_less'] = intval(trim($_POST['user_reg_less']));
		}
		if ( !empty($_POST['user_posts_more']) && is_numeric($_POST['user_posts_more']) ) {
			$this->_post['user_posts_more'] = intval(trim($_POST['user_posts_more']));
		}
		if ( !empty($_POST['user_posts_less']) && is_numeric($_POST['user_posts_less']) ) {
			$this->_post['user_posts_less'] = intval(trim($_POST['user_posts_less']));
		}
	}
	private function setCriteria(){
		$this->criteria = new CriteriaCompo();
		if(isset($this->_post['user_uname'])       ) $this->AddCriteriaWithMatch('uname', $this->_post['user_uname'], $this->_post['user_uname_match'] );
		if(isset($this->_post['user_name'])        ) $this->AddCriteriaWithMatch('name' ,$this->_post['user_name'], $this->_post['user_name_match'] );
		if(isset($this->_post['user_email'])       ) $this->AddCriteriaWithMatch('email' ,$this->_post['user_email'], $this->_post['user_email_match'] );
		if(isset($this->_post['user_url'])         ) $this->criteria->add(new Criteria('url', $this->_post['user_url'].'%', 'LIKE' ) );
		if(isset($this->_post['user_icq'])         ) $this->AddCriteriaWithMatch('icq' ,$this->_post['user_icq'], $this->_post['user_icq_match'] );
		if(isset($this->_post['user_aim'])         ) $this->AddCriteriaWithMatch('aim' ,$this->_post['user_aim'], $this->_post['user_aim_match'] );
		if(isset($this->_post['user_yim'])         ) $this->AddCriteriaWithMatch('yim' ,$this->_post['user_yim'], $this->_post['user_yim_match'] );
		if(isset($this->_post['user_msnm'])        ) $this->AddCriteriaWithMatch('msnm' ,$this->_post['user_msnm_match'], $this->_post['user_msnm'] );
		if(isset($this->_post['user_from'])        ) $this->criteria->add(new Criteria('user_from'   , '%'.$this->_post['user_from'].'%'   , 'LIKE'));
		if(isset($this->_post['user_intrest'])     ) $this->criteria->add(new Criteria('user_intrest', '%'.$this->_post['user_intrest'].'%', 'LIKE'));
		if(isset($this->_post['user_occ'])         ) $this->criteria->add(new Criteria('user_occ'    , '%'.$this->_post['user_occ'].'%'    , 'LIKE'));
		if(isset($this->_post['user_lastlog_more'])) $this->AddCriteriaWithTime('last_login',$this->_post['user_lastlog_more'],'<');
		if(isset($this->_post['user_lastlog_less'])) $this->AddCriteriaWithTime('last_login',$this->_post['user_lastlog_less'],'>');
		if(isset($this->_post['user_reg_more'])    ) $this->AddCriteriaWithTime('user_regdate',$this->_post['user_reg_more'],'<');
		if(isset($this->_post['user_reg_less'])    ) $this->AddCriteriaWithTime('user_regdate',$this->_post['user_reg_less'],'>');
		if(isset($this->_post['user_posts_more'])  ) $this->AddCriteriaWithTime('user_postsdate',$this->_post['user_posts_more'],'<');
		if(isset($this->_post['user_posts_less'])  ) $this->AddCriteriaWithTime('user_postsdate',$this->_post['user_posts_less'],'>');
		if ( !$this->iamadmin ) {
			$this->criteria->add(new Criteria('user_viewemail', 1));
		}
		$this->criteria->add(new Criteria('level', 0, '>'));		
	}
	/*
	 *  Controller Driven Section
	 */
	function searchresults_submit(){
		global $xoopsTpl,$xoopsUser;

		$this->getParam();
		$this->setCriteria();
		$member_handler = xoops_gethandler('member');
		$sort = $this->_post['user_sort'];
		$order = $this->_post['user_order'];
		$start = $this->_post['start'];
		$limit = $this->_post['limit'];
		$total = $member_handler->getUserCount($this->criteria);
		$xoopsTpl->assign('total_found', $total);
		$xoopsTpl->assign('_post', $this->_post);
		
		if ( $total == 0 ) {
			$xoopsTpl->assign('lang_nonefound', _MM_NOFOUND);
		} elseif ( $start < $total ) {
			$this->criteria->setSort($sort);
			$this->criteria->setOrder($order);
			$this->criteria->setStart($start);
			$this->criteria->setLimit($limit);
			$foundusers = $member_handler->getUsers($this->criteria, true);
			foreach (array_keys($foundusers) as $j) {
				$userdata['avatar'] = $foundusers[$j]->getVar("user_avatar") ? "<img src='".XOOPS_UPLOAD_URL."/".$foundusers[$j]->getVar("user_avatar")."' alt='' />" : "&nbsp;";
				$userdata['realname'] = $foundusers[$j]->getVar("name") ? $foundusers[$j]->getVar("name") : "&nbsp;";
				$userdata['name'] = $foundusers[$j]->getVar("uname");
				$userdata['id'] = $foundusers[$j]->getVar("uid");
				if ( $foundusers[$j]->getVar("user_viewemail") == 1 || $this->iamadmin ) {
					$userdata['email'] = "<a href='mailto:".$foundusers[$j]->getVar("email")."'><img src='".XOOPS_URL."/images/icons/email.gif' border='0' alt='".sprintf(_SENDEMAILTO,$foundusers[$j]->getVar("uname", "E"))."' /></a>";
				} else {
					$userdata['email'] = "&nbsp;";
				}
				if ( $xoopsUser ) {				
					$userdata['pmlink'] = 
					"<a href='javascript:openWithSelfMain(\"".XOOPS_URL.
					"/modules/message/index.php?action=new&amp;to_userid=".$foundusers[$j]->getVar("uid")
					."\",\"pmlite\",450,370);'><img src='".XOOPS_URL.
					"/images/icons/pm.gif' border='0' alt='".
					sprintf(_SENDPMTO,$foundusers[$j]->getVar("uname", "E"))."' /></a>";
				} else {
					$userdata['pmlink'] = "&nbsp;";
				}
				if ( $foundusers[$j]->getVar("url","E") != "" ) {
					$userdata['website'] =  "<a href='".$foundusers[$j]->getVar("url","E")."' target='_blank'><img src='".XOOPS_URL."/images/icons/www.gif' border='0' alt='"._VISITWEBSITE."' /></a>";
				} else {
					$userdata['website'] =  "&nbsp;";
				}
				$userdata['registerdate'] = formatTimeStamp($foundusers[$j]->getVar("user_regdate"),"s");
				if ( $foundusers[$j]->getVar("last_login") != 0 ) {
					$userdata['lastlogin'] =  formatTimeStamp($foundusers[$j]->getVar("last_login"),"m");
				} else {
					$userdata['lastlogin'] =  "&nbsp;";
				}
				$userdata['posts'] = $foundusers[$j]->getVar("posts");
				if ( $this->iamadmin ) {
// link to administrator page modified by uchi start 20110910. 
//				$userdata['adminlink'] = "<a href='".XOOPS_URL."/modules/system/admin.php?fct=users&amp;uid=".$foundusers[$j]->getVar("uid")."&amp;op=modifyUser'>"._EDIT."</a> | <a href='".XOOPS_URL."/modules/system/admin.php?fct=users&amp;op=delUser&amp;uid=".$foundusers[$j]->getVar("uid")."'>"._DELETE."</a>";
					$userdata['adminlink'] = "<a href='".XOOPS_URL."/modules/user/admin/index.php?action=UserEdit&amp;uid=".$foundusers[$j]->getVar("uid")."'>"._EDIT."</a> | <a href='".XOOPS_URL."/modules/user/admin/index.php?action=UserDelete&amp;uid=".$foundusers[$j]->getVar("uid")."'>"._DELETE."</a>";
// link to administrator page modified by uchi end 20110910. 
				}
				$xoopsTpl->append('users', $userdata);
			}
			$totalpages = ceil($total / $limit);
			if ( $totalpages > 1 ) {
				$hiddenform = "<form name='findnext' action='index.php' method='post'>";
				foreach ( $_POST as $k => $v ) {
					$hiddenform .= "<input type='hidden' name='".$myts->oopsHtmlSpecialChars($k)."' value='".$myts->makeTboxData4PreviewInForm($v)."' />\n";
				}
				if (!isset($_POST['limit'])) {
					$hiddenform .= "<input type='hidden' name='limit' value='".$limit."' />\n";
				}
				if (!isset($_POST['start'])) {
					$hiddenform .= "<input type='hidden' name='start' value='".$start."' />\n";
				}
				$prev = $start - $limit;
				if ( $start - $limit >= 0 ) {
					$hiddenform .= "<a href='#0' onclick='javascript:document.findnext.start.value=".$prev.";document.findnext.submit();'>"._MM_PREVIOUS."</a>&nbsp;\n";
	        	}
				$counter = 1;
				$currentpage = ($start+$limit) / $limit;
				while ( $counter <= $totalpages ) {
					if ( $counter == $currentpage ) {
						$hiddenform .= "<b>".$counter."</b> ";
					} elseif ( ($counter > $currentpage-4 && $counter < $currentpage+4) || $counter == 1 || $counter == $totalpages ) {
						if ( $counter == $totalpages && $currentpage < $totalpages-4 ) {
							$hiddenform .= "... ";
						}
						$hiddenform .= "<a href='#".$counter."' onclick='javascript:document.findnext.start.value=".($counter-1)*$limit.";document.findnext.submit();'>".$counter."</a> ";
						if ( $counter == 1 && $currentpage > 5 ) {
							$hiddenform .= "... ";
						}
					}
					$counter++;
				}
				$next = $start+$limit;
				if ( $total > $next ) {
					$hiddenform .= "&nbsp;<a href='#".$total."' onclick='javascript:document.findnext.start.value=".$next.";document.findnext.submit();'>"._MM_NEXT."</a>\n";
				}
				$hiddenform .= "</form>";
				$xoopsTpl->assign('pagenav', $hiddenform);
				$xoopsTpl->assign('lang_numfound', sprintf(_MM_USERSFOUND, $total));
			}
		}
		return 1;
	}
    private function update_outbox($uid,$to_uid,$title,$message,$utime){
    	global $xoopsDB;
    	$sql = sprintf(
	    	"INSERT INTO %s (uid,to_uid,title,message,utime) VALUES ('%u','%u','%s','%s','%u')",
			$xoopsDB->prefix("message_outbox"),
			$uid,$to_uid,$title,$message,$utime
    	);
    	return $xoopsDB->query($sql);
    }
	function searchresults_sendPM(){
		global $xoopsTpl,$xoopsUser;
		
		$myts =& MyTextSanitizer::getInstance();
		$this->getParam();
		$this->setCriteria();
		$member_handler = xoops_gethandler('member');
		$sort = $this->_post['user_sort'];
		$order = $this->_post['user_order'];
		$total = $member_handler->getUserCount($this->criteria);
		$xoopsTpl->assign('_post', $this->_post);
		$this->message = ""; 
		if ( $total == 0 ) {
			$xoopsTpl->assign('lang_nonefound', _MM_NOFOUND);
		} else {
			$this->criteria->setSort($sort);
			$this->criteria->setOrder($order);
			$foundusers = $member_handler->getUsers($this->criteria, true);
			$pm_handler = xoops_gethandler('privmessage');
			foreach (array_keys($foundusers) as $j) {
				$userdata['avatar'] = $foundusers[$j]->getVar("user_avatar") ? "<img src='".XOOPS_UPLOAD_URL."/".$foundusers[$j]->getVar("user_avatar")."' alt='' />" : "&nbsp;";
				$userdata['realname'] = $foundusers[$j]->getVar("name") ? $foundusers[$j]->getVar("name") : "&nbsp;";
				$userdata['name'] = $foundusers[$j]->getVar("uname");
				$userdata['id'] = $foundusers[$j]->getVar("uid");
				$pm = $pm_handler->create();
				$subject = $myts->addSlashes( trim($_POST['subject']) );
            	$pm->setVar("subject", $subject);
            	if (isset($subject) && $subject !== '') {
                	$pm->setVar("subject", $subject);
            	} else {
                	$pm->setVar("subject", _PM_NO_SUBJECT);
            	}
				$msg_text = $myts->addSlashes( trim($_POST['msg_text']) );
            	$pm->setVar("msg_text", $msg_text);
           		$pm->setVar("to_userid", $userdata['id']);
            	$pm->setVar("from_userid", $xoopsUser->getVar("uid"));
				if (!$pm_handler->insert($pm)) {
					$this->message .= $userdata['name']; 
				}else{
					$this->update_outbox(
						$xoopsUser->getVar("uid"),
						$userdata['id'],
						$subject,
						$msg_text,
						time()
					);
				}
			}
			if (!$this->message)
				$this->message = _MM_SNED_OK; 
			else
				$this->message = _MM_SNED_ERR . $this->message; 
			$xoopsTpl->assign('lang_results',_MM_SEND_MESSAGE);
			$xoopsTpl->assign('lang_message',$this->message);
			$xoopsTpl->assign('total_found', -1 );
		}
		return 1;
	}
}
?>