<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Xleprogress_HistoryListAction
**/
class Xleprogress_HistoryListAction extends Xleprogress_AbstractListAction
{
	/**
	 * &_getHandler
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_HistoryHandler
	**/
	protected function &_getHandler()
	{
		$handler =& $this->mAsset->getObject('handler', 'History');
		return $handler;
	}

	/**
	 * &_getFilterForm
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_HistoryFilterForm
	**/
	protected function &_getFilterForm()
	{
		$filter =& $this->mAsset->getObject('filter', 'History',false);
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * _getBaseUrl
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	protected function _getBaseUrl()
	{
		return './index.php?action=HistoryList';
	}

	/**
	 * executeViewIndex
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
	{
		$itemObj = Legacy_Utils::getModuleHandler('item', $this->mAsset->mDirname)->get($this->mRoot->mContext->mRequest->getRequest('item_id'));
		$itemObj->loadType();
		$render->setTemplateName($this->mAsset->mDirname . '_history_list.html');
		$render->setAttribute('objects', $this->mObjects);
		$render->setAttribute('dirname', $this->mAsset->mDirname);
		$render->setAttribute('item', $itemObj);
		$render->setAttribute('pageNavi', $this->mFilter->mNavi);
		$render->setAttribute('status_progress', Xleprogress_Result::REQUEST);
	}
}

?>
