<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/class/Legacy_Validator.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/BeanFactory.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/Request.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/File.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/Enum.class.php";

class User_GroupAdminEditForm extends XCube_ActionForm
{
	var $mFile = null;
	var $mName = null;
	var $activate = 0;
	var $groupType = 0;
	// before a change
	var $groupPublic = null;

	function getTokenName()
	{
		return "module.user.GroupAdminEditForm.TOKEN" . $this->get('groupid');
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['groupid'] = new XCube_IntProperty('groupid');
		$this->mFormProperties['name'] = new XCube_StringProperty('name');
		$this->mFormProperties['description'] = new XCube_TextProperty('description');
		$this->mFormProperties['group_type'] = new XCube_TextProperty('group_type');

		$this->mFormProperties['icon'] = new XCube_StringProperty('icon');
		$this->mFormProperties['mime_type'] = new XCube_StringProperty('mime_type');
		$this->mFormProperties['is_public'] = new XCube_IntProperty('is_public');
		$this->mFormProperties['can_join'] = new XCube_IntProperty('can_join');
		$this->mFormProperties['is_hidden'] = new XCube_IntProperty('is_hidden');
		$this->mFormProperties['member_accept'] = new XCube_IntProperty('member_accept');
		$this->mFormProperties['item_accept'] = new XCube_IntProperty('item_accept');
		$this->mFormProperties['item_number_limit'] = new XCube_IntProperty('item_number_limit');
		$this->mFormProperties['index_number_limit'] = new XCube_IntProperty('index_number_limit');
		$this->mFormProperties['item_storage_limit'] = new XCube_FloatProperty('item_storage_limit');
		
		$this->mFormProperties['admins'] = new XCube_StringArrayProperty('admins');
		$this->mFormProperties['uid'] = new XCube_IntArrayProperty('uid');
		$this->mFormProperties['showThumbnail'] = new XCube_IntProperty('showThumbnail');
		$this->mFormProperties['warning'] = new XCube_StringProperty('warning');
	
		//
		// Set field properties
		//
		$this->mFieldProperties['groupid'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['groupid']->setDependsByArray(array('required'));
		$this->mFieldProperties['groupid']->addMessage('required', _MD_USER_ERROR_REQUIRED, _MD_USER_LANG_GROUPID);
	
		$this->mFieldProperties['name'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['name']->addMessage('required', _MD_USER_ERROR_REQUIRED, _AD_USER_LANG_GROUP_NAME, '50');
		$this->mFieldProperties['name']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_GROUP_NAME, '50');
		$this->mFieldProperties['name']->addVar('maxlength', '50');
	}
	
	function validateName()
	{
		if ($this->get('name') != null) {
			if (trim($this->mName) != trim($this->get('name'))) {
				$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
				if ($groupbean->existsGroup($this->get('name'))) {
					$this->addErrorMessage(_MD_USER_ERROR_GROUP_NAME_EXISTS);
				}
			}
		}
	}

	function validateUid()
	{
		if ($this->groupType != Xoonips_Enum::GROUP_TYPE) {
			return;
		}
		$user = array();
		$uids = $this->get('uid');
		if (!empty($uids)) {
			$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
			foreach ($uids as $uid) {
				$manager = $userBean->getUserBasicInfo($uid);				
				$user[] = $manager;
			}
			$this->set('admins', $user);
		}
		if (empty($user)) {
			$this->addErrorMessage(XCube_Utils::formatString(_MD_USER_ERROR_REQUIRED, array(_MD_USER_LANG_GROUP_ADMIN)));
		}
	}

	function validateIcon()
	{
		//get icon information
		$request = new Xoonips_Request();
		$this->mFile = $request->getFile('filepath');
		if (!empty($this->mFile)) {
			$file_name = $this->mFile['name'];
			$file_type = $this->mFile['type'];
			$file_size = $this->mFile['size'];
			$file_tmp_name = $this->mFile['tmp_name'];
			$this->set('icon', $this->mFile['name']);
			$this->set('mime_type', $this->mFile['type']);
			$xoonipsFile = new Xoonips_File(null, null);
			$thumbnail_file = addslashes($xoonipsFile->getThumbnail($file_tmp_name, $file_type));
			if (empty($thumbnail_file)) {
				$this->addErrorMessage(_MD_USER_ERROR_GROUP_ICON);
			}
		} elseif ($this->get('showThumbnail') == 2) {
			$this->set('icon', null);
			$this->set('mime_type', null);
		}
	}

	function setAdmin()
	{
		$adminValue = $this->mContext->mRequest->getRequest('adminvalue');
		$users = $this->get('uid');//$this->mContext->mRequest->getRequest('uid');
		$uids = array();
		$admins = array();
		
		//get group manager
		if (!empty($users)) {
			foreach ($users as $user) {
				$uids[] = $user;
			}
		}
		if (!empty($adminValue)) {
			$values = explode(',', $adminValue);
			foreach ($values as $value) {
				if (!in_array($value, $uids)) {
					$uids[] = $value;
				}		
			}
		}
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
		foreach ($uids as $uid) {
			$manager = $userBean->getUserBasicInfo($uid);
			$admins[] = $manager;
		}
		$this->set('admins', $admins);
	}

	function load(&$obj)
	{
		$groupId = $obj->get('groupid');
		$this->set('groupid', $groupId);
		$this->set('name', $obj->get('name'));
		$this->set('description', $obj->get('description'));

		$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
		
		$group = $groupBean->getGroup($groupId);
		if (count($group) > 0) {
			$this->activate = $group['activate'];
			$this->groupType = $group['group_type'];
			$this->groupPublic = $group['is_public'];
			$this->set('group_type', $group['group_type']);
			$this->set('icon', $group['icon']);
			$this->set('mime_type', $group['mime_type']);
			$this->set('is_public', $group['is_public']);
			$this->set('can_join', $group['can_join']);
			$this->set('is_hidden', $group['is_hidden']);
			$this->set('member_accept', $group['member_accept']);
			$this->set('item_accept', $group['item_accept']);
			$this->set('item_number_limit', $group['item_number_limit']);
			$this->set('index_number_limit', $group['index_number_limit']);
			$this->set('item_storage_limit', $group['item_storage_limit'] / 1024 / 1024);

			$managers = $userBean->getUsersGroups($obj->get('groupid'), true);
			$this->set('admins', $managers);

			//activate 0:certify request or 2:open request or 4:close request or 5:delete request, warning show
			$warning = '';
			if ($group['activate'] == Xoonips_Enum::GRP_NOT_CERTIFIED) {
				$warning = _MD_USER_MESSAGE_GROUP_CERTIFY_REQUESTING;
			} elseif ($group['activate'] == Xoonips_Enum::GRP_OPEN_REQUIRED) {
				$warning = _MD_USER_MESSAGE_GROUP_OPEN_REQUESTING;
			} elseif ($group['activate'] == Xoonips_Enum::GRP_CLOSE_REQUIRED) {
				$warning = _MD_USER_MESSAGE_GROUP_CLOSE_REQUESTING;
			} elseif ($group['activate'] == Xoonips_Enum::GRP_DELETE_REQUIRED) {
				$warning = _MD_USER_MESSAGE_GROUP_DELETE_REQUESTING;
			}
			$this->set('warning', $warning);
		} else {
			$result = array();
			XCube_DelegateUtils::call('Module.User.GetGroupMaximumResources', new XCube_Ref($result), null);
			if (count($result) > 0) {
				foreach ($result as $limit) {
					$this->set('item_number_limit', $limit['itemNumberLimit']);
					$this->set('index_number_limit', $limit['indexNumberLimit']);
					$this->set('item_storage_limit', $limit['itemStorageLimit']);
				}
			} else {
				$this->set('item_number_limit', 0);
				$this->set('index_number_limit', 0);
				$this->set('item_storage_limit', 0);	
			}
			$this->set('group_type', 'User');
			$this->groupType = 'User';
		}

		//$showThumbnail,0:file not exist,1:file exist,2:file delete
		$file_path = XOOPS_ROOT_PATH . '/uploads/user/group/' . $groupId;
		$showThumbnail = 0;
		if (file_exists($file_path)) {
			$showThumbnail = 1;
		}
		$this->set('showThumbnail', $showThumbnail);
		$this->mName = $this->get('name');
	}

	function update(&$obj)
	{
		if ($obj->get('group_type') != Xoonips_Enum::GROUP_TYPE
			|| $this->groupType != Xoonips_Enum::GROUP_TYPE) {
			$obj->set('name', $this->get('name'));
			$obj->set('description', $this->get('description'));
			$obj->set('group_type', $this->groupType);
			return $obj;
		} else {
			$group['groupid'] = $this->get('groupid');
			$group['name'] = $this->get('name');
			$group['description'] = $this->get('description');
			$group['icon'] = $this->get('icon');
			$group['mime_type'] = $this->get('mime_type');
			if (!is_null($this->get('is_public'))) {
				$group['is_public'] = $this->get('is_public');
			} else {
				$group['is_public'] = 0;
			}
			$group['can_join'] = $this->get('can_join');
			$group['is_hidden'] = $this->get('is_hidden');
			$group['member_accept'] = $this->get('member_accept');
			$group['item_accept'] = $this->get('item_accept');
			$group['item_number_limit'] = $this->get('item_number_limit');
			$group['index_number_limit'] = $this->get('index_number_limit');
			$group['item_storage_limit'] = $this->get('item_storage_limit');
			$group['admins'] = $this->get('admins');
			$group['activate'] = $this->activate;
			$group['groupPublic'] = $this->groupPublic; 
		}
		return $group;
	}
}


