<?php

require_once 'Utils.class.php';
require_once 'File.class.php';

class Xoonips_Request {

	public function getParameter($key) {
		$root =& XCube_Root::getSingleton();
		$ret = $root->mContext->mRequest->getRequest($key);
		if (is_null($ret)) {
			return null;
		} elseif (is_array($ret)) {
			foreach($ret as $key=>$val){
				$ret[$key] = Xoonips_Utils::convertToNumericEntities($val);
			}
		} else {
			$ret = Xoonips_Utils::convertToNumericEntities($ret);
		}
		return $ret;
	}

	public function getParameter2($key) {
		$root =& XCube_Root::getSingleton();
		$ret = $root->mContext->mRequest->getRequest($key);
		if (is_null($ret)) {
			return null;
		}
		return $ret;
	}

	public function getFile($name) {
		if (!isset($_FILES[$name])) {
			return null;
		}
		if (get_magic_quotes_gpc()) {
			$val = array_map('stripslashes', $_FILES[$name]);
		} else {
			$val = $_FILES[$name];
		}
		if ((isset($val['error']) && $val['error'] != 0) || !is_uploaded_file($val['tmp_name'])) {
			return null;
		}
		$val['name'] = Xoonips_Utils::convertToNumericEntities($val['name']);
		$dirname = Xoonips_Utils::getDirname();
		if ($dirname != XCUBE_CORE_USER_MODULE_NAME) {
			$file = new Xoonips_File($dirname, Xoonips_Utils::getTrustDirname());
			$mimetype = $file->getMimetype($val['tmp_name'], $val['name']);
			if ($mimetype != '') {
				$val['type'] = $mimetype;
			}
		}
		if ($val['type'] === false) {
			return null;
		}
		return $val;
	}
}

