<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

if(!defined('XOONIPS_TRUST_PATH')) {
	$trustDirname = basename(dirname(dirname(__FILE__)));
	define('XOONIPS_TRUST_DIRNAME', $trustDirname);
	define('XOONIPS_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/' . $trustDirname);
}

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOONIPS_TRUST_PATH . '/include/common.inc.php';

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * Xoonips_AssetPreloadBase
**/
class Xoonips_AssetPreloadBase extends XCube_ActionFilter {

	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public static function prepare($dirname) {
		Xoonips_Utils::loadMessage(XOONIPS_TRUST_DIRNAME);
		Xoonips_Utils::loadModinfoMessage(XOONIPS_TRUST_DIRNAME);
		Xoonips_Utils::loadAdminMessage(XOONIPS_TRUST_DIRNAME);
		Xoonips_Utils::loadBlocksMessage(XOONIPS_TRUST_DIRNAME);
		$root =& XCube_Root::getSingleton();
		$instance = new Xoonips_AssetPreloadBase($root->mController);
		$root->mController->addActionFilter($instance);
	}

	/**
	 * preBlockFilter
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public function preBlockFilter() {
		// record view top page event
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $xoonipsDirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $xoonipsDirname, XOONIPS_TRUST_DIRNAME);
			$log->recordViewTopPageEvent();
		}

		$this->mRoot->mDelegateManager->add('Module.xoonips.Global.Event.GetAssetManager', 'Xoonips_AssetPreloadBase::getManager');
		$this->mRoot->mDelegateManager->add('Legacy_Utils.CreateModule', 'Xoonips_AssetPreloadBase::getModule');
		$file = XOONIPS_TRUST_PATH . '/class/DelegateFunctions.class.php';
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.UpdateStatus', 'Xoonips_DelegateFunctions::updateStatus', $file);
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.GetDetailView', 'Xoonips_DelegateFunctions::getDetailView', $file);
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.GetTargetGroupId', 'Xoonips_DelegateFunctions::getTargetGroupId', $file);
		$this->mRoot->mDelegateManager->add('Site.JQuery.AddFunction',array(&$this, 'addScript'));
		$this->mRoot->mDelegateManager->add('Module.User.Evnet.User.Login.Success', 'Xoonips_DelegateFunctions::checkLoginSuccess', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Evnet.User.Login.Fail', 'Xoonips_DelegateFunctions::checkLoginFail', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Evnet.User.Logout.Success', 'Xoonips_DelegateFunctions::checkLogoutSuccess', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.CertifyRequest', 'Xoonips_DelegateFunctions::userCertifyRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.Certify', 'Xoonips_DelegateFunctions::userCertify', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.Reject', 'Xoonips_DelegateFunctions::userReject', $file);		
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.Substitute.Begin', 'Xoonips_DelegateFunctions::userSuBegin', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.Substitute.End', 'Xoonips_DelegateFunctions::userSuEnd', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.Leave', 'Xoonips_DelegateFunctions::groupMemberLeave', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.JoinReject', 'Xoonips_DelegateFunctions::groupMemberJoinReject', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.LeaveCertify', 'Xoonips_DelegateFunctions::groupMemberLeaveCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.LeaveReject', 'Xoonips_DelegateFunctions::groupMemberLeaveReject', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.Delete', 'Xoonips_DelegateFunctions::userDelete', $file);	
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.JoinRequest', 'Xoonips_DelegateFunctions::groupMemberJoinRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.JoinCertify', 'Xoonips_DelegateFunctions::groupMemberJoinCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.LeaveRequest', 'Xoonips_DelegateFunctions::groupMemberLeaveRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.DeleteRequest', 'Xoonips_DelegateFunctions::groupDeleteRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.DeleteCertify', 'Xoonips_DelegateFunctions::groupDeleteCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.DeleteReject', 'Xoonips_DelegateFunctions::groupDeleteReject', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.Join', 'Xoonips_DelegateFunctions::groupMemberJoin', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.CertifyRequest', 'Xoonips_DelegateFunctions::groupCertifyRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Certify', 'Xoonips_DelegateFunctions::groupCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Reject', 'Xoonips_DelegateFunctions::groupReject', $file);	
		
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Edit', 'Xoonips_DelegateFunctions::groupEdit', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.OpenRequest', 'Xoonips_DelegateFunctions::groupOpenRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.OpenCertify', 'Xoonips_DelegateFunctions::groupOpenCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.OpenReject', 'Xoonips_DelegateFunctions::groupOpenReject', $file);
		
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.CloseRequest', 'Xoonips_DelegateFunctions::groupCloseRequest', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.CloseCertify', 'Xoonips_DelegateFunctions::groupCloseCertify', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.CloseReject', 'Xoonips_DelegateFunctions::groupCloseReject', $file);
		
		
		$this->mRoot->mDelegateManager->add('Module.User.GetUserPosts', 'Xoonips_DelegateFunctions::recountPosts', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetUserMaximumResources', 'Xoonips_DelegateFunctions::getUserMaximumResources', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetUserUsedResources', 'Xoonips_DelegateFunctions::getUserUsedResources', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetGroupMaximumResources', 'Xoonips_DelegateFunctions::getGroupMaximumResources', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetGroupUsedResources', 'Xoonips_DelegateFunctions::getGroupUsedResources', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetModerators', 'Xoonips_DelegateFunctions::getModerators', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.User.DeleteCondition', 'Xoonips_DelegateFunctions::userDeleteCondition', $file);
		$this->mRoot->mDelegateManager->add('Module.User.Event.Group.Member.LeaveCondition', 'Xoonips_DelegateFunctions::groupLeaveCondition', $file);
		$this->mRoot->mDelegateManager->add('Module.User.GetMessageSign', 'Xoonips_DelegateFunctions::getMessageSign', $file);
	}

	/**
	 * addScript
	 * 
	 * @param	$jQuery  &$obj
	 * 
	 * @return	void
	**/
	public function addScript(&$jQuery) {
	     $jQuery->addLibrary('/common/js/prettyPopin/jquery.prettyPopin.js');
	     $jQuery->addLibrary('/common/js/treeview/jquery.treeview.js');
   	     $jQuery->addLibrary('/common/js/cookie/jquery.cookie.js');
	     $jQuery->addLibrary('/modules/' . XOONIPS_TRUST_DIRNAME . '/js/xoonips_edit.js');
	     $jQuery->addStylesheet('/common/js/prettyPopin/jquery.prettyPopin.css');
	     $jQuery->addStylesheet('/common/js/treeview/jquery.treeview.css');
	}

	/**
	 * getManager
	 * 
	 * @param	Xoonips_AssetManager  &$obj
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public static function getManager(/*** Xoonips_AssetManager ***/ &$obj,/*** string ***/ $dirname) {
		require_once XOONIPS_TRUST_PATH . '/class/AssetManager.class.php';
		$obj = Xoonips_AssetManager::getInstance($dirname);
	}

	/**
	 * getModule
	 * 
	 * @param	Legacy_AbstractModule  &$obj
	 * @param	XoopsModule  $module
	 * 
	 * @return	void
	**/
	public static function getModule(/*** Legacy_AbstractModule ***/ &$obj,/*** XoopsModule ***/ $module) {
		if ($module->getInfo('trust_dirname') == XOONIPS_TRUST_DIRNAME)	{
			require_once XOONIPS_TRUST_PATH . '/class/Module.class.php';
			$obj = new Xoonips_Module($module);
		}
	}

	/**
	 * getBlock
	 * 
	 * @param	Legacy_AbstractBlockProcedure  &$obj
	 * @param	XoopsBlock	$block
	 * 
	 * @return	void
	**/
	public static function getBlock(/*** Legacy_AbstractBlockProcedure ***/ &$obj,/*** XoopsBlock ***/ $block) {
		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->get($block->get('mid'));
		if(is_object($module) && $module->getInfo('trust_dirname') == XOONIPS_TRUST_DIRNAME) {
			require_once XOONIPS_TRUST_PATH . '/blocks/' . $block->get('func_file');
			$className = 'Xoonips_' . substr($block->get('show_func'), 4);
			$obj = new $className($block);
		}
	}
}

