<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

// buffer clear
Xoonips_Utils::allBufferClear();

$dirname = Xoonips_Utils::getDirname();
Xoonips_Utils::loadMessage($dirname);

$text = 'Button';
$text_shadow = false;
$font_size = 8;
$font_angle = 0;
$font_color = array(0, 0, 0);
$font_file = 'default.ttf';
$padding_x = 10;
$padding_y = 6;
$background_image_file = 'icon_button_normal.png';

// get params
$myts =& MyTextSanitizer::getInstance();
$request = new Xoonips_Request();
$mode = $request->getParameter('mode');
switch ($mode) {
	case 'normal':
		$background_image_file = 'icon_button_normal.png';
		break;
	case 'down':
		$background_image_file = 'icon_button_down.png';
		break;
	case 'over':
		$background_image_file = 'icon_button_over.png';
		break;
	case 'focus':
		$background_image_file = 'icon_button_focus.png';
		break;
}
$label = $request->getParameter('label');
if (!is_null($label) && $label == 'download') {
	$text = _MD_XOONIPS_ITEM_DOWNLOAD_LABEL;
}

$background_image_path = XOOPS_ROOT_PATH . '/modules/' . $dirname . '/images/' . $background_image_file;

$text_utf8 = Xoonips_Utils::encodeUtf8($text, _CHARSET);

// error check
if (!extension_loaded('gd')) {
	die('PHP GD extension does not loaded');
}
$gdinfo = gd_info();
if (!$gdinfo['FreeType Support']) {
	die('GD : FreeType Support disabled');
} elseif (!$gdinfo['PNG Support']) {
	die('GD : PNG Support disabled');
} elseif (!file_exists($background_image_path)) {
	die('background image file not found : ' . $background_iamge_file);
}
$font_path = Xoonips_Utils::fontPath($font_file);

// calculate drawing image size
$text_bbox = imagettfbbox($font_size, $font_angle, $font_path, $text_utf8);
$text_xmax = max($text_bbox[0], $text_bbox[2], $text_bbox[4], $text_bbox[6]);
$text_xmin = min($text_bbox[0], $text_bbox[2], $text_bbox[4], $text_bbox[6]);
$text_ymax = max($text_bbox[1], $text_bbox[3], $text_bbox[5], $text_bbox[7]);
$text_ymin = min($text_bbox[1], $text_bbox[3], $text_bbox[5], $text_bbox[7]);
$text_width = $text_xmax - $text_xmin;
$text_height = $text_ymax - $text_ymin;
$image_width = $text_width + $padding_x * 2;
$image_height = $text_height + $padding_y * 2;
$x = $padding_x - $text_xmin + (($text_xmin == $text_bbox[0]) ? 0 : $text_bbox[0]);
$y = $image_height - $padding_y - $text_ymax + (($text_ymax == $text_bbox[1]) ? 0 : $text_bbox[1]);

// create image resource
$im = imagecreatetruecolor($image_width, $image_height);

// change alpha attributes and create transparent color
imageantialias($im, true);
imagealphablending($im, false);
imagesavealpha($im, true);
$transparent = imagecolorallocatealpha($im, 255, 255, 255, 0);
// fill all area with transparent color
imagefill($im, 0, 0, $transparent);

// stretch and copy background image
list($imbg_width, $imbg_height) = getimagesize($background_image_path);
$imbg = imagecreatefrompng($background_image_path);
if (!imagecopyresampled($im, $imbg, 0, 0, 0, 0, $image_width, $image_height, $imbg_width, $imbg_height)) {
	die('imagecopyresampled() failed');
};
imagedestroy($imbg);

// draw text
imagealphablending($im, true);
$font_color = imagecolorallocate($im, $font_color[0], $font_color[1], $font_color[2]);
if ($text_shadow) {
	// shadow
	$shadow_color = imagecolorallocate($im, 128, 128, 128);
	imagettftext($im, $font_size, $font_angle, $x + 1, $y + 1, $shadow_color, $font_path, $text_utf8);
}
imagettftext($im, $font_size, $font_angle, $x, $y, $font_color, $font_path, $text_utf8);

// display
header('Content-type: image/png');
imagepng($im);

// cleanup
imagedestroy($im);

