<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate xoonips_oaipmh_schema_item_type_link table 
 *
 */
class Xoonips_OaipmhSchemaItemtypeLinkBean extends Xoonips_BeanBase {
	
    /**
	 * Constructor
	 **/
	public function Xoonips_OaipmhSchemaItemtypeLinkBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('oaipmh_schema_item_type_link', true);
	}
	
	/**
	 * get link  
	 * 
	 * @param  string $metadataPrefix:metadata_prefix
	 * 			int $itemType:item type id
	 * @return array
	 */
	public function get($metadataPrefix, $itemType) {
		$ret = array();
		$schemaTable = $this->prefix($this->modulePrefix('oaipmh_schema'));
		$sql = "SELECT a.* FROM $this->table a WHERE a.item_type_id=$itemType AND a.schema_id IN ";
		$sql = $sql . " (SELECT schema_id FROM $schemaTable b WHERE metadata_prefix='$metadataPrefix')";
		$sql = $sql . ' ORDER BY a.schema_id';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * delete link  
	 * 
	 * @param  string $metadataPrefix:metadata_prefix
	 *          int $itemType:item type id
	 * @return bool true:success,false:failed
	 */
	public function delete($metadataPrefix, $itemType) {
		$ret = true;
		$schemaTable = $this->prefix($this->modulePrefix('oaipmh_schema'));
		$sql = "DELETE FROM $this->table WHERE item_type_id=$itemType";
		if (!is_null($metadataPrefix)) {
			$sql .= " AND schema_id IN (SELECT schema_id FROM $schemaTable WHERE metadata_prefix='$metadataPrefix')";
		}
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
	
	/**
	 * insert link
	 * 
	 * @param  array $link
	 * @return bool true:success,false:failed
	 */
	public function insert($link) {
		$ret = true;
		$sql = "INSERT INTO $this->table (schema_id,item_type_id,group_id,item_field_detail_id,value)";
        $sql = $sql . ' VALUES(' . $link['schema_id'] . ',' . $link['item_type_id'];
		$sql = $sql . ',' . Xoonips_Utils::convertSQLStr($link['group_id']). ',' . Xoonips_Utils::convertSQLStr($link['item_field_detail_id']). ',' . Xoonips_Utils::convertSQLStr($link['value']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
	
	/**
	 * auto create  
	 * 
	 * @param  int $itemType:item type id
	 * 
	 * @return bool true:success,false:failed
	 */
	public function autoCreate($itemType) {
		$schemaLinkTable = $this->prefix($this->modulePrefix('oaipmh_schema_link'));
		$sql = 'SELECT a.schema_id1, a.schema_id2, a.number, b.item_field_detail_id, b.value ';
		$sql = $sql . "FROM $schemaLinkTable a,$this->table b ";
		$sql = $sql . "WHERE a.schema_id1=b.schema_id AND b.item_type_id=$itemType ";
		$sql = $sql . 'ORDER BY a.schema_id2, a.number';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$link = null;
		$pre_row = null;
		$schemaBean = Xoonips_BeanFactory::getBean('OaipmhSchemaBean', $this->dirname, $this->trustDirname);
		$valuesets = $schemaBean->getSchemaValueSetList('junii2');
		$pre_row = false;
		while ($row = $this->fetchArray($result)) {
			if ($this->hasValueset($valuesets, $row['schema_id1'])) {
				$row['item_field_detail_id'] = $schemaBean->convertValueset($row['schema_id1'], $row['schema_id2'], $row['item_field_detail_id']);
			}
			if ($pre_row == false) {
				$link['schema_id'] = $row['schema_id2'];
				$link['item_type_id'] = $itemType;
				$link['item_field_detail_id'] = $row['item_field_detail_id'];
				$link['value'] = $row['value'];
			} elseif ($link['schema_id'] != $row['schema_id2'] | $pre_row['number']!=$row['number'] | $pre_row['schema_id1'] == $row['schema_id1']) {
				if (!$this->insert($link)) {
					return false;
				}
				$link['schema_id'] = $row['schema_id2'];
				$link['item_type_id'] = $itemType;
				$link['item_field_detail_id'] = $row['item_field_detail_id'];
				$link['value'] = $row['value'];
			} else {
				$link['item_field_detail_id'] = $link['item_field_detail_id'] . ',' . $row['item_field_detail_id'];
				$link['value'] = null;
			}			
			$pre_row = $row;
		}
		if ($link != null && !$this->insert($link)) {
			return false;
		}
		return true;
	}
	
	private function hasValueset($valuesets, $schema_id) {
		foreach ($valuesets as $valueset) {
			if ($valueset['schema_id'] == $schema_id) {
				return true;
			}
		}
		return false;
	}
}

