DROP TABLE IF EXISTS `{prefix}_{dirname}_type`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_approval`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_item`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_history`;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_type`
#

CREATE TABLE `{prefix}_{dirname}_type` (
  `type_id` int(10) unsigned NOT NULL auto_increment,
  `dirname` varchar(25) NOT NULL,
  `dataname` varchar(255) NOT NULL,
  `module` varchar(255) default NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_approval`
#

CREATE TABLE `{prefix}_{dirname}_approval` (
  `approval_id` int(10) unsigned NOT NULL auto_increment,
  `uid` int(10) unsigned default NULL,
  `groupid` int(10) unsigned default NULL,
  `type_id` int(10) unsigned NOT NULL,
  `step` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY  (`approval_id`)
) ENGINE=MyISAM;


# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_item`
#

CREATE TABLE `{prefix}_{dirname}_item` (
  `item_id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `target_id` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `step` tinyint(3) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  `revision` smallint(5) unsigned NOT NULL,
  `url` text default NULL,
  `posttime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `deletetime` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`item_id`)
) ENGINE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_history`
#

CREATE TABLE `{prefix}_{dirname}_history` (
  `progress_id` int(10) unsigned NOT NULL auto_increment,
  `item_id` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `step` tinyint(3) unsigned NOT NULL,
  `result` tinyint(3) unsigned NOT NULL,
  `comment` text NOT NULL,
  `posttime` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`progress_id`)
) ENGINE=MyISAM;
