<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/Enum.class.php';

/**
 * Xleprogress_HistoryObject
**/
class Xleprogress_HistoryObject extends XoopsSimpleObject
{
	public $mDirname = null;
	protected $_mItemLoadedFlag = false;
	public $mItem = null;
    public $mType = null;
    public $mSteps = null;
    
	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('progress_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('item_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('uid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('step', XOBJ_DTYPE_INT, '', false);
		$this->initVar('result', XOBJ_DTYPE_INT, '', false);
		$this->initVar('comment', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('posttime', XOBJ_DTYPE_INT, time(), false);
	}

	/**
	 * loadItem
	 * 
	 * @param	void
	 * 
	 * @return	void
	 */
	public function loadItem()
	{
		if ($this->_mItemLoadedFlag == false) {
			$handler = Legacy_Utils::getModuleHandler('item', $this->getDirname());
			$this->mItem =& $handler->get($this->get('item_id'));
			$this->_mItemLoadedFlag = true;
		}
	}
		
	public function setMyStep()
	{
		$this->loadItem();
		return $this->mItem->get('step');
	}
	
	public function loadMysteps()
	{
		global $xoopsDB;
    	$uid = Legacy_Utils::getUid();
    	$adminGroups = array();
    	$result = Legacy_Utils::getModuleHandler('approval', $this->getDirname())
    		->getApprovalResult($uid, $adminGroups, $this->mItem->get('type_id'), $this->mItem->getTargetGroupId());
        if ($result != false) {
	        while ($row = $xoopsDB->fetchArray($result)) {
	        	$this->mSteps[] = $row['step'];
	        }
        }
	}

	/**
	 * getShowResult
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getShowResult()
	{
		switch($this->get('result')){
			case Xleprogress_Result::HOLD:
				return _MD_XLEPROGRESS_LANG_RESULT_HOLD;
			case Xleprogress_Result::REJECT:
				return _MD_XLEPROGRESS_LANG_RESULT_REJECT;
			case Xleprogress_Result::APPROVE:
				return _MD_XLEPROGRESS_LANG_RESULT_APPROVE;
		}
	}
}

/**
 * Xleprogress_HistoryHandler
**/
class Xleprogress_HistoryHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = '{dirname}_history';

	public /*** string ***/ $mPrimary = 'progress_id';

	public /*** string ***/ $mClass = 'Xleprogress_HistoryObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

}

?>
