<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/class/AbstractEditAction.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';

/**
 * Xleprogress_ApprovalEditAction
**/
class Xleprogress_ApprovalEditAction extends Xleprogress_AbstractEditAction
{
	/**
	 * &_getHandler
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_ApprovalHandler
	**/
	protected function &_getHandler()
	{
		$handler =& $this->mAsset->getObject('handler', 'Approval');
		return $handler;
	}

	/**
	 * hasPermission
	 * 
	 * @param	void
	 * 
	 * @return	bool
	**/
	public function hasPermission()
	{
		global $xoopsUser;
		$permHandler =& xoops_gethandler('groupperm');
		return $permHandler->checkRight('module_admin', $this->mModule->mXoopsModule->get('mid'), $xoopsUser->getGroups());
	}

	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	bool
	**/
	public function prepare()
	{
		parent::prepare();
		if(! $this->mObject->isNew() && $this->mObject->countMyItem()>0){
			$this->mRoot->mController->executeRedirect('./index.php?action=ApprovalList', 1, _MD_XLEPROGRESS_ERROR_ITEM_REMAINS);
		}
	}

	/**
	 * _setupActionForm
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	protected function _setupActionForm()
	{
		$this->mActionForm =& $this->mAsset->getObject('form', 'Approval', false, 'edit');
		$this->mActionForm->prepare($this->mAsset->mDirname);
	}

	/**
	 * executeViewInput
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewInput(/*** XCube_RenderTarget ***/ &$render)
	{
		$render->setTemplateName($this->mAsset->mDirname . '_approval_edit.html');
		if(isset($_GET['type_id'])){
			$type_id = $_GET['type_id'];
			$this->mActionForm->set('type_id',$type_id);
		}
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('dirname', $this->mAsset->mDirname);
		
		// user list
		$userHandler =& $this->mAsset->getObject('handler', 'user');
		$userlist = $userHandler->getUserList();
		$render->setAttribute('userlist', $userlist);
		
		// group list
		$groupHandler =& $this->mAsset->getObject('handler', 'group');
		$grouplist = $groupHandler->getGroupList();

		$includeModerator = false;
		foreach ($grouplist as $group) {
			if ($group->get('name') == 'moderator' && $group->get('group_type') == '') {
				$includeModerator = true;
				break;
			}
		}
		if (!$includeModerator) {
			foreach ($groupHandler->getAdminGroup() as $admin) {
				$grouplist[] = $admin;
			}
		}

		$groupAdmin = $groupHandler->create();
		$groupAdmin->set('groupid', Xoonips_Enum::XLEPROGRESS_GROUP);
		$groupAdmin->set('name', _MD_XLEPROGRESS_LANG_GROUP_ADMIN);
		$grouplist[] = $groupAdmin;
		$render->setAttribute('grouplist', $grouplist);
		
		// type list
		$typeHandler =& $this->mAsset->getObject('handler', 'type');
		$typelist = $typeHandler->getTypeList();
		$render->setAttribute('typelist', $typelist);		
	}

	/**
	 * executeViewSuccess
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewSuccess(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeForward('./index.php?action=ApprovalList');
	}

	/**
	 * executeViewError
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewError(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeRedirect('./index.php?action=ApprovalList', 1, _MD_XLEPROGRESS_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * executeViewCancel
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewCancel(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeForward('./index.php?action=ApprovalList');
	}
}
?>
