<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpurl extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init() {
    parent::init();
    $this->set_ng_item_name('Url');
    $this->add_file_mapping_array('url_banner_file','banner_file');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnpurl_item_detail');
  }

  /**
   *
   * This function get xnpurl_item_detail table info.
   * 
   * @param int $item_id
   * @return mixed Success:xnpurl_item_detail Array includes fields, Fail:FALSE 
   */ 
  protected function get_xnpurl_item_detail($item_id){
    $tbl = get_WK_tbl('xnpurl_item_detail');
    $sql = "select * from {$tbl} where url_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }
  
  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    $item_id = $item['item_id'];
    $url = $this->get_xnpurl_item_detail($item_id);
    if($url === FALSE||$url === NULL){
      return -errmsg(APP_MIGRATE, 'E1401',$item_id);
    }
    $url_array = $this->get_table_column_by_group('url_hits',  $this->get_ng_item_name());
    if($url_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1402');
    }
    foreach ($url_array as $value) {
      switch ($value['xml']) {
        case 'url':
          $rc = $this->insert_any($value,$item_id,$url['url']);
          if($rc === FALSE){
            return -errmsg(APP_MIGRATE, 'E1403',$item_id);
          }
          break;
        case 'hits':
          $rc = $this->insert_any($value,$item_id,$url['url_count']);
          if($rc === FALSE){
            return -errmsg(APP_MIGRATE, 'E1405',$item_id);
          }          
          break;
      }
    }
    return 0;
  }
}
