<?php

/**
 * User related functions
 * 
 */

require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class groups {
  
  private $db;
  private $ng_gid;
  function __construct() {
    
  }
  

  /**
   * This function get current auto_inc (groupid).
   * 
   * 
   * @return Success:>0 current auto_inc,Fail:-1
   */
  private function current_auto_inc() {
    $tbl = get_tbl('groups');
    $sql = "show table status like '{$tbl}'" ;
    $reults=$this->db->query($sql);
    if($reults !== FALSE){
      return $reults[0]['Auto_increment'];
    }
    return -1;
  }

  /**
   * Get xoonips_group
   * 
   * @return int Success:>0,Fail:FALSE
   */
  private function get_xoonips_group(){
    $tbl = get_WK_tbl('xoonips_groups');
    $sql = "select gid from {$tbl}";
    $reults=$this->db->query($sql);
    if($reults !== FALSE){
      return $reults;
    }
    return FALSE;
  }

  /**
   * count moderator on group table.
   * 
   * @return int 0:not duplicate n>1:duplicate moderator gid
   */
  private function count_moderator() {
    $tbl = get_tbl("groups");
    $sql = "select count(groupid) as count,max(groupid) as max from {$tbl} WHERE name='moderator'";
    $result = $this->db->query($sql);
    if(is_array($result) && $result[0]['count'] > 1){
      return $result[0]['max'];
    }
    return 0;
  }
  
  /**
   * delete modatror
   * 
   * @param string $tbl group or groups_users_link
   * @param int    $gid gid,get from count_moderator
   * @return boolean Success:true,Fail:false
   */
  private function delete_moderator($tbl,$gid) {
    $deltbl = get_tbl($tbl);
    $sql = "delete from {$deltbl} where groupid={$gid}";
    return $this->db->exec($sql);
  }

  /**
   * if moderator duplicated,this fuction delete the latter moderator.
   */
  private function find_delete_duplicated_moderator() {
    #check duplicate moderator
    $max_gid = $this->count_moderator();
    if($max_gid == 0)return;
    $rc = $this->delete_moderator('groups_users_link',$max_gid);
    if($rc == false)return;
    $rc = $this->delete_moderator('groups',$max_gid);
    if($rc == false)return;
  }

    /**
   * xoonips_groups migrate to groups.
   *  
   */
  private function migrate_group()
  {
    $this->ng_gid = $this->current_auto_inc();  #start NG gid
    if($this->ng_gid === -1)return false;
    
    $tbl = get_tbl('groups');
    $wk_tbl = get_WK_tbl('xoonips_groups');
      
    $sql = "insert into {$tbl} (activate,groupid,name,description,group_type,index_id) ".
    "select 1,gid+{$this->ng_gid},gname,gdesc,'User',group_index_id from {$wk_tbl} where gid in (".
    "select gid from {$wk_tbl}  where gid not in (".
    "select distinct gid from xoops8_WK_xoonips_groups as xg , xoops8_groups as g where xg.gname = g.name))";
    return $this->db->exec($sql);    
  }
  
  public function get_last_autoinc() {
    return $this->ng_gid;
  }


  /**
   * Do migration.
   * 
   * @return int Sucess:0,Fail:0>
   */
  public function migrate() {
    $this->db = new migrate_db();
    if($this->db->connect() === FALSE){
      return -1;
    }
    $this->migrate_group();
    
    #delete to duplicat Moderator group.
    $this->find_delete_duplicated_moderator();
    
  
    return 0;
  }

}
