<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

if (!defined('USER_TRUST_PATH')) {
  $trustDirname = basename(dirname(dirname(__FILE__)));
  define('USER_TRUST_DIRNAME', $trustDirname);
  define('USER_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/' . $trustDirname);
}

require_once USER_TRUST_PATH . '/class/UserUtils.class.php';

User_AssetPreloadBase::prepare();


/**
 * User_AssetPreloadBase
**/
class User_AssetPreloadBase extends XCube_ActionFilter
{
	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public static function prepare()
	{
		$root =& XCube_Root::getSingleton();
		$instance = new User_AssetPreloadBase($root->mController);
		$root->mController->addActionFilter($instance);
	}

	/**
	 * preBlockFilter
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public function preBlockFilter()
	{
		$this->mRoot->mDelegateManager->add('Module.user.Global.Event.GetAssetManager','User_AssetPreloadBase::getManager');
		$this->mRoot->mDelegateManager->add('Legacy_Utils.CreateModule','User_AssetPreloadBase::getModule');
		$this->mRoot->mDelegateManager->add('Site.JQuery.AddFunction',array(&$this, 'addScript'));
		$file = USER_TRUST_PATH . '/class/DelegateFunctions.class.php';
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.UpdateStatus', 'User_DelegateFunctions::updateStatus', $file);
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.GetDetailView', 'User_DelegateFunctions::getDetailView', $file);
		$this->mRoot->mDelegateManager->add('Legacy_Workflow.GetTargetGroupId', 'User_DelegateFunctions::getTargetGroupId', $file);
		
	}
	/**
	 * addScript
	 * 
	 * @param	$jQuery  &$obj
	 * 
	 * @return	void
	**/
	public function addScript(&$jQuery) {
	     $jQuery->addLibrary('/common/js/prettyPopin/jquery.prettyPopin.js');
	     $jQuery->addStylesheet('/common/js/prettyPopin/jquery.prettyPopin.css');
	     $jQuery->addLibrary('/modules/user/js/user_edit.js');    
	}

	/**
	 * getManager
	 * 
	 * @param	User_AssetManager  &$obj
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public static function getManager(/*** User_AssetManager ***/ &$obj,/*** string ***/ $dirname)
	{
		require_once USER_TRUST_PATH . '/class/AssetManager.class.php';
		$obj = User_AssetManager::getInstance($dirname);
	}

	/**
	 * getModule
	 * 
	 * @param	Legacy_AbstractModule  &$obj
	 * @param	XoopsModule  $module
	 * 
	 * @return	void
	**/
	public static function getModule(/*** Legacy_AbstractModule ***/ &$obj,/*** XoopsModule ***/ $module)
	{
		if($module->getInfo('trust_dirname') == 'user')
		{
			require_once USER_TRUST_PATH . '/class/Module.class.php';
			$obj = new User_Module($module);
		}
	}

	/**
	 * getBlock
	 * 
	 * @param	Legacy_AbstractBlockProcedure  &$obj
	 * @param	XoopsBlock	$block
	 * 
	 * @return	void
	**/
	public static function getBlock(/*** Legacy_AbstractBlockProcedure ***/ &$obj,/*** XoopsBlock ***/ $block)
	{
		$moduleHandler =& UserUtils::getXoopsHandler('module');
		$module =& $moduleHandler->get($block->get('mid'));
		if(is_object($module) && $module->getInfo('trust_dirname') == 'user')
		{
			require_once USER_TRUST_PATH . '/blocks/' . $block->get('func_file');
			$className = 'User_' . substr($block->get('show_func'), 4);
			$obj = new $className($block);
		}
	}
}


