<?php

require_once 'ViewTypeMaximumIndexes.class.php';

class User_ViewTypeMaximumSpace extends User_ViewTypeMaximumIndexes {

	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('len', $field->getLen());
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		if ($value != '') {
			$this->getXoopsTpl()->assign('value', $value / 1024 / 1024);
		} else {
			$this->getXoopsTpl()->assign('value', $value);
		}
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * get registry view
	 *
	 * @param object $field
	 * @return array
	 */
	public function getRegistryView($field) {
		$result = array();
		XCube_DelegateUtils::call('Module.User.GetUserMaximumResources', new XCube_Ref($result), null);
		
		if (count($result) > 0) {
			foreach ($result as $limit) {
				$default = $limit['itemStorageLimit'];
			}
		} else {
			$default = $field->getDefault();
		}
		return $this->getInputView($field, $default, 1);
	}

	/**
	 *
	 * set registry data into array
	 *
	 * @param object $field
	 *        array $data
	 *        array $sqlStrings
	 *        int  $groupLoopId
	 * @return
	 */
	public function doRegistry($field, &$data, &$sqlStrings, $groupLoopId) {
		$tableName = $field->getTableName();
		$columnName = $field->getColumnName();
		//get data
		$value = $this->getData($field, $data, $groupLoopId) * 1024 * 1024;
		$tableData;
		$columnData;

		if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}

		if (isset($tableData[$columnName])) {
			$columnData = &$tableData[$columnName];
		} else {
			$columnData = array();
			$tableData[$columnName] = &$columnData;
		}
		//set value into array
		$columnData[] = $field->getDataType()->convertSQLStr($value);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$data = '';
		if (is_array($value)) {
			foreach ($value as $v) {
				$data = $data . $v . ',';
			}
			$data = substr($data, 0, strlen($data) - 1);
		} else {
			$data = $value;
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
   		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $data);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$data = '';
		if (is_array($value)) {
			foreach ($value as $v) {
				$data = $data . $v . ',';
			}
			$data = substr($data, 0, strlen($data) - 1);
		} else {
			$data = $value;
		}
   		$this->getXoopsTpl()->assign('viewType', 'detail');
   	    $this->getXoopsTpl()->assign('value', $data / 1024 / 1024);   
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
}

