<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';

/**
 * @brief operate groups table
 *
 */
class User_GroupsBean extends Xoonips_BeanBase {
	private $linkTable = null;

	/**
	 * Constructor
	 **/
	public function User_GroupsBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('groups');
		$this->linkTable = $this->prefix('groups_users_link');
	}

	/**
	 * get group
	 *
	 * @param int $groupId:groupid
	 * @return array
	 */
	public function getGroup($groupId) {
		$ret = array();
		$sql = "SELECT * FROM $this->table";
		$sql = $sql . " WHERE groupid=$groupId";

		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert group
	 *
	 * @param array $group
	 * @return int
	 */
	public function insert($group) {
		$ret = true;
		$sql = "INSERT INTO $this->table (activate,name,description,icon,mime_type,is_public,can_join,is_hidden,member_accept,";
		$sql = $sql . 'item_accept,item_number_limit,index_number_limit,item_storage_limit,group_type)';
		$sql = $sql . ' VALUES(' .$group['activate'] . ',' . Xoonips_Utils::convertSQLStr($group['name']). ',' . Xoonips_Utils::convertSQLStr($group['description']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLStr($group['icon']). ',' . Xoonips_Utils::convertSQLStr($group['mime_type']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLNum($group['is_public']). ',' . Xoonips_Utils::convertSQLNum($group['can_join']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLNum($group['is_hidden']). ',' . Xoonips_Utils::convertSQLNum($group['member_accept']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLNum($group['item_accept']). ',' . Xoonips_Utils::convertSQLNum($group['item_number_limit']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLNum($group['index_number_limit']). ',' . Xoonips_Utils::convertSQLNum($group['item_storage_limit']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLStr($group['group_type']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = $this->getInsertId();
		return $ret;
	}

	/**
	 * delete group
	 *
	 * @param int $groupId:groupid
	 * @return bool true:success,false:failed
	 */
	public function delete($groupId) {
		$ret = true;
		$sql = "DELETE FROM $this->table WHERE groupid=$groupId";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 * update group
	 *
	 * @param array $group
	 * @return bool true:success,false:failed
	 */
	public function update($group) {
		$ret = true;
		$sql = "UPDATE $this->table set activate=" . Xoonips_Utils::convertSQLNum($group['activate']) . ',name=' . Xoonips_Utils::convertSQLStr($group['name']);
		$sql = $sql . ',description=' . Xoonips_Utils::convertSQLStr($group['description']) . ',icon=' . Xoonips_Utils::convertSQLStr($group['icon']);
		$sql = $sql . ',mime_type=' . Xoonips_Utils::convertSQLStr($group['mime_type']) . ',is_public=' . Xoonips_Utils::convertSQLNum($group['is_public']);
		$sql = $sql . ',can_join=' . Xoonips_Utils::convertSQLNum($group['can_join']) . ',is_hidden=' . Xoonips_Utils::convertSQLNum($group['is_hidden']);
		$sql = $sql . ',member_accept=' . Xoonips_Utils::convertSQLNum($group['member_accept']) . ',item_accept=' . Xoonips_Utils::convertSQLNum($group['item_accept']);
		$sql = $sql . ',item_number_limit=' . Xoonips_Utils::convertSQLNum($group['item_number_limit']);
		$sql = $sql . ',index_number_limit=' . Xoonips_Utils::convertSQLNum($group['index_number_limit']);
		$sql = $sql . ',item_storage_limit=' . Xoonips_Utils::convertSQLNum($group['item_storage_limit']);
		$sql = $sql . ' WHERE groupid=' . $group['groupid'];
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 * get admin groupid
	 *
	 * @param int $uid:uid
	 * @return array
	 */
	public function getAdminGroupIds($uid) {
		$ret = array();

		$sql = "SELECT a.groupid FROM $this->linkTable a,$this->table b";
		$sql = $sql . " WHERE a.groupid=b.groupid AND a.uid=$uid AND a.is_admin=" . Xoonips_Enum::GRP_ADMINISTRATOR;
		$sql = $sql . ' AND b.activate<>' . Xoonips_Enum::GRP_NOT_CERTIFIED . ' AND a.activate<>' . Xoonips_Enum::GRP_US_JOIN_REQUIRED;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row['groupid'];
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * get my groupid
	 *
	 * @param int $uid:uid
	 * @return array
	 */
	public function getMyGroupIds($uid) {
		$ret = array();

		$sql = "SELECT groupid FROM $this->linkTable a,$this->table b";
		$sql = $sql . " WHERE a.groupid=b.groupid AND a.uid=$uid";
		$sql = $sql . ' AND b.activate<>' . Xoonips_Enum::GRP_NOT_CERTIFIED . ' AND a.activate<>' . Xoonips_Enum::GRP_US_JOIN_REQUIRED;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row['groupid'];
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * get admin groupid
	 *
	 * @param int $uid:uid
	 * @return  bool true:isPublic,false:is't Public
	 */
	public function isPublic($groupid) {
		$ret = false;
	    $sql = "SELECT groupid FROM $this->table WHERE groupid=$groupid";
	    $sql = $sql . ' AND (activate=' . Xoonips_Enum::GRP_PUBLIC . ' OR activate=' . Xoonips_Enum::GRP_CLOSE_REQUIRED . ')';
        if (($result = $this->execute($sql)) && $this->getRowsNum($result) > 0) {
            $ret = true;
        } else {
            $ret = false;
        }
	    return $ret;
	}

	/**
     * retrieve groups for a user
     *
     * @param int $uid:id of the user
     * @return array
     */
    public function getGroupIdsByUser($uid) {
        $ret = array();
        $sql = 'SELECT groupid FROM ' . $this->linkTable . ' WHERE uid=' . intval($uid);
        $result = $this->execute($sql);
        if (!$result) {
            return $ret;
        }
        while ($row = $this->fetchArray($result)) {
            $ret[] = $row['groupid'];
        }
        return $ret;
    }

	/**
	 * get all groups
	 *
	 * @param
	 * @return array
	 */
	public function getGroups($groupType, $operation = '=') {
		$ret = array();
		$sql = "SELECT * FROM $this->table WHERE group_type" . $operation . Xoonips_Utils::convertSQLStr($groupType) . " order by name";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * get all groups
	 *
	 * @param
	 * @return array
	 */
	public function getAllGroups($activate) {
		$ret = array();
		$sql = "SELECT groupid,name FROM $this->table WHERE";
		$sql .= " activate>=" . $activate . " or group_type<>" . Xoonips_Utils::convertSQLStr(Xoonips_Enum::GROUP_TYPE) . " order by name";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[$row['groupid']] = $row['name'];
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * update activate
	 *
	 * @param int $groupid:groupid
	 * @return bool true:success,false:failed
	 */
	public function updateActivate($groupid) {
		$ret = true;
		$sql = "UPDATE $this->table set activate=" . Xoonips_Enum::GRP_DELETE_REQUIRED;
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 * groups certify
	 *
	 * @param int $groupid:groupid
	 * @return bool true:success,false:failed
	 */
	public function groupsCertify($groupid) {
		$sql = "UPDATE $this->table set activate=" . Xoonips_Enum::GRP_CERTIFIED;
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * active group
	 *
	 * @param int $groupid : groupid
	 *
	 * @return bool true:success,false:failed
	 */
	public function activeGroup($groupid) {
		$ret = true;
		$sql = "UPDATE $this->table set activate=" . Xoonips_Enum::GRP_CERTIFIED;
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
	/**
	 * groups open
	 *
	 * @param int $groupid:groupid
	 * @return bool true:success,false:failed
	 */
	public function groupsOpen($groupid) {
		$sql = "UPDATE $this->table set activate=" . Xoonips_Enum::GRP_PUBLIC . ',is_public=1';
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * groups close
	 *
	 * @param int $groupid:groupid
	 * @return bool true:success,false:failed
	 */
	public function groupsClose($groupid) {
		$sql = "UPDATE $this->table set activate=" . Xoonips_Enum::GRP_CERTIFIED . ',is_public=0';
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * judge if the group is exist
	 *
	 * @param string $gname: name
	 * @return  bool true:exist,false:not exist
	 */
	public function existsGroup($gname) {
		$ret = false;
		$sql = "SELECT * FROM $this->table WHERE name=" . Xoonips_Utils::convertSQLStr($gname);
		if (($result = $this->execute($sql)) && $this->getRowsNum($result) > 0) {
            $ret = true;
        }
		return $ret;
	}

	/**
	 * update group index
	 *
	 * @param int $groupid : groupid
	 *         int $indexid : index_id
	 * @return bool true:success,false:failed
	 */
	public function updateGroupIndex($groupid, $indexid) {
		$ret = true;
		$sql = "UPDATE $this->table set index_id = $indexid";
		$sql = $sql . ' WHERE groupid=' . $groupid;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
}

