<?php

require_once dirname(dirname(__FILE__)) . '/class/core/User.class.php';
require_once dirname(dirname(__FILE__)) . '/class/core/ActionBase.class.php';

class User_UserRegisterAction extends User_ActionBase {
	
	/**
	 * 
	 * get user id
	 * 
	 * @param 
	 * @return int
	 */
	private function getUserId() {
		global $xoopsUser;
		return is_object($xoopsUser) ?  $xoopsUser->getVar('uid') : 0;
	}
	
	/**
	 * 
	 * initialization view
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doInit(&$request, &$response) {
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['allow_register'] != 1) {
			$response->setSystemError(_MD_USER_LANG_NOREGISTER);
			return false;
		}		
		
		$user = User_User::getInstance();
		$errors = new Xoonips_Errors();
		$viewData = array();
		$viewData['registryView'] = $user->getRegistryView($this->getUserId());
		$viewData['isConfirm'] = true;
		
		if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
			$reg_disclaimer = $user->getDisclaimer();
			$viewData['disclaimer'] = $reg_disclaimer;
		}
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}

	/**
	 * 
	 * confirm view
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doConfirm(&$request, &$response) {
		$user = User_User::getInstance();
		$errors = new Xoonips_Errors();
		$user->setDataFromPost($_POST);
		$user->inputCheck($errors);
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
			if ($_POST['agree_disc'] != 1) {
				$parameters = array();
				$errors->addError('_MD_USER_ERROR_UNEEDAGREE', '', $parameters);
			}
		}
		$viewData = array();
		//inputError
		if (count($errors->getErrors()) != 0) {
			$viewData['registryView'] = $user->getRegistryViewWithData($this->getUserId());
			$viewData['isConfirm'] = true;
			$viewData['errors'] = $errors->getView($this->dirname);
			if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
				$agreeDisc = $_POST['agree_disc'];
				$reg_disclaimer = $user->getDisclaimer($agreeDisc);
				$viewData['disclaimer'] = $reg_disclaimer;
			}
			$response->setForward('inputError');
		}
		else{
			$viewData['registryView'] = $user->getConfirmView($this->getUserId());
			$viewData['isRegistry'] = true;
			//set ticket
			$token_ticket = $this->createToken('register_user');
			$viewData['token_ticket'] = $token_ticket;
			$response->setForward('success');
		}
		$response->setViewData($viewData);
		return true;
	}

	/**
	 * 
	 * do cancel
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doCancel(&$request, &$response) {
		$user = User_User::getInstance();
		$user->setDataFromPost($_POST);
		$viewData = array();
		$viewData['registryView'] = $user->getRegistryViewWithData($this->getUserId());
		$viewData['isConfirm'] = true;
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
			$reg_disclaimer = $user->getDisclaimer();
			$viewData['disclaimer'] = $reg_disclaimer;
		}
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}

	/**
	 * 
	 * add item group
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doAddItemGroup(&$request, &$response) {
		$user = User_User::getInstance();
		$targetItemId = $_POST['targetItemId'];
		$user->setDataFromPost($_POST);
		//add item group
		$user->addItemGroup($targetItemId);
		$viewData = array();
		$viewData['registryView'] = $user->getRegistryViewWithData($this->getUserId());
		$viewData['isConfirm'] = true;
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
			$agreeDisc = $_POST['agree_disc'];
			$reg_disclaimer = $user->getDisclaimer($agreeDisc);
			$viewData['disclaimer'] = $reg_disclaimer;
		}
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}

	/**
	 * 
	 * delete item group
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doDelItemGroup(&$request, &$response) {
		$user = User_User::getInstance();
		$targetItemId = $_POST['targetItemId'];
		$user->setDataFromPost($_POST);
		//delete item group
		$user->delItemGroup($targetItemId);
		$viewData = array();
		$viewData['registryView'] = $user->getRegistryViewWithData($this->getUserId());
		$viewData['isConfirm'] = true;
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['reg_dispdsclmr'] == 1) {
			$agreeDisc = $_POST['agree_disc'];
			$reg_disclaimer = $user->getDisclaimer($agreeDisc);
			$viewData['disclaimer'] = $reg_disclaimer;
		}
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}

	/**
	 * 
	 * do registry
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doRegistry(&$request, &$response) {
		$user = User_User::getInstance();
		$sendMailMsg = '';
		$viewData = array();
		$insertInfo = array();
		$user->setDataFromPost($_POST);
		
		//check ticket
		if (!$this->validateToken('register_user')) {
			$response->setSystemError('Ticket error');
	        return false;
	    }
		
		// start transaction
		$this->startTransaction();
		$insertInfo = $user->doRegistry($this->getUserId());

		//get insert id
		$newid = $insertInfo['newId'];
		$insertError = $insertInfo['insertError'];
		//if insert error
		if ($insertError) {
			$response->setSystemError('insert error!');
			return false;
		}
	
		$uname = $insertInfo['uname'];
		$email = $insertInfo['email'];
		$actkey = $insertInfo['actkey'];
		$name = $insertInfo['name'];
		/*$result = array();
		XCube_DelegateUtils::call('Module.User.GetMessageSign', new XCube_Ref($result));
		foreach ($result as $messageSign) {
			$myxoopsConfig = $messageSign;
		}*/
		$myxoopsConfig = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF);
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$certify_user = $myxoopsConfigUser['certify_user'];
		$is_certify_auto = ($certify_user == 'auto');
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$newUser = $userBean->getUserBasicInfo($newid);
		//send mail
		if ($myxoopsConfigUser['activation_type'] == 0) {
			// activate xoops account by user
			$xoopsMailer =& getMailer();
			$xoopsMailer->useMail();
			$xoopsMailer->setTemplateDir(Xoonips_Utils::mailTemplateDir($this->dirname, $this->trustDirname));
			$xoopsMailer->setTemplate('user_activate_by_user_notify.tpl');
			$xoopsMailer->assign('X_UACTLINK', XOOPS_URL . '/user.php?op=actv&id=' . $newid . '&actkey=' . $actkey);
			$xoopsMailer->assign('SITENAME', $myxoopsConfig['sitename']);
			$xoopsMailer->assign('ADMINMAIL', $myxoopsConfig['adminmail']);
			$xoopsMailer->assign('SITEURL', XOOPS_URL . '/');
			$xoopsMailer->assign('USER_UNAME', $newUser['uname']);
			$xoopsMailer->assign('USER_NAME', $newUser['name']);
			$xoopsMailer->assign('USER_EMAIL', $newUser['email']);
			$xoopsMailer->assign('USER_COMPANY_NAME', $newUser['company']);
			$xoopsMailer->assign('USER_DIVISION', $newUser['division']);
			$xoopsMailer->assign('USER_ADDRESS', $newUser['user_from']);
			$xoopsMailer->assign('USER_COUNTRY', $newUser['country']);
			$xoopsMailer->assign('USER_DETAIL_URL', XOOPS_URL . '/userinfo.php?uid=' . $newid);
				
			$xoopsMailer->setToUsers(new XoopsUser($newid));
			$xoopsMailer->setFromEmail($myxoopsConfig['adminmail']);
			$xoopsMailer->setFromName($myxoopsConfig['sitename']);
			$xoopsMailer->setSubject(_MD_USER_MESSAGE_ACCOUNT_ACTIVATE_NOTIFYSBJ);
			if (!$xoopsMailer->send()) {
				$sendMailMsg = $sendMailMsg . _US_YOURREGMAILNG;
			} else {
				if ($is_certify_auto) {
					$sendMailMsg = $sendMailMsg . _MD_USER_MESSAGE_ACTIVATE_BY_USER_CERTIFY_AUTO;
				} else {
					$sendMailMsg = $sendMailMsg . _MD_USER_MESSAGE_ACTIVATE_BY_USER_CERTIFY_MANUAL;
				}
			}
		}
		// send e-mail to XOOPS Admin
		if ($myxoopsConfigUser['new_user_notify'] == 1 && !empty($myxoopsConfigUser['new_user_notify_group'])) {
			$xoopsMailer =& getMailer();
			$xoopsMailer->useMail();
			$member_handler =& xoops_gethandler('member');
			$xoopsMailer->setToGroups($member_handler->getGroup($myxoopsConfigUser['new_user_notify_group']));
			$xoopsMailer->setFromEmail($myxoopsConfig['adminmail']);
			$xoopsMailer->setFromName($myxoopsConfig['sitename']);
			$xoopsMailer->setSubject(sprintf(_US_NEWUSERREGAT, $myxoopsConfig['sitename']));
			$xoopsMailer->setBody(sprintf(_US_HASJUSTREG, $uname));
			$xoopsMailer->send();
		}
		
		//set forward
		$response->setViewData(array('registryMsgView' => $sendMailMsg));
		$response->setForward('registry_success');
		return true;
	}
}

