<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOONIPS_CONTROL_PATH.'control_base.php';
require_once XOONIPS_MODEL_PATH.'model_itemdel.php';

class itemdel extends control_base {

  public function init() {
  }

  public function run($req) {
    $item_id = $req->get('item_id');
    if (is_null($item_id)) {
      $this->rest_notify_err(400, 'item_id don\'t specify.');
      exit();
    } else {
      $model_itemdel = new model_itemdel();
      $model_itemdel->Init();
      $model_itemdel->set_uid($this->uid);
      $rc = $model_itemdel->del($item_id);
      if ($rc == -5) {
        $msg = $model_itemdel->get_error_info($rc);
        $this->rest_notify_err(403, $msg,$item_id);
      }else if($rc != 0) {
        $msg = $model_itemdel->get_error_info($rc);
        $this->rest_notify_err(404, $msg,$item_id);
      }
    }
  }
}
