<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
/**
 * @brief operate xoonips_item_type_search_condition_detail table
 *
 */
class Xoonips_ItemTypeSearchConditionDetailBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemTypeSearchConditionDetailBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_type_search_condition_detail', true);
	}

	/**
	 * select search condition detail
	 *
	 * @param $cond_id condition_id
	 * @return array
	 */
	public function select($cond_id) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table . " WHERE condition_id=$cond_id";
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * select search condition detail
	 *
	 * @param $cond_id condition_id
	 * @param $itemtypeId item_type_id
	 * @return array
	 */
	public function selectByItemtypeId($cond_id, $itemtypeId) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table . " WHERE condition_id=$cond_id AND item_type_id=$itemtypeId";
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id
	 * @return bool true:success,false:failed
	 */
	public function delete($condId) {
		$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=$condId";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id, $itemtypeId itemtype id
	 * @return bool true:success,false:failed
	 */
	public function deleteByItemtypeId($condId, $itemtypeId) {
		if (is_null($condId)) {
			$sql = 'DELETE FROM ' . $this->table . " WHERE item_type_id=$itemtypeId";
		} else {
			$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=$condId AND item_type_id=$itemtypeId";
		}
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id, $detailId detail id
	 * @return bool true:success,false:failed
	 */
	public function deleteByDetailId($condId, $detailId=0) {
		$sql_detail = "";
		if ($detailId > 0) $sql_detail = " AND item_field_detail_id=$detailId";
		$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=$condId".$sql_detail;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * select search quicksearch detail
	 *
	 * @param $item_field_detail_id
	 * @return array
	 */
	public function getQuickSearchDetail($item_field_detail_id) {
		$ret = false;
		$sql = 'SELECT * FROM ' . $this->table . " WHERE item_field_detail_id=$item_field_detail_id";
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret = true;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert search condition detail
	 *
	 * @param $info
	 * @return bool true:success,false:failed
	 */
	public function insert($info) {
		$sql = 'INSERT INTO ' . $this->table . ' ( condition_id, item_type_id, item_field_detail_id ) '
			. '  VALUE (' . Xoonips_Utils::convertSQLStr($info['condition_id']) . ','
			. Xoonips_Utils::convertSQLStr($info['item_type_id']) . ','
			. Xoonips_Utils::convertSQLStr($info['item_field_detail_id']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}
}

