<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class Xoonips_SystemItemFieldSelectAction extends Xoonips_ActionBase {
	
	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_SYSTEM_VALUE_TITLE;
		//description
		$description = _AM_XOONIPS_SYSTEM_VALUE_TITLE_DESC;
		// breadcrumbs
		$breadcrumbs = array(
			array(
		    	'name' => _AM_XOONIPS_TITLE,
		    	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
		  	),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/system.php',
			),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_VALUE_TITLE,
			),
		);
				
		// token ticket		
		$token_ticket = $this->createToken($this->modulePrefix('admin_system_itemtypeselection'));
		
		//get the item type value
		$itemFieldValueSetBean=Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		$selectnames = $itemFieldValueSetBean->getSelectNames();
		$selects = array();
		foreach($selectnames as $selectname){	
			$name = array();	
			$name['selectname'] = $selectname;		
			$name['selectnamehid'] = urlencode($selectname);
			$selects[] = $name;		  				
		}
		
		// get common viewdata
		$viewData = array();
		
		$viewData['token_ticket'] = $token_ticket;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['selects'] = $selects;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doEdit(&$request, &$response) {
		
		// get variables of "mode"
		$mode = $request->getParameter2('mode');
		$select_name = $request->getParameter2('select_name');
		$select_name_db = $request->getParameter2('select_name_db');
		if ($select_name_db != '') {
			$valueName = $select_name_db;
		} else {
			$valueName = $select_name;
		}
		$namehdn = urlencode($valueName);
		if ($mode == 1 && $valueName == '') {
			$xoonipsErrors = new Xoonips_Errors();
			$parameters[] = _AM_XOONIPS_SYSTEM_VALUE_NAME;
			$xoonipsErrors->addError('_AM_XOONIPS_ERROR_REQUIRED', 'select_name', $parameters);
			$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
		}

		//get title
		if ($valueName != '') {
			$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
			$valueDetails = $itemFieldValueSetBean->getValueDetail($valueName);
			if (count($valueDetails) > 0) {
				if ($mode == 1) {
					$xoonipsErrors = new Xoonips_Errors();
					$parameters[] = null;
					$xoonipsErrors->addError('_AM_XOONIPS_ERROR_SELECT_NAME_EXISTS', 'select_name', $parameters);
					$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
				} elseif ($mode == 2) {
					$names = array();
					foreach ($valueDetails as $keys => $valueDetail) {
						$canIdEdit = true; 
						if ($itemFieldValueSetBean->checkUsedTitleId($valueName, $valueDetail['title_id']) > 0) {
							$canIdEdit = false;
						}  
						$names[] = array(
							//'select_name' => $valueName,
							//'namehdn' => $namehdn,
							'id' => $valueDetail['title_id'],
			    			'title' => $valueDetail['title'],
							'weight' => $valueDetail['weight'],
							'canIdEdit' => $canIdEdit
		  				);
					}  
				}
			}
		}
		
		//title
		$title = _AM_XOONIPS_SYSTEM_VALUE_EDIT;
		//description
		$description = _AM_XOONIPS_SYSTEM_VALUE_EDIT_DESC;
		// breadcrumbs
		$breadcrumbs = array(
			array(
				'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/system.php',
			),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_VALUE_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_itemfield_select.php'
			),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_VALUE_EDIT,
			),
		);
		$namehdn = urlencode($valueName);
		// token ticket		
		$token_ticket = $this->createToken($this->modulePrefix('admin_system_itemtypeselection'));
		
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['namehdn'] = $namehdn;
		$viewData['mode'] = $mode;
		$viewData['select_name'] = $valueName;
		$viewData['token_ticket'] = $token_ticket;
		if ($mode == 2) {
			$viewData['select_name_db'] = $valueName;
			$viewData['objects'] = $names;
		}
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('edit_success');		
		return true;
	}
	
	protected function doDelete(&$request, &$response) {
		
		//get variables
		$valueName = $request->getParameter2('select_name');
		$id = $request->getParameter2('delete_id');		

		// delete db value
		$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		$itemFieldValueSet = $itemFieldValueSetBean->getInfo($id, $valueName);	
		$title = $itemFieldValueSet['title'];	
		if ($itemFieldValueSetBean->checkUsedTitleId($valueName, $id) > 0) {
			$viewData['redirect_msg'] = _AM_XOONIPS_ERROR_VALUE_DELETE;
		} else {
			$itemFieldValueSetBean->deleteItemsValue($id, $valueName);
			$viewData['redirect_msg'] = XCube_Utils::formatString(_AM_XOONIPS_SYSTEM_VALUE_DELETE, $title);
		}

		$valueName = urlencode($valueName);
		$viewData['url'] = XOOPS_URL . '/modules/' . $this->dirname . '/admin/system_itemfield_select.php?' . "op=edit&action=modify&mode=2&select_name=$valueName";
		
		$response->setViewData($viewData);
		$response->setForward('delete_success');
		return true;
	}
	
	protected function doSave(&$request, &$response) {
		
		// check token ticket		
		if ( !$this->validateToken( $this->modulePrefix('admin_system_itemtypeselection') ) ) {
			$response->setSystemError('Ticket error');
			return false;
		}
		
		// get mode
		$mode = $request->getParameter('mode');

		// update select name
		$oldname = $request->getParameter2('select_name_db');
		if ($mode == 1) {
			$newname = $request->getParameter2('select_name');
			$newname = urlencode($newname);
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_itemfield_select.php?'."op=edit&action=modify&mode=2&select_name=$newname";
		} elseif ($mode == 2 || $mode == 3) {
			$oldname = urlencode($oldname);
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_itemfield_select.php?'."op=edit&action=modify&mode=2&select_name=$oldname";
		} elseif ($mode == 5) {
			$newname = $request->getParameter2('select_name');
			if ($newname != $oldname) {
				$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
				$selectnames = $itemFieldValueSetBean->checkSelectNames(addslashes($newname));	
				if ($selectnames == NULL) {
					$itemFieldValueSetBean->updateSelectName($oldname,$newname);
				    $itemFieldValueSetBean->updateSelectNameDetail($oldname,$newname);
				} else {
					$oldname=urlencode($oldname);						
					$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_itemfield_select.php?'."op=edit&action=modify&mode=2&select_name=$oldname";
					$viewData['redirect_msg'] = _AM_XOONIPS_SYSTEM_VALUE_WRONGUPDATE;
					$response->setViewData($viewData);
					$response->setForward('save_success');
					return true;
				}
			}
			$newname=urlencode($newname);
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_itemfield_select.php?'."op=edit&action=modify&mode=2&select_name=$newname";
		// update sort		
		} elseif ($mode == 6) {
			$display_names = $request->getParameter2('display_name');
			$oldname = $request->getParameter2('select_name_db');
			$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
			$num = 1;
			foreach ($display_names as $id => $display) {
				if ($display != $num) {	
					$itemFieldValueSetBean->updateItemTypeWeight($id, $oldname, $num);
				}
				$num++;
			}
			$oldname = urlencode($oldname);
			$viewData['url'] = XOOPS_URL . '/modules/' . $this->dirname . '/admin/system_itemfield_select.php?' . "op=edit&action=modify&mode=2&select_name=$oldname";
		} else {
			return true;
		}
		$viewData['redirect_msg'] = _AM_XOONIPS_MSG_DBUPDATED;
		$response->setViewData($viewData);
		$response->setForward('save_success');
		return true;
	}
	
	protected function doBack(&$request, &$response) {
		
		//title
		$title = _AM_XOONIPS_SYSTEM_VALUE_TITLE;
		//description
		$description = _AM_XOONIPS_SYSTEM_VALUE_TITLE_DESC;
		// breadcrumbs
		$breadcrumbs = array(
			array(
		    	'name' => _AM_XOONIPS_TITLE,
		    	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
		    	'name' => _AM_XOONIPS_SYSTEM_TITLE,
		    	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/system.php',
			),
			array(
			    'name' => _AM_XOONIPS_SYSTEM_VALUE_TITLE,
			),
		);
				
		// token ticket		
		$token_ticket = $this->createToken($this->modulePrefix('admin_system_itemtypeselection'));
		
		//get the item type value
		$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		$selectnames = $itemFieldValueSetBean->getSelectNames();
		$selects = array();
		foreach($selectnames as $selectname) {	
			$name = array();	
			$name['selectname'] = $selectname;		
			$name['selectnamehid'] = urlencode($selectname);
			$selects[] = $name;
		}
		
		$viewData['token_ticket'] = $token_ticket;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['selects'] = $selects;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('back_success');	
		return true;
	}
}

