<?php

global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpbook extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Book');
    $this->add_file_mapping_array('book_pdf','files');
    
    #Description migrate to ...
    $this->set_description('outline');    
    
    #Duplicate Table
    $this->add_dup_table('xnpbook_author');
    $this->add_dup_table('xnpbook_item_detail');
  }
  
  /**
   *
   * get xnpbook_item_detail fields .
   *  
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE
   */
  protected function get_xnpbook_item_detail($item_id) {
    $wktbl = get_WK_tbl('xnpbook_item_detail');
    $sql = "select * from {$wktbl} where book_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      $arr =  $result_array[0];
      $arr['hits'] = 0;
      return $arr;
    }
    return FALSE;    
  }
  
  /**
   *
   * get xnpbook_author
   * 
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE 
   */
  protected function get_xnpbook_author($item_id){
    $wktbl = get_WK_tbl('xnpbook_author');
    $sql = "select * from {$wktbl} where book_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) >0){
      return $result_array;
    }
    return FALSE;    
  }
  
  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  function migrate($item) {
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnpbook_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E1101',$item_id);
    }
    
    #Editor
    $editor_array = $this->get_table_column_by_group('editor');
    if($editor_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1104');
    }
    $rc = $this->insert_any($editor_array,$item_id,$item_detail['editor']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1105',$item_id);
    }
    
    $pub_array = $this->get_table_column_by_group('publisher_name');
    if($pub_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1102');
    }
    $rc = $this->insert_any($pub_array,$item_id,$item_detail['publisher']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1106',$item_id);
    }    
    
    #year
    $isbn_array = $this->get_table_column_by_group('publication_year');
    if($isbn_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1118');
    }
    $rc = $this->insert_any($isbn_array,$item_id,$item['publication_year']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1119',$item_id);
    }
    
    #isbn
    $isbn_array = $this->get_table_column_by_group('isbn');
    if($isbn_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1107');
    }
    $rc = $this->insert_any($isbn_array,$item_id,$item_detail['isbn']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1108',$item_id);
    }
    
    #url
    $value = $this->get_table_column_by_group('url');
    if($value === FALSE){
      return -errmsg(APP_MIGRATE, 'E1109');
    }

    $rc = $this->insert_any($value,$item_id,$item_detail[$value['xml']]);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1110',$item_id);
    }

    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit');
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1111');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1112',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify');
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1113');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1114',$item_id);
    }
    
    #author and author_id
    $author_array = $this->get_xnpbook_author($item_id);
    if($author_array === FALSE){
      return errmsg(APP_MIGRATE, 'E1117',$item_id);
    }
    $name_array = $this->get_table_column_by_group('authors');
    if($name_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1115');
    }

    foreach ($author_array as $author) {
      $rc = $this->insert_any($name_array,$item_id,$author['author'],$author['author_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1116',$item_id);
      }
    }

    return 0;
  }
}
