<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * User_Utils
**/
class UserUtils
{
	/**
	 * &getXoopsHandler
	 * 
	 * @param	string	$name
	 * @param	bool  $optional
	 * 
	 * @return	XoopsObjectHandler
	**/
	public static function &getXoopsHandler(/*** string ***/ $name,/*** bool ***/ $optional = false)
	{
		// TODO will be emulated xoops_gethandler
		return xoops_gethandler($name,$optional);
	}

	/**
	 * &getModuleHandler
	 * 
	 * @param	string	$name
	 * @param	string	$dirname
	 * 
	 * @return	XoopsObjectHandleer
	**/
	public static function &getModuleHandler(/*** string ***/ $name,/*** string ***/ $dirname)
	{
		// TODO will be emulated xoops_getmodulehandler
		return xoops_getmodulehandler($name,$dirname);
	}

	/**
	 * &getUserHandler
	 * 
	 * @param	string	$name
	 * @param	string	$dirname
	 * 
	 * @return	XoopsObjectHandleer
	**/
	public static function &getUserHandler(/*** string ***/ $name,/*** string ***/ $dirname)
	{
		$asset = null;
		XCube_DelegateUtils::call(
			'Module.user.Global.Event.GetAssetManager',
			new XCube_Ref($asset),
			$dirname
		);
		if(is_object($asset) && is_a($asset, 'User_AssetManager'))
		{
			return $asset->getObject('handler',$name);
		}
	}

	/**
	 * getEnv
	 * 
	 * @param	string	$key
	 * 
	 * @return	string
	**/
	public static function getEnv(/*** string ***/ $key)
	{
		return getenv($key);
	}

	public static function setupUserActivity(/*** User_SotryObject ***/ $obj)
	{
		$activity = null;
		XCube_DelegateUtils::call('Legacy_Activity.CreateActivityObject', new XCube_Ref($activity), 'user');
		$activity->set('dirname', $obj->getDirname());
		$activity->set('dataname', 'story');
		$activity->set('id', $obj->get('sotry_id'));
		$activity->set('uid', $obj->get('uid'));
		$activity->set('title', $obj->get('title'));
		$activity->set('description', $obj->get('story_id'));
		$activity->set('pubdate', $obj->get('pub_unixtime'));
		$activity->set('category', $obj->get('sotry_id'));
		$activity->set('author', $obj->get('uid'));
		$activity->set('link', $obj->makeUrl());
		$activity->set('posttime', $obj->get('reg_unixtime'));
		XCube_DelegateUtils::call('Legacy_Activity.AddUserActivity', new XCube_Ref($activity));
		
	}
}


