<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOONIPS_CONTROL_PATH.'control_base.php';

class indexorder extends control_base {

  private $indexBean;
  
  public function init() {
    $dirname = $trustDirname = 'xoonips';
    $this->indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, $trustDirname);
  }
  
  private function weight($index_id, $weight) {
    return $this->indexBean->updateWeight($index_id, $weight);
  }
  
  /**
   *
   * @param object $req POST object.
   */
  public function run($req) {
    $index_id = $req->get('index_id');
    $weight = $req->get('weight');    
    if(!isset($index_id) || !isset($weight)) {
      $this->rest_notify_err(400, 'Parameter index_id or weight not specified.');
    } else if($weight < 0) {
      $this->rest_notify_err(400, 'Weight parameter specify negative integer.');
    }
    if ($this->indexBean->checkWriteRight($index_id, $this->uid)) {
      $rc = $this->weight($index_id, $weight);
      if ($rc == false) {
        $this->rest_notify_err(404, 'Order cannot change.');
      }
    } else {
      $this->rest_notify_err(403, 'Don\'t permit operation.');
    }
  }
}
