<?php

require_once 'BeanFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/Enum.class.php';

abstract class Xoonips_Complement {
	private $id;
	private $name;
	private $viewTypeId;
	private $parameters = array();
	protected $dirname;
	protected $trustDirname;

	abstract protected function complete($field, $id, &$data);

	public function setId($v) {
		$this->id = $v;
	}

	public function getId() {
		return $this->id;
	}

	public function setName($v) {
		$this->name = $v;
	}

	public function getName() {
		return $this->name;
	}

	public function setViewTypeId($v) {
		$this->viewTypeId = $v;
	}

	public function getViewTypeId() {
		return $this->viewTypeId;
	}

	public function setParameters($v) {
		$this->parameters = $v;
	}

	public function getParameters() {
		return $this->parameters;
	}

	public function setDirname($v) {
		$this->dirname = $v;
	}

	public function setTrustDirname($v) {
		$this->trustDirname = $v;
	}

	public function getGroupidByDetailid($detailid) {
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$result = $detailBean->getItemTypeDetailById($detailid);
		if (!$result) return '';
		else return $result['group_id'];
	}
}

