<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

if(!defined('XOONIPS_TRUST_PATH')) {
	$trustDirname = basename(dirname(dirname(__FILE__)));
	define('XOONIPS_TRUST_DIRNAME', $trustDirname);
	define('XOONIPS_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/' . $trustDirname);
}

@include_once XOONIPS_TRUST_PATH . '/class/MultiLanguage.class.php';

/**
 * Xoonips_MultiLanguagePreload
**/
class Xoonips_MultiLanguagePreload extends XCube_ActionFilter {

	private $dirname = 'xoonips';

	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public static function prepare($dirname) {
		$root =& XCube_Root::getSingleton();
		$instance = new Xoonips_MultiLanguagePreload($root->mController);
		$instance->dirname = $dirname;
		$root->mController->addActionFilter($instance);
	}

	/**
	 * preBlockFilter
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public function preBlockFilter() {
	    if (file_exists(XOONIPS_TRUST_PATH . '/class/MultiLanguage.class.php')) {
            $xoonipsMlang = new Xoonips_MultiLanguage($this->dirname);
            $GLOBALS['xoonipsMlang'] =& $xoonipsMlang;
        }
	}
}
?>
