<?php

$xoopsOption['pagetype'] = 'user';
include 'include/common.inc.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

if (!defined('XOONIPS_PATH')) {
	exit();
}

$dirname = Xoonips_Utils::getDirname();
if (!isset($_SERVER['HTTP_REFERER']) || preg_match('/\\/modules\\/' . $dirname . '\\//', $_SERVER['HTTP_REFERER']) == 0) {
	die('Turn REFERER on');
}

$request = new Xoonips_Request();
$item_id = $request->getParameter('item_id');
$itemtype_id = $request->getParameter('itemtype_id');
$base_detail_id = $request->getParameter('base_detail_id');

if ($item_id=='' || $itemtype_id=='' || $base_detail_id=='') {
	die('illegal request');
}

$trustDirname = Xoonips_Utils::getTrustDirname();
$complementLinkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $dirname, $trustDirname);
$result = $complementLinkBean->getItemTypeDetail($itemtype_id, $base_detail_id);

if ($result === false) exit();

$field_detail_id = $result[0]['item_field_detail_id'];
$table_name = $dirname . '_item_extend' . $field_detail_id;

$extendBean = Xoonips_BeanFactory::getBean('ItemExtendBean', $dirname, $trustDirname);
if ($extendBean->getItemExtendInfo($item_id, $table_name)) {
	$extendBean->update($item_id, $table_name);
} else {
	$extendBean->insert($item_id, $table_name, 1);
}
?>
