<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';

class Xoonips_ViewTypeRights extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_rights.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$rightsUseCC = $fieldName . 'cc_radiobox';
		$rightsCCCommercialUse = $fieldName . 'com_radiobox';
		$rightsCCModification = $fieldName . 'mod_radiobox';
		$showTextDiv = $fieldName . 'ShowText';
		$use_cc = '1';
		$cc_commercial_use = '1';
		$cc_modification = '2';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		//$jurisdiction = isset($jurisdictions[0]['title_id ']) ? $jurisdictions[0]['title_id '] : 'Unported';
		$jurisdictions = $this->getList();
		foreach ($jurisdictions as $key => $v) {
			$jurisdiction = $key;
			break;
		}
		$text = '';

		if (strlen($value) >= 5) {
			$rightsValue = explode(',', $value);
			$use_cc = substr($rightsValue[0], 0, 1);
			$cc_commercial_use = substr($rightsValue[0], 1, 1);
			$cc_modification = substr($rightsValue[0], 2, 1);
			$jurisdiction = substr($rightsValue[0], 3);
			$text = (strlen($value) > strlen($rightsValue[0]) + 1) ? substr($value, strlen($rightsValue[0]) + 1) : '';
		} else {
			$value = $use_cc . $cc_commercial_use . $cc_modification . $jurisdiction . ',' . $text;
		}

		$check_cc  = array('', '');
		$check_cc[$use_cc] = 'checked';
		$check_com = array('', '');
		$check_com[$cc_commercial_use] = 'checked';
		$check_mod = array('', '', '');
		$check_mod[$cc_modification]  = 'checked';
		$rightsJurisdic = $fieldName . '_select';
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('rightsUseCC', $rightsUseCC);
		$this->getXoopsTpl()->assign('rightsCCCommercialUse', $rightsCCCommercialUse);
		$this->getXoopsTpl()->assign('rightsCCModification', $rightsCCModification);
		$this->getXoopsTpl()->assign('showTextDiv', $showTextDiv);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('text', $text);
		$this->getXoopsTpl()->assign('check_cc', $check_cc);
		$this->getXoopsTpl()->assign('check_com', $check_com);
		$this->getXoopsTpl()->assign('check_mod', $check_mod);
		$this->getXoopsTpl()->assign('rightsJurisdic', $rightsJurisdic);
		$this->getXoopsTpl()->assign('jurisdictions', $jurisdictions);
		$this->getXoopsTpl()->assign('jurisdic', $jurisdiction);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$use_cc = '1';
		$cc_commercial_use = '1';
		$cc_modification = '2';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		//$jurisdiction = isset($jurisdictions[0]['title_id ']) ? $jurisdictions[0]['title_id '] : 'Unported';
		$jurisdictions = $this->getList();
		foreach ($jurisdictions as $key => $v) {
			$jurisdiction = $key;
			break;
		}
		$text = '';
		if (strlen($value) >= 5) {
			$rightsValue = explode(',', $value);
			$use_cc = substr($rightsValue[0], 0, 1);
			$cc_commercial_use = substr($rightsValue[0], 1, 1);
			$cc_modification = substr($rightsValue[0], 2, 1);
			$jurisdiction = substr($rightsValue[0], 3);
			$text = (strlen($value) > strlen($rightsValue[0]) + 1) ? substr($value, strlen($rightsValue[0]) + 1) : '';
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('text', $text);
		$this->getXoopsTpl()->assign('use_cc', $use_cc);
		$this->getXoopsTpl()->assign('ccLicense', Xoonips_Utils::getCcLicense($cc_commercial_use, $cc_modification, 3.0, $jurisdiction));
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getEditView($field, $value, $groupLoopId) {
		return $this->getInputView($field, $value, $groupLoopId);
	}

	public function getDetailDisplayView($field, $value, $display) {
		$use_cc = '1';
		$cc_commercial_use = '1';
		$cc_modification = '2';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		//$jurisdiction = isset($jurisdictions[0]['title_id ']) ? $jurisdictions[0]['title_id '] : 'Unported';
		$jurisdictions = $this->getList();
		foreach ($jurisdictions as $key => $v) {
			$jurisdiction = $key;
			break;
		}
		$text = '';
		if (strlen($value) >= 5) {
			$rightsValue = explode(',', $value);
			$use_cc = substr($rightsValue[0], 0, 1);
			$cc_commercial_use = substr($rightsValue[0], 1, 1);
			$cc_modification = substr($rightsValue[0], 2, 1);
			$jurisdiction = substr($rightsValue[0], 3);
			$text = (strlen($value) > strlen($rightsValue[0]) + 1) ? substr($value, strlen($rightsValue[0]) + 1) : '';
		}
		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('text', $text);
		$this->getXoopsTpl()->assign('use_cc', $use_cc);
		$this->getXoopsTpl()->assign('ccLicense', Xoonips_Utils::getCcLicense($cc_commercial_use, $cc_modification, 3.0, $jurisdiction));
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getMetaInfo($field, $value) {
		$ret = '';
		$use_cc = '1';
		$cc_commercial_use = '1';
		$cc_modification = '2';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		//$jurisdiction = isset($jurisdictions[0]['title_id ']) ? $jurisdictions[0]['title_id '] : ' ';
		$jurisdictions = $this->getList();
		foreach ($jurisdictions as $key => $v) {
			$jurisdiction = $key;
			break;
		}
		$text = '';
		if (strlen($value) >= 5) {
			$rightsValue = explode(',', $value);
			$use_cc = substr($rightsValue[0], 0, 1);
			$cc_commercial_use = substr($rightsValue[0], 1, 1);
			$cc_modification = substr($rightsValue[0], 2, 1);
			$jurisdiction = substr($rightsValue[0], 3);
			$text = (strlen($value) > strlen($rightsValue[0]) + 1) ? substr($value, strlen($rightsValue[0]) + 1) : '';
		}
		if ($use_cc == '0') {
			$ret = $text;
		} else {
			$ret = Xoonips_Utils::getCcLicense($cc_commercial_use, $cc_modification, 3.0, $jurisdiction);
		}
		return $ret;
	}

	public function getSearchView($field, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * get list block view
	 *
	 * @param $value, $disabled
	 * @return string
	 */
	public function getListBlockView($value, $disabled = '') {
		//$selectValues = $this->getItemtypeValueSet();
		$selectValues = array('');
		$this->getXoopsTpl()->assign('viewType', 'list');
		$this->getXoopsTpl()->assign('selectValues', $selectValues);
		$this->getXoopsTpl()->assign('disabled', $disabled);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * get default value block view
	 *
	 * @param $list, $value, $disabled
	 * @return string
	 */
	public function getDefalutValueBlockView($list, $value, $disabled = '') {
		$fieldName = 'default_value';
		$rightsUseCC = $fieldName . 'cc_radiobox';
		$rightsCCCommercialUse = $fieldName . 'com_radiobox';
		$rightsCCModification = $fieldName . 'mod_radiobox';
		$showTextDiv = $fieldName . 'ShowText';
		$use_cc = '1';
		$cc_commercial_use = '1';
		$cc_modification = '2';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		//$jurisdiction = isset($jurisdictions[0]['title_id ']) ? $jurisdictions[0]['title_id '] : ' ';
		$jurisdictions = $this->getList();
		foreach ($jurisdictions as $key => $v) {
			$jurisdiction = $key;
			break;
		}
		$text = '';

		if (strlen($value) >= 5) {
			$rightsValue = explode(',', $value);
			$use_cc = substr($rightsValue[0], 0, 1);
			$cc_commercial_use = substr($rightsValue[0], 1, 1);
			$cc_modification = substr($rightsValue[0], 2, 1);
			$jurisdiction = substr($rightsValue[0], 3);
			$text = (strlen($value) > strlen($rightsValue[0]) + 1) ? substr($value, strlen($rightsValue[0]) + 1) : '';
		} else {
			$value = $use_cc . $cc_commercial_use . $cc_modification . $jurisdiction . ',' . $text;
		}

		$check_cc  = array('', '');
		$check_cc[$use_cc] = 'checked';
		$check_com = array('', '');
		$check_com[$cc_commercial_use] = 'checked';
		$check_mod = array('', '', '');
		$check_mod[$cc_modification]  = 'checked';
		//$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
		//$jurisdictions = $valueSetBean->getValueDetail('Rights');
		$rightsJurisdic = $fieldName . '_select';
		$this->getXoopsTpl()->assign('viewType', 'default');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('rightsUseCC', $rightsUseCC);
		$this->getXoopsTpl()->assign('rightsCCCommercialUse', $rightsCCCommercialUse);
		$this->getXoopsTpl()->assign('rightsCCModification', $rightsCCModification);
		$this->getXoopsTpl()->assign('showTextDiv', $showTextDiv);
		$this->getXoopsTpl()->assign('disabled', $disabled);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('text', $text);
		$this->getXoopsTpl()->assign('check_cc', $check_cc);
		$this->getXoopsTpl()->assign('check_com', $check_com);
		$this->getXoopsTpl()->assign('check_mod', $check_mod);
		$this->getXoopsTpl()->assign('rightsJurisdic', $rightsJurisdic);
		$this->getXoopsTpl()->assign('jurisdictions', $jurisdictions);
		$this->getXoopsTpl()->assign('jurisdic', $jurisdiction);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * get meta data
	 *
	 * @param object $field
	 * 		   array $data
	 * @return string
	 */
	public function getMetadata($field, &$data) {
		$table = $field->getTableName();
		$column = $field->getColumnName();
		$detail_id = $field->getId();
		if ($table == $this->dirname . '_item_title') {
			foreach ($data[$table] as $data) {
				if ($data['item_field_detail_id'] == $detail_id) {
					return $data[$column];
				}
			}
		}
		return $this->getMetaInfo($field, $data[$table][0][$column]);
	}

	protected function getList() {
		$ret = array();
		$ret['Unported'] = _MI_XOONIPS_INSTALL_RIGHTS_UNPORTED;
		$ret['Argentina'] = _MI_XOONIPS_INSTALL_RIGHTS_ARGENTINA;
		$ret['Australia'] = _MI_XOONIPS_INSTALL_RIGHTS_AUSTRALIA;
		$ret['Austria'] = _MI_XOONIPS_INSTALL_RIGHTS_AUSTRIA;
		$ret['Belgium'] = _MI_XOONIPS_INSTALL_RIGHTS_BELGIUM;
		$ret['Brazil'] = _MI_XOONIPS_INSTALL_RIGHTS_BRAZIL;
		$ret['Bulgaria'] = _MI_XOONIPS_INSTALL_RIGHTS_BULGARIA;
		$ret['Canada'] = _MI_XOONIPS_INSTALL_RIGHTS_CANADA;
		$ret['Chile'] = _MI_XOONIPS_INSTALL_RIGHTS_CHILE;
		$ret['China_Mainland'] = _MI_XOONIPS_INSTALL_RIGHTS_CHINA_MAINLAND;
		$ret['Colombia'] = _MI_XOONIPS_INSTALL_RIGHTS_COLOMBIA;
		$ret['Croatia'] = _MI_XOONIPS_INSTALL_RIGHTS_CROATIA;
		$ret['Denmark'] = _MI_XOONIPS_INSTALL_RIGHTS_DENMARK;
		$ret['Ecuador'] = _MI_XOONIPS_INSTALL_RIGHTS_ECUADOR;
		$ret['Finland'] = _MI_XOONIPS_INSTALL_RIGHTS_FINLAND;
		$ret['France'] = _MI_XOONIPS_INSTALL_RIGHTS_FRANCE;
		$ret['Germany'] = _MI_XOONIPS_INSTALL_RIGHTS_GERMANY;
		$ret['Greece'] = _MI_XOONIPS_INSTALL_RIGHTS_GREECE;
		$ret['Guatemala'] = _MI_XOONIPS_INSTALL_RIGHTS_GUATEMALA;
		$ret['Hong_Kong'] = _MI_XOONIPS_INSTALL_RIGHTS_HONG_KONG;
		$ret['Hungary'] = _MI_XOONIPS_INSTALL_RIGHTS_HUNGARY;
		$ret['India'] = _MI_XOONIPS_INSTALL_RIGHTS_INDIA;
		$ret['Israel'] = _MI_XOONIPS_INSTALL_RIGHTS_ISRAEL;
		$ret['Italy'] = _MI_XOONIPS_INSTALL_RIGHTS_ITALY;
		$ret['Japan'] = _MI_XOONIPS_INSTALL_RIGHTS_JAPAN;
		$ret['Luxembourg'] = _MI_XOONIPS_INSTALL_RIGHTS_LUXEMBOURG;
		$ret['Macedonia'] = _MI_XOONIPS_INSTALL_RIGHTS_MACEDONIA;
		$ret['Malaysia'] = _MI_XOONIPS_INSTALL_RIGHTS_MALAYSIA;
		$ret['Malta'] = _MI_XOONIPS_INSTALL_RIGHTS_MALTA;
		$ret['Mexico'] = _MI_XOONIPS_INSTALL_RIGHTS_MEXICO;
		$ret['Netherlands'] = _MI_XOONIPS_INSTALL_RIGHTS_NETHERLANDS;
		$ret['New_Zealand'] = _MI_XOONIPS_INSTALL_RIGHTS_NEW_ZEALAND;
		$ret['Norway'] = _MI_XOONIPS_INSTALL_RIGHTS_NORWAY;
		$ret['Peru'] = _MI_XOONIPS_INSTALL_RIGHTS_PERU;
		$ret['Philippines'] = _MI_XOONIPS_INSTALL_RIGHTS_PHILIPPINES;
		$ret['Poland'] = _MI_XOONIPS_INSTALL_RIGHTS_POLAND;
		$ret['Portugal'] = _MI_XOONIPS_INSTALL_RIGHTS_PORTUGAL;
		$ret['Puerto_Rico'] = _MI_XOONIPS_INSTALL_RIGHTS_PUERTO_RICO;
		$ret['Romania'] = _MI_XOONIPS_INSTALL_RIGHTS_ROMANIA;
		$ret['Serbia'] = _MI_XOONIPS_INSTALL_RIGHTS_SERBIA;
		$ret['Singapore'] = _MI_XOONIPS_INSTALL_RIGHTS_SINGAPORE;
		$ret['Slovenia'] = _MI_XOONIPS_INSTALL_RIGHTS_SLOVENIA;
		$ret['South_Africa'] = _MI_XOONIPS_INSTALL_RIGHTS_SOUTH_AFRICA;
		$ret['South_Korea'] = _MI_XOONIPS_INSTALL_RIGHTS_SOUTH_KOREA;
		$ret['Spain'] = _MI_XOONIPS_INSTALL_RIGHTS_SPAIN;
		$ret['Sweden'] = _MI_XOONIPS_INSTALL_RIGHTS_SWEDEN;
		$ret['Switzerland'] = _MI_XOONIPS_INSTALL_RIGHTS_SWITZERLAND;
		$ret['Taiwan'] = _MI_XOONIPS_INSTALL_RIGHTS_TAIWAN;
		$ret['UK_England_and_Wales'] = _MI_XOONIPS_INSTALL_RIGHTS_UK_ENGLAND_AND_WALES;
		$ret['UK_Scotland'] = _MI_XOONIPS_INSTALL_RIGHTS_UK_SCOTLAND;
		$ret['United_States'] = _MI_XOONIPS_INSTALL_RIGHTS_UNITED_STATES;
    		
		return $ret;
	}
}
?>
