<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
/**
 * @brief operate xoonips_item_type_search_condition table
 *
 */
class Xoonips_ItemTypeSearchConditionBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemTypeSearchConditionBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_type_search_condition', true);
	}

	/**
	 * select search condition
	 *
	 * @param
	 * @return array
	 */
	public function select($condition_id = null) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table;
		if (!is_null($condition_id)) {
			$sql .= ' WHERE condition_id = ' . $condition_id;
		}
		$sql .= ' ORDER BY condition_id';
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * select search condition
	 *
	 * @param
	 * @return array
	 */
	public function selectByTitle($title) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table . ' WHERE title = ' . Xoonips_Utils::convertSQLStr($title);
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * delete search condition
	 *
	 * @param int $condId condition_id
	 * @return bool true:success,false:failed
	 */
	public function delete($condId) {
		$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=$condId";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * insert search condition
	 *
	 * @param $info
	 * @return bool true:success,false:failed
	 */
	public function insert($info, &$insertId) {
		$sql = 'INSERT INTO ' . $this->table . ' ( title ) '
			. '  VALUE (' . Xoonips_Utils::convertSQLStr($info['title']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 * update
	 *
	 * @param  int $sort_id:sort_id
	 * @param  string $title:title
	 * @return  bool true:success,false:failed
	 */
	public function update($condId, $title) {
		$ret = true;
		$sql = 'UPDATE ' . $this->table . ' SET title=' . Xoonips_Utils::convertSQLStr($title) . ' WHERE condition_id=' . $condId;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
}
?>
