<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Xoonips_AuthType
**/
class Xoonips_AuthType
{
	protected $_mDirname = null;
	const VIEW = "view";
	const POST = "post";
	const REVIEW = "review";
	const MANAGE = "manage";

    /**
     * __construct
     * 
     * @param   string $dirname
     * 
     * @return  void
    **/
    public function __construct($dirname)
    {
    	$this->_mDirname = $dirname;
    }

    /**
     * getAuthType
     * 
     * @param   string $type
     * 
     * @return  string
    **/
    public function getAuthType($type)
    {
		$handler = xoops_gethandler('config');
		$configArr = $handler->getConfigsByDirname($this->_mDirname);
    	$authType = explode('|', $configArr['permit_title']);
    	switch($type){
    		case self::VIEW:
    			return $authType[0];
    			break;
    		case self::POST:
    			return $authType[1];
    			break;
    		case self::REVIEW:
    			return $authType[2];
    			break;
    		case self::MANAGE:
    			return $authType[3];
    			break;
    	}
    }

}

?>
