<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('XLEPROGRESS_ITEM_SORT_KEY_ITEM_ID', 1);
define('XLEPROGRESS_ITEM_SORT_KEY_DIRNAME', 2);
define('XLEPROGRESS_ITEM_SORT_KEY_DATANAME', 3);
define('XLEPROGRESS_ITEM_SORT_KEY_TARGET_ID', 4);
define('XLEPROGRESS_ITEM_SORT_KEY_UID', 5);
define('XLEPROGRESS_ITEM_SORT_KEY_STEP', 6);
define('XLEPROGRESS_ITEM_SORT_KEY_STATUS', 7);
define('XLEPROGRESS_ITEM_SORT_KEY_POSTTIME', 8);
define('XLEPROGRESS_ITEM_SORT_KEY_DELETETIME', 9);
define('XLEPROGRESS_ITEM_SORT_KEY_DEFAULT', XLEPROGRESS_ITEM_SORT_KEY_ITEM_ID);

/**
 * Xleprogress_ItemFilterForm
**/
class Xleprogress_MytaskFilterForm extends Xleprogress_AbstractFilterForm
{
    public /*** string[] ***/ $mSortKeys = array(
        XLEPROGRESS_ITEM_SORT_KEY_ITEM_ID => 'item_id',
        XLEPROGRESS_ITEM_SORT_KEY_DIRNAME => 'dirname',
        XLEPROGRESS_ITEM_SORT_KEY_DATANAME => 'dataname',
        XLEPROGRESS_ITEM_SORT_KEY_TARGET_ID => 'target_id',
        XLEPROGRESS_ITEM_SORT_KEY_UID => 'uid',
        XLEPROGRESS_ITEM_SORT_KEY_STEP => 'step',
        XLEPROGRESS_ITEM_SORT_KEY_STATUS => 'status',
        XLEPROGRESS_ITEM_SORT_KEY_POSTTIME => 'posttime',
        XLEPROGRESS_ITEM_SORT_KEY_DELETETIME => 'deletetime'
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return array(XLEPROGRESS_ITEM_SORT_KEY_POSTTIME);
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
    
        $root =& XCube_Root::getSingleton();
    
        if (($value = $root->mContext->mRequest->getRequest('item_id')) !== null) {
            $this->mNavi->addExtra('item_id', $value);
            $this->_mCriteria->add(new Criteria('b.item_id', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('dirname')) !== null) {
            $this->mNavi->addExtra('dirname', $value);
            $this->_mCriteria->add(new Criteria('a.dirname', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('dataname')) !== null) {
            $this->mNavi->addExtra('dataname', $value);
            $this->_mCriteria->add(new Criteria('a.dataname', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('target_id')) !== null) {
            $this->mNavi->addExtra('target_id', $value);
            $this->_mCriteria->add(new Criteria('b.target_id', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('uid')) !== null) {
            $this->mNavi->addExtra('uid', $value);
            $this->_mCriteria->add(new Criteria('b.uid', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('step')) !== null) {
            $this->mNavi->addExtra('step', $value);
            $this->_mCriteria->add(new Criteria('b.step', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('status')) !== null) {
            $this->mNavi->addExtra('status', $value);
            $this->_mCriteria->add(new Criteria('b.status', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('posttime')) !== null) {
            $this->mNavi->addExtra('posttime', $value);
            $this->_mCriteria->add(new Criteria('b.posttime', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('deletetime')) !== null) {
            $this->mNavi->addExtra('deletetime', $value);
            $this->_mCriteria->add(new Criteria('b.deletetime', $value));
        }
    
        foreach(array_keys($this->mSort) as $k) {
            $this->_mCriteria->addSort($this->getSort($k), $this->getOrder($k));
        }
    }

    public function setCnt($cnt){
    	$this->cnt = $cnt;
    }

    /**
     * getTotalItems
     * 
     * @param   int  &$total
     * 
     * @return  void
    **/
    public function getTotalItems(/*** int ***/ &$total)
    {
        $total = $this->cnt;
    }
}
?>
