<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Xleprogress_TypeObject
**/
class Xleprogress_TypeObject extends XoopsSimpleObject
{
	public $mDirname = null;

	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('type_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('dirname', XOBJ_DTYPE_STRING, '', false, 45);
		$this->initVar('dataname', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('module', XOBJ_DTYPE_STRING, '', false, 255);
	}
	
	/**
	 * _getDirname
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getDirname()
	{
		return $this->mDirname;
	}
}

/**
 * Xleprogress_TypeHandler
**/
class Xleprogress_TypeHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = '{dirname}_type';

	public /*** string ***/ $mPrimary = 'type_id';

	public /*** string ***/ $mClass = 'Xleprogress_TypeObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

	/**
	 * getTypeList
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * 
	 * @return	Xleprogress_TypeObject[]
	**/
	public function getTypeList()
	{
		$cri = new CriteriaCompo();
		$cri->setSort('dirname', 'ASC');
		return $this->getObjects($cri);
	}

}

?>

