<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/Enum.class.php';

/**
 * Xleprogress_ApprovalObject
**/
class Xleprogress_ApprovalObject extends XoopsSimpleObject
{
	public $mDirname = null;
	public $mType = null;
	public $mGroup = null;
	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('approval_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('uid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('groupid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('type_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('step', XOBJ_DTYPE_INT, 10, false);
	}
	
	/**
	 * loadType
	 * 
	 * @param	string	$order
	 * 
	 * @return	void
	**/
	public function loadType()
	{
		if($this->mType == null){
			$this->mType = Legacy_Utils::getModuleHandler('type', $this->getDirname())->get($this->get('type_id'));
		}
	}
	
	/**
	 * loadGroup
	 * 
	 * @param	string	$order
	 * 
	 * @return	void
	**/
	public function loadGroup()
	{
		if($this->mGroup == null){
			$this->mGroup = Legacy_Utils::getModuleHandler('group', $this->getDirname())->get($this->get('groupid'));
		}
	}
	/**
	 * getMyItem
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_ItemObject[]
	**/
	public function getMyItem()
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('status', Lenum_WorkflowStatus::PROGRESS));
		$cri->add(new Criteria('uid', $this->get('uid')));
		$cri->add(new Criteria('deletetime', 0));
		return Legacy_Utils::getModuleHandler('item', $this->getDirname())->getObjects($cri);
	}

	/**
	 * countMyItem
	 * 
	 * @param	void
	 * 
	 * @return	int
	**/
	public function countMyItem()
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('status', Lenum_WorkflowStatus::PROGRESS));
		$cri->add(new Criteria('uid', $this->get('uid')));
		$cri->add(new Criteria('deletetime', 0));
		return Legacy_Utils::getModuleHandler('item', $this->getDirname())->getCount($cri);
	}

	/**
	 * _getDirname
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getDirname()
	{
		return $this->mDirname;
	}
}

/**
 * Xleprogress_ApprovalHandler
**/
class Xleprogress_ApprovalHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = '{dirname}_approval';

	public /*** string ***/ $mPrimary = 'approval_id';

	public /*** string ***/ $mClass = 'Xleprogress_ApprovalObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable, array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

	/**
	 * getNextApproval
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * @param	int 	$step
	 * 
	 * @return	Xleprogress_ApprovalObject
	**/
	public function getNextApproval($type_id, $step)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$cri->add(new Criteria('step', $step, '>'));
		$cri->setSort('step', 'ASC');
		$objs = $this->getObjects($cri);
		return (count($objs)>0) ? array_shift($objs) : NULL;
	}

	/**
	 * getPreviousApproval
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * @param	int 	$step
	 * 
	 * @return	Xleprogress_ApprovalObject
	**/
	public function getPreviousApproval($type_id, $step)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$cri->add(new Criteria('step', $step, '<'));
		$cri->setSort('step', 'DESC');
		$objs = $this->getObjects($cri);
		return (count($objs)>0) ? array_shift($objs) : NULL;
	}

	/**
	 * getApprovalList
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * 
	 * @return	Xleprogress_ApprovalObject[]
	**/
	public function getApprovalList($type_id, $target)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$cri->setSort('step', 'ASC');
		return $this->getObjects($cri);
	}

	/**
	 * checkAuthen
	 * 
	 * @param	int	$uid
	 * 
	 * @return	bool
	**/
	public function checkAuthen($uid) {
		global $xoopsDB;
		$adminGroups = array();
        $result = $this->getApprovalResult($uid, $adminGroups);
        if ($result && $xoopsDB->fetchArray($result)) {
	       return true;
        } else {
        	return false;
        }
	}

	public function getApprovalResult($uid, &$adminGroups, $type_id = null, $targetGroup = null) {
		global $xoopsDB;
        $approvalTable = $this->mTable;
       	$linkTable = $xoopsDB->prefix('groups_users_link');
    	$groupTable = $xoopsDB->prefix('groups');
    	
        $sql = "SELECT a.groupid FROM $linkTable a,$groupTable b WHERE a.groupid=b.groupid"
        	. " AND (a.activate=" . Xoonips_Enum::GRP_US_CERTIFIED
        	. " OR a.activate=" . Xoonips_Enum::GRP_US_LEAVE_REQUIRED . ")"
	        . " AND a.is_admin=" . Xoonips_Enum::GRP_ADMINISTRATOR
	        . " AND a.uid=$uid AND b.activate<>" . Xoonips_Enum::GRP_NOT_CERTIFIED;
        $result = $xoopsDB->queryF($sql);
        if($result!= false){
        	while($row = $xoopsDB->fetchArray($result)){
        		$adminGroups[] = $row['groupid'];
        	}
        }
        
        $sql = "SELECT DISTINCT a.type_id,a.step,a.groupid FROM $approvalTable a WHERE";
	    if (!is_null($type_id)) {
        	$sql .= " a.type_id=$type_id AND"; 
        }
        $sql .= " ((a.groupid IS NULL AND a.uid=$uid) "
        	. " OR (a.groupid IS NOT NULL AND a.groupid<>" . Xoonips_Enum::XLEPROGRESS_GROUP
        	. " AND EXISTS(SELECT b.uid FROM $linkTable b WHERE b.groupid=a.groupid" 
	        . " AND b.uid=$uid AND (b.activate=" . Xoonips_Enum::GRP_US_CERTIFIED
        	. ' OR b.activate=' . Xoonips_Enum::GRP_US_LEAVE_REQUIRED . ')))';
        if (count($adminGroups) > 0 && (Is_null($targetGroup) || in_array($targetGroup, $adminGroups))) {
        	$sql .= ' OR a.groupid=' . Xoonips_Enum::XLEPROGRESS_GROUP;
        }
        $sql .= ')';
		if (!is_null($type_id)) {
        	$sql .= ' ORDER BY a.step'; 
        }
        return $xoopsDB->queryF($sql);
	}
}
?>
