<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/actions/ItemListAction.class.php';

/**
 * Xleprogress_ItemListAction
**/
class Xleprogress_MytaskListAction extends Xleprogress_ItemListAction
{
    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Xleprogress_ItemFilterForm
    **/
    protected function &_getFilterForm()
    {
        $filter =& $this->mAsset->getObject('filter', 'Mytask', false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }
    

    /**
     * getDefaultView
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getDefaultView()
    {
    	global $xoopsDB;
    	$uid = Legacy_Utils::getUid();
    	
        $this->mFilter =& $this->_getFilterForm();
        $this->mFilter->fetch();
    	
        $itemObjs = array();
        $handler = $this->_getHandler();
               
        $this->mObjects = $handler->getMyTaskList($uid);
        $this->getSortFilterObject();

        return XLEPROGRESS_FRAME_VIEW_INDEX;
    }

    private function getSortFilterObject()
    {
    	$objects = array();
		$sortArray = array();
		$this->mFilter->setCnt(count($this->mObjects));
		// if sort
		if($this->mFilter->mSort[0] == 0){
			$this->mFilter->mSort[0] = 1;
		}
		foreach($this->mObjects as $obj){
			if(abs($this->mFilter->mSort[0])==XLEPROGRESS_ITEM_SORT_KEY_DIRNAME){
				$sortArray[] = array(0=>$obj->mType->get('dirname'),1=>$obj);
			}
			else if(abs($this->mFilter->mSort[0])==XLEPROGRESS_ITEM_SORT_KEY_DATANAME){
				$sortArray[] = array(0=>$obj->mType->get('dataname'),1=>$obj);
			}
			else if(isset($this->mFilter->mSort[0])){
				$sort = $this->mFilter->getSort(0);
				$sortArray[] = array(0=>$obj->get($sort),1=>$obj);
			}
		}
		if(count($sortArray)>0){
			$sortkeys = array();
			foreach($sortArray as $key=>$value){
				$sortkeys[$key] = $value[0];
			}
			if($this->mFilter->mSort[0]>0){
				array_multisort($sortkeys, SORT_ASC, $sortArray);
			}
			else{
				array_multisort($sortkeys, SORT_DESC, $sortArray);
			}
			$this->mObjects = array();
			foreach($sortArray as $key=>$row){
				$this->mObjects[] = $row[1];
			}				
		}		
		$start = $this->mFilter->mNavi->getStart();
		$limit = $this->mFilter->mNavi->getPerpage();
		foreach($this->mObjects as $key=>$obj){
			if($key < $start || $key >= ($start + $limit) ){
				unset($this->mObjects[$key]);
			}
		}
    }

    /**
	 * _getBaseUrl
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	protected function _getBaseUrl()
	{
		return './index.php?action=MytaskList';
	}
}
?>
