<?php

require_once 'User.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class User_ViewTypeRank extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_rank.html';
	}

	public function getSearchInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$rankHandler =& xoops_getmodulehandler('ranks', $this->dirname);
		$ranks =& $rankHandler->getObjects(new Criteria('rank_special', 1));
		$list = array();
	    foreach ($ranks as $rankList) {
    		$list[] = array('id' => $rankList->get('rank_id'), 'title' => $rankList->get('rank_title'));
    	}
		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('list', $list);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$rankHandler =& xoops_getmodulehandler('ranks', $this->dirname);
		$ranks =& $rankHandler->getObjects(new Criteria('rank_special', 1));
		$list = array();
	    foreach ($ranks as $rankList) {
    		$list[] = array('id' => $rankList->get('rank_id'), 'title' => $rankList->get('rank_title'));
    	}
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('list', $list);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDisplayView($field, $value, $groupLoopId) {
   		$fieldName = $this->getFieldName($field, $groupLoopId);
		$rankHandler =& xoops_getmodulehandler('ranks', $this->dirname);
		$ranks =& $rankHandler->getObjects(new Criteria('rank_special', 1));
		$list = array();
	    foreach ($ranks as $rankList) {
    		$list[] = array('id' => $rankList->get('rank_id'), 'title' => $rankList->get('rank_title'));
    	}
		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('list', $list);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$user = User_User::getInstance();
		$uid = $user->getId();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$row = $userBean->getUserBasicInfo($uid);
		$posts = $row['posts'];
		$rankHandler =& xoops_getmodulehandler('ranks', $this->dirname);
		$list = array();
		if ($value == 0) {
			$rankTitles = $rankHandler->getObjects(new Criteria('rank_special', 0));
			foreach ($rankTitles as $rankList) {
				$list[] = array('title' => $rankList->get('rank_title'),
								'min' => $rankList->get('rank_min'),
								'max' => $rankList->get('rank_max'),
								'url' => XOOPS_UPLOAD_URL . '/' . $rankList->get('rank_image'));
			}
		} else if ($value != '') {
			$ranks =& $rankHandler->getObjects(new Criteria('rank_special', 1));
		    foreach ($ranks as $rankList) {
	    		$list[] = array('id' => $rankList->get('rank_id'),
	    				  'title' => $rankList->get('rank_title'),
				    		'url' => XOOPS_UPLOAD_URL . '/' . $rankList->get('rank_image'));
	    	}
		}
		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('list', $list);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('posts', $posts);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function isDisplay($op) {
		if ($op == Xoonips_Enum::OP_TYPE_REGISTRY || $op == Xoonips_Enum::OP_TYPE_EDIT) {
			return false;
		}
		return true;
	}
}
?>
