<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . '/class/AbstractListAction.class.php';
require_once USER_TRUST_PATH . '/admin/forms/UserValueSetFilterForm.class.php';

class User_UserValueSetListAction extends User_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('user_field_value_set');
		return $handler;
	}

	function &_getFilterForm()
	{
		$filter = new User_UserValueSetFilterForm($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./index.php?action=UserValueSetList";
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$objects = $this->mObjects;
		foreach($objects as $object){
			$object->mVars['name'] = $object->mVars['select_name'];
			$object->mVars['name']['value'] = urlencode($object->mVars['name']['value']);
		}
		$render->setTemplateName($this->dirname . '_value_set_list.html');
		$render->setAttribute('objects', $objects);
		$render->setAttribute('pageNavi', $this->mFilter->mNavi);
		$render->setAttribute('dirname', $this->dirname);
	}
}

?>
