<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

define ('USER_USERINFO_MAXHIT', 5);

/***
 * @internal
 * This action shows a information of the target user which is specified by
 * $uid. And display posts of the user with the global search service.
 * 
 * [Warning]
 * Now, the global search service can't work because the design of XCube is
 * changed.
 * 
 * @todo The global search service can't work.
 */
require_once dirname(dirname(__FILE__)) . '/class/core/User.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';

class User_UserInfoAction extends User_Action
{
	var $mObject = null;
	var $mRankObject = null;
	var $mSearchResults = null;
	
	var $mSelfDelete = false;
	
	var $mPmliteURL = null;	

	/**
	 * _getPageTitle
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	protected function _getPagetitle()
	{
		return Legacy_Utils::getUserName(Legacy_Utils::getUid());
	}

	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		$this->mSelfDelete = $moduleConfig['self_delete'];
	}
	
	function isSecure()
	{
		return false;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{		
		$uid = isset($_GET['uid']) ? intval(xoops_getrequest('uid')) : 0;
		$user = User_User::getInstance();
		$user->setId($uid);
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$xoopsUserId = 0;
		// userself
		$isUserSelf = false;
		if (isset($_SESSION['xoopsUserId'])) {
			$xoopsUserId = $_SESSION['xoopsUserId'];
			$isUserSelf = ($uid == $xoopsUserId);
		}
		// userType (0:guest 1:user 2:groupManager 3:moderator)
		$userType = $userBean->getUserType($xoopsUserId);
		$isModerator = $userBean->isModerator($xoopsUserId);
		
		
		// set display button 
		$isEditButton = false;
		$isEventNoticeButton = false;
		if ($userType != Xoonips_Enum::USER_TYPE_GUEST && $isUserSelf) {
			$isEditButton = true;
			$isEventNoticeButton = true;
		}
		$isDeleteButton = false;
		if ($userType == Xoonips_Enum::USER_TYPE_USER && $isUserSelf
				&& $this->mSelfDelete && !$isModerator && $xoopsUserId != 1) {
			$isDeleteButton = true;
		}
		$isMsgMailButton = false;
		if ($userType != Xoonips_Enum::USER_TYPE_GUEST && !$isUserSelf) {
			$isMsgMailButton = true;
		}		
		$breadcrumbs = array(
			array(
				'name' => _MD_USER_LANG_USERSEARCH,
				'url' => XOOPS_URL . '/modules/user/index.php?action=userSearch'
			),
			array(
				'name' => _MD_USER_LANG_USERLIST
			),
			array(
				'name' => _MD_USER_LANG_USERINFO
			)
		);		
		$this->viewData = array();
		$this->viewData['uid'] = $uid;
		$this->viewData['userInfoView'] = $user->getDetailView($uid,$xoopsUserId);
		$this->viewData['isEditButton'] = $isEditButton;
		$this->viewData['isEventNoticeButton'] = $isEventNoticeButton;
		$this->viewData['isDeleteButton'] = $isDeleteButton;
		$this->viewData['isMsgMailButton'] = $isMsgMailButton;
		//$this->viewData['cvitaes'] = $userBean->getCvitaesInfo($uid);
		$this->viewData['xoops_breadcrumbs'] = $breadcrumbs;
		$this->viewData['url'] = XOOPS_URL;	
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	/***
	 * [Notice]
	 * Because XCube_Service class group are changed now, this member function
	 * can't get the result of user posts.
	 */
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_userinfo.html");
		$this->setAttributes($render);		
	}
	
	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward(XOOPS_URL . '/user.php');
	}
}

?>
