<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractEditAction.class.php";
require_once USER_TRUST_PATH . "/class/core/Notification.class.php";
//require_once USER_TRUST_PATH . "/class/RegistMailBuilder.class.php";
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class User_UserActivateAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval(xoops_getrequest('uid')) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users', $this->dirname);
		return $handler;
	}
	
	/**
	 *  Return false.
	 *  If a user requests dummy uid, kick out him!
	 */
	function isEnableCreate()
	{
		return false;
	}

	/**
	 *  Return false.
	 *  This action would be used by a guest user.
	 */
	function isSecure()
	{
		return false;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{		
		//set ticket				
		$this->viewData['op'] = $_REQUEST['op'];
		$this->viewData['id'] = $_REQUEST['id'];
		$this->viewData['actkey'] = $_REQUEST['actkey'];		
		return USER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller, &$xoopsUser)
	{		
		global $xoopsDB;	
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$result = array();
		/*XCube_DelegateUtils::call('Module.User.GetMessageSign', new XCube_Ref($result));
		foreach ($result as $messageSign) {
			$myxoopsConfig2 = $messageSign;
		}*/
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		$uid = $_REQUEST['id'];
		$user = $userBean->getUserBasicInfo($uid);
		if ((!isset($_REQUEST['actkey'])) || (!$user)) {
			$controller->executeForward(XOOPS_URL . '/');
		}

		if ($user['actkey'] != xoops_getrequest('actkey')) {
			$controller->executeRedirect(XOOPS_URL . '/', 3, _MD_USER_MESSAGE_ACTKEYNOT);
		} 

		if ($user['activate'] == 1 || $user['level'] == 1) {
			$controller->executeRedirect(XOOPS_URL . '/user.php', 3, _MD_USER_MESSAGE_ACTIVATED_NOT_APPROVE);
		}

		if ($user['activate'] > 1 || $user['level'] > 1) {
			$controller->executeRedirect(XOOPS_URL . '/user.php', 3, _MD_USER_MESSAGE_ACONTACT);
		}
		$certify_user = $myxoopsConfigUser['certify_user'];
        $user_certify_date = $myxoopsConfigUser['user_certify_date'];
		if ($user_certify_date > 0) {
			 $time = (time() - $user['user_regdate']) / (24 * 60 * 60);
			 if ($time > $user_certify_date) {
			 	if (!$userBean->deleteUsers($uid)){
			 		 $controller->executeRedirect(XOOPS_URL.'/', 3, 'DB error!');
			 	}
			 	if (!$groupUserLinkBean->deleteByUid($uid)) {
			 		 redirect_header(XOOPS_URL.'/', 3, 'DB error!');
			 	}
			 	$controller->executeRedirect(XOOPS_URL . '/', 3, _MD_USER_MESSAGE_ACTIVATE_TIMEOUT);
			}
		}		
		if (!$userBean->activateUser($user)) {
               	$controller->executeRedirect(XOOPS_URL . '/', 3, 'Activation failed!');
       	}
       	$notification = new User_Notification($xoopsDB, $this->dirname, $this->trustDirname);
       	// certification request
       	$certifyUsers = Xoonips_Enum::certifyUsers();
       	if ($certify_user == 'on') { 
			$certifyName = ($user['name'] == '') ? $user['uname'] : $user['uname'] . '(' . $user['name'] . ')';
		    $result = array();
			XCube_DelegateUtils::call('Legacy_Workflow.AddItem', new XCube_Ref($result), $certifyName, $certifyUsers, $uid);
		    if ($result[0] == false) {
		    	$userBean->inactivateUser($user);
				$controller->executeRedirect(XOOPS_URL . '/', 3, $result[1]);
			}                    
			XCube_DelegateUtils::call('Module.User.Event.User.CertifyRequest', new XoopsUser($uid));
			$sendToUsers = array();
			XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', $certifyUsers, $uid, new XCube_Ref($sendToUsers));
	        $notification->accountCertifyRequest($uid, $sendToUsers);
	        if ($myxoopsConfigUser['activation_type'] == 2) {//activate by xoops admin & certify manual
	        	echo _MD_USER_MESSAGE_ACTIVATED_ADMIN_CERTIFY;
	        } elseif ($myxoopsConfigUser['activation_type'] == 0) {//activate by xoops by user & certify manual
	        	echo _MD_USER_MESSAGE_ACTIVATED_USER_CERTIFY;
	        }
       	}
       	// certification automatically 
       	else{    	
			if (!$userBean->certifiyUser($user)) {
	        	$controller->executeRedirect(XOOPS_URL . '/', 3, 'Activation failed!');
		    }
		    XCube_DelegateUtils::call('Module.User.Event.User.Certify', new XoopsUser($uid));
			$sendToUsers = array();
			XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', $certifyUsers, new XCube_Ref($sendToUsers));
		    $notification->accountCertifiedAuto($uid, $sendToUsers);
		    $myxoopsConfig2 = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF);	    
		    if($myxoopsConfigUser['activation_type'] == 2) { //activate xoops account by xoops administrator
			    // send e-mail to the registered address
			    // notify a completion of certification to the certified user by e-mail
			    $xoopsMailer =& getMailer();
			    $xoopsMailer->useMail();
			    $xoopsMailer->setTemplateDir(Xoonips_Utils::mailTemplateDir($this->dirname, $this->trustdirname));
			    $xoopsMailer->setTemplate('user_account_certified_notify_for_user.tpl');
			    $xoopsMailer->assign('SITENAME', $myxoopsConfig2['sitename']);
			    $xoopsMailer->assign('ADMINMAIL', $myxoopsConfig2['adminmail']);
			    $xoopsMailer->assign('SITEURL', XOOPS_URL . '/');
			    $xoopsMailer->assign('USER_UNAME', $user['uname']);
				$xoopsMailer->assign('USER_DIVISION', $user['division']);
				$xoopsMailer->assign('USER_NAME', $user['name']);
				$xoopsMailer->assign('USER_EMAIL', $user['email']);
				$xoopsMailer->assign('USER_COMPANY_NAME', $user['company_name']);
				$xoopsMailer->assign('USER_ADDRESS', $user['user_from']);
				$xoopsMailer->assign('USER_COUNTRY', $user['country']); 
				$xoopsMailer->assign('USER_DETAIL_URL', XOOPS_URL . '/userinfo.php?uid=' . $uid);
				$certifyUser = '';
				$xoopsMailer->assign('CERTIFY_USER', $certifyUser);
				$xoopsMailer->setToUsers(new XoopsUser($uid) );
				$xoopsMailer->setFromEmail($myxoopsConfig2['adminmail']);
				$xoopsMailer->setFromName($myxoopsConfig2['sitename']);
				$xoopsMailer->setSubject(_MD_USER_MESSAGE_ACCOUNT_CERTIFIED_AUTO_NOTIFYSBJ);
				if ($xoopsMailer->send()) {
					echo _MD_USER_MESSAGE_CERTIFY_MAILOK;
				} else {
					echo _MD_USER_MESSAGE_CERTIFY_MAILNG;
				}
			} else {
				$controller->executeRedirect(XOOPS_URL .'/user.php', 5, _MD_USER_MESSAGE_ACTLOGIN, false);
			}
	    }
	}
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName($this->dirname . '_activate.html');
		$this->setAttributes($render);
	}
}
?>
