<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';
require_once XOOPS_ROOT_PATH . '/class/xoopsuser.php';

/**
 * @brief operate users table
 *
 */
class User_UsersBean_NG extends Xoonips_BeanBase {
	private static $userCache = array();
	private $linkTable = null;

	/**
	 * Constructor
	 **/
	public function User_UsersBean_NG($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('users');
		$this->linkTable = $this->prefix('groups_users_link');
	}

	/**
	 * getUserBasicInfo
	 *
	 * @param int $id
	 * @return array $user
	 */
	public function getUserBasicInfo($id, $includeExtend = true) {
		$user = array();
		$sql = 'SELECT * FROM ' . $this->table . ' WHERE uid=' . $id;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$user = $this->fetchArray($result);
		if (!$user) {
			return false;
		}
		$this->freeRecordSet($result);

		$user['index_number_limit'] = 0;
		$user['item_number_limit']  = 0;
		$user['item_storage_limit'] = 0;

		return $user;
	}

	/**
	 *
	 * addPost
	 *
	 * @param  int $uid
	 * @return bool
	*/
	public function addPost($uid) {
		$sql = 'UPDATE ' . $this->table
		. " set posts = posts + 1"
		. " WHERE uid = $uid";

		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 *
	 * isModerator
	 *
	 * @param  int $uid
	 * @return bool
	*/
	public function isModerator($uid) {
		return true;
	}

	/**
	 *
	 * getAllUsers
	 *
	 * @param  int $uid
	 * @return bool
	*/
	public function getAllUsers() {
		$ret = array();
		$sql = "SELECT * FROM $this->table";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
			$this->userCache[$row['uid']] = $row;
		}
		$this->freeRecordSet($result);

		return $ret;
	}

	/**
	 *
	 * pickupUser
	 *
	 * @param  array $user
	 * @return bool
	*/
	public function pickupUser($user) {
		return true;
	}

	/**
	 *
	 * isCertified
	 *
	 * @param  int $uid
	 * @return bool
	*/
	public function isCertified($uid) {
		return true;
    }

	/**
	 *
	 * getUserExtend
	 *
	 * @param  string $tableName
	 * @param  int $uid
	 * @return array $ret
	*/
	public function getUserExtend($tableName, $uid) {
		$ret = array();
		$table = $this->prefix($tableName);
		$sql = "select * from $table where uid=$uid order by occurrence_number";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);

		return $ret;
	}

	/**
	 *
	 * getUserBasicInfoByName
	 *
	 * @param  string $uname
	 * @param  string $name
	 * @return array $ret
	*/
	public function getUserBasicInfoByName($uname, $name) {
		$ret = array();
		$uname = Xoonips_Utils::convertSQLStrLike($uname);
		$name = Xoonips_Utils::convertSQLStrLike($name);
		$sql = 'SELECT * FROM ' . $this->table . " WHERE uname LIKE '%$uname%' and name LIKE '%$name%' order by uname";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}

		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
			$this->userCache[$row['uid']] = $row;
		}
		$this->freeRecordSet($result);

		return $ret;
	}




}
?>
