<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';

/**
 * @brief operate groups table
 *
 */
class User_GroupsBean_NG extends Xoonips_BeanBase {
	private $linkTable = null;

	/**
	 * Constructor
	 **/
	public function User_GroupsBean_NG($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('groups');
		$this->linkTable = $this->prefix('groups_users_link');
	}

	/**
	 * get group
	 *
	 * @param int $groupId:groupid
	 * @return array
	 */
	public function getGroup($groupId) {
		$group = array();
		$sql = "SELECT * FROM $this->table";
		$sql = $sql . " WHERE groupid=$groupId";

		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$group = $row;
		}
		$this->freeRecordSet($result);

		$group[item_accept] = 0;
		$group[item_number_limit] = 0;
		$group[item_storage_limit] = 0;

		return $group;
	}

	/**
	 * groupsCertify
	 *
	 * @param int $groupId
	 * @return bool
	 */
	public function groupsCertify($groupid) {
		return true;
	}

	/**
	 * getGroups
	 *
	 * @param int $groupType
	 * @param string $operation
	 * @return array $ret
	 */
	public function getGroups($groupType, $operation = '=') {
		$ret = array();
		$sql = "SELECT * FROM $this->table WHERE group_type" . $operation . Xoonips_Utils::convertSQLStr($groupType) . " order by name";

		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}


	/**
	 * getAdminGroupIds
	 *
	 * @param int $uid
	 * @return array $ret
	 */
	public function getAdminGroupIds($uid) {
		$ret = array();
		$sql = "SELECT a.groupid FROM $this->linkTable a,$this->table b";
		$sql = $sql . " WHERE a.groupid=b.groupid AND a.uid=$uid AND a.is_admin=" . Xoonips_Enum::GRP_ADMINISTRATOR;
		$sql = $sql . ' AND b.activate<>' . Xoonips_Enum::GRP_NOT_CERTIFIED . ' AND a.activate<>' . Xoonips_Enum::GRP_US_JOIN_REQUIRED;

		$result = $this->execute($sql);
		if (!$result) {
			return false;

		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row['groupid'];

		}
		$this->freeRecordSet($result);

		return $ret;
	}



}
?>
