<?php

require_once dirname( dirname( __FILE__ ) ) . '/class/core/Item.class.php';

function xoonips_search($keywords, $andor, $limit, $offset, $userid) {
	global $xoopsDB;
	$dirname = 'xoonips';
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname($dirname);
	if (!is_object($module)) {
		exit('Access Denied');
	}
	$trustDirname = $module->getVar('trust_dirname');

	$ret = array();
	$myts =& MyTextsanitizer::getInstance();	
	$keyword = '';
	if (is_array($keywords)) {
		$pos = 0;
		foreach ($keywords as $val) {
			if ($pos == 0) {
				$keyword .= $val;
			} else {
				$keyword .= ' ' . $andor . ' ' . $val;
			}
			$pos = $pos + 1;
		}
	}
	
	if (trim($keyword) == '') {
		return $ret;
	}

	$isExact = false;
	if ($andor == 'exact') {
		$isExact = true;
	}
	$itemtypeDetailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $dirname, $trustDirname);
	$conDetailBean = Xoonips_BeanFactory::getBean('ItemTypeSearchConditionDetailBean', $dirname, $trustDirname);
	$conDetails = $conDetailBean->select(1);
	if (count($conDetails) == 0) {
		return $ret;	
	}
	
	$post_data = array();
	foreach ($conDetails as $conDetail) {
		$detailId = $conDetail['item_field_detail_id'];
		$itemtypeDetail = $itemtypeDetailBean->getItemTypeDetailById($detailId);
		if (!$itemtypeDetail) continue;
		$groupId = $itemtypeDetail['group_id'];
		$itemtypeId = $itemtypeDetail['item_type_id'];
		$post_data[$itemtypeId][$groupId . Xoonips_Enum::ITEM_ID_SEPARATOR . $itemtypeId . Xoonips_Enum::ITEM_ID_SEPARATOR . $detailId] = $keyword;
	}
	$searchSqlArr = array();
	foreach ($post_data as $key => $data) {
		$itemtype = new Xoonips_Item($key, $dirname, $trustDirname);
		$itemtype->setDataFromPost($data);
		$searchSqlArr[] = $itemtype->doSearch(Xoonips_Enum::OP_TYPE_QUICKSEARCH, $isExact);
	}
	$searchSqlStr = implode(' UNION ALL ', $searchSqlArr);
	$sql = "SELECT DISTINCT item_id FROM ( $searchSqlStr ) AS temp ORDER BY item_id";	
	$result = $xoopsDB->queryF($sql, $limit, $offset);
	if (!$result) {
		return $ret;
	}
	$itemTypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $dirname, $trustDirname);
	$itemBasicBean = Xoonips_BeanFactory::getBean('ItemBean', $dirname, $trustDirname);
	$itemTitleBean = Xoonips_BeanFactory::getBean('ItemTitleBean', $dirname, $trustDirname);
	$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $dirname, $trustDirname);
	while ($row = $xoopsDB->fetchArray($result)) {
		$data = array();
		$item_id = $row['item_id'];
		$basicInfo = $itemBasicBean->getItemBasicInfo($item_id);
		$typeInfo = $itemTypeBean->getItemType($basicInfo['item_type_id']);
		$data['image'] = 'images/' . $typeInfo['icon'];		
		$data['link'] = "detail.php?item_id=$item_id";		
		$titleInfo = $itemTitleBean->getItemTitleInfo($item_id);
		$data['title'] = $myts->htmlSpecialChars($titleInfo[0]['title']);
		$data['time'] = $basicInfo['creation_date'];		
		$userInfo = $itemUsersBean->getItemUsersInfo($item_id);
		$data['uid'] = $userInfo[0]['uid'];
		$data['context'] = '';
		$ret[] = $data;
	}
	return $ret;
}

