<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_ROOT_PATH . '/core/XCube_PageNavigator.class.php';
require_once dirname(dirname(dirname(__FILE__))) . '/class/bean/ItemFieldDetailBean.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Transaction.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ImportItemtype.class.php';

class Xoonips_PolicyItemTypeAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DESC;

		// breadcrumbs
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_item.php'
		  	),
			array(
			    'name' => $title,
			),
		);
		// get requsts
		$get_keys = array(
	    	'start' => array(
			    'i',
				false,
				false,
			),
		);
		$get_vals = Xoonips_Utils::xoonipsAdminGetRequests( 'get', $get_keys );

		// page navigation
		$start = ( is_null( $get_vals['start'] ) ) ? 0 : $get_vals['start'];
		$limit = 10;
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$count = $itemtypeBean->countItemtypes();

		$pageNavi = new XCube_PageNavigator("policy_itemtype.php", XCUBE_PAGENAVI_START);
		$pageNavi->setTotalItems($count);
		$pageNavi->setPerpage($limit);
		$pageNavi->fetch();

		$navi_title = sprintf( _AM_XOONIPS_POLICY_ITEMTYPE_PAGENAVI_FORMAT,
		$start + 1, ($start + $limit) > $count ? $count : $start + $limit, $count);

		$itemtypes_objs = $itemtypeBean->itemtypeGetItemtypelist($limit, $start);
		$itemtypes = array();
		$itemBean = Xoonips_BeanFactory::getBean('ItemBean', $this->dirname, $this->trustDirname);
		foreach ($itemtypes_objs as $itemtype) {
			$itemtypeid = $itemtype['item_type_id'];
			$name = $itemtype['name'];
			$icon = false;
			if (!empty($itemtype['icon'])) {
				$icon = XOOPS_URL . '/modules/' . $this->dirname . '/images/' . $itemtype['icon'];
			}
			$desc = $itemtype['description'];
			$subtypes = $this->getSubtypes($itemtypeid);
			$editing = '';
			if ($itemtype['released'] == 0) {
				$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
			} elseif ($itemtype['upid'] != '') {
				if ($this->isDiff($itemtypeid)) {
					$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
				} else {
					$upd_itemtypeid = '';
					$this->getItemtypeInfoForEdit($itemtypeBean, $itemtypeid, $upd_itemtypeid);
					$this->deleteAll($upd_itemtypeid);
				}
			}

			// check number of item
			$disdel = false;
			$checkItemtype = $itemBean->checkItemtype($itemtypeid);
			if ($checkItemtype == 0) {
				$disdel = true;
			}
			if ($itemtype['released'] == 0) {
				$disdel = true;
			}

			$itemtypes[] = array(
			    'itemtypeid' => $itemtypeid,
			    'name' => $name,
				'editing' => $editing,
			    'icon' => $icon,
			    'desc' => $desc,
				'subtypes' => $subtypes,
				'disdel' => $disdel
			);
		}

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_default') );

		// get common viewdata
		$viewData = array();

		$viewData['token_ticket'] = $token_ticket;
		$viewData['navi_title'] = $navi_title;
		$viewData['itemtypes'] = $itemtypes;
		$viewData['pageNavi'] = $pageNavi;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $limit;
		$viewData['startpage'] = $start;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doRegister(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get groups for select
		$groups = $this->getGroupsForSelect(0);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_register'));

		// get common viewdata
		$viewData = array();

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;

		$viewData['groups'] = $groups;

		$viewData['token_ticket'] = $token_ticket;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('register_success');
		return true;
	}

	protected function doRegistersave(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$name = $request->getParameter('name');
		$descrip = $request->getParameter('descrip');
		$weight = $request->getParameter('weight');
		$template = $request->getParameter('template');
		$icon_file = $request->getFile('icon_file');
		$mode = $request->getParameter('mode');

		if($weight=='')
			$weight='0';
		
		// get groups info
		$groups = array();
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$count = $groupBean->countItemgroups();
		$groups_objs = $groupBean->getItemgrouplist($count, 0);

		foreach ($groups_objs as $itemgroup) {
			$itemgroupid = $itemgroup['group_id'];
			if ($request->getParameter('checkbox_'.$itemgroupid) || $itemgroup['preselect'] == 1) {
				if ($itemgroup['preselect'] == 1){
					$itemgroup['edit_weight'] = $itemgroup['weight'];
				}
				$groups[] = $itemgroupid;
			}
		}

		// do check
		$errors = new Xoonips_Errors();
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_NAME;
		if ($name=='') {
			// get groups for select
			$groups = $this->getGroupsForSelect(0);

			// token ticket
			$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_register'));
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['name'] = $name;
			$viewData['title'] = $title;
			$viewData['descrip'] = $descrip;
			$viewData['weight'] = $weight;
			$viewData['template'] = $template;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;
			$viewData['groups'] = $groups;

			$response->setViewData($viewData);
			$response->setForward('register_success');
			return true;
		} else {
			$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
			if ($itemtypeBean->existItemTypeName(0, $name)) {
				// get groups for select
				$groups = $this->getGroupsForSelect(0);

				// token ticket
				$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_register'));
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				$viewData['breadcrumbs'] = $breadcrumbs;
				$viewData['name'] = $name;
				$viewData['title'] = $title;
				$viewData['descrip'] = $descrip;
				$viewData['weight'] = $weight;
				$viewData['template'] = $template;
				$viewData['token_ticket'] = $token_ticket;
				$viewData['errors'] = $errors->getView($this->dirname);
				$viewData['dirname'] = $this->dirname;

				$viewData['groups'] = $groups;

				$response->setViewData($viewData);
				$response->setForward('register_success');
				return true;
			}
		}

		// check token ticket
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemtype_register'))) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// insert itemtype
		$itemtype_id = 0;
		if (!$this->insertXoonipsItemtype($itemtype_id, $name, $weight, $descrip, $template, $icon_file)) {

			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// insert itemtype group and detail
		if (!$this->insertXoonipsItemtypeGroupAndDetail($itemtype_id)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// update link of type and group
		if ( !$this->updateTypeGroupLink($itemtype_id, $groups) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// release mode
		if ($mode == 1) {
			if (!$this->releaseXoonipsItemtype($itemtype_id, $itemtype_id)) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_RELEASED_MSG_FAILURE;
				$response->setViewData($viewData);
				$response->setForward('registersave_success');
				return true;
			}
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		if ($mode == 1) $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_RELEASED_MSG_SUCCESS;
		else $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_REGIST_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('registersave_success');
		return true;
	}

	protected function doEdit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_itemtypeid = $request->getParameter('itemtypeid');
		$perpage = $request->getParameter('perpage');
		$startpage = $request->getParameter('start');

		// get base itemtype info
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$baseInfo = $itemtypeBean->getItemtypeEditInfo($base_itemtypeid);
		if (!$baseInfo || count( $baseInfo ) == 0) {
			die( "can't get item type" );
		}

		// do copy
		if ($baseInfo['a_released'] == 1 && $baseInfo['b_update_id'] != $base_itemtypeid) {
			// transaction
			$transaction = Xoonips_Transaction::getInstance();
			$transaction->start();

			if ( !$this->doCopyItemtype( $base_itemtypeid ) ) {
				$transaction->rollback();
				die( "copy item type failure!" );
			}

			// success
			$transaction->commit();
		}

		// get edit itemtype info
		$upd_itemtypeid = '';
		$itemtypeInfo = $this->getItemtypeInfoForEdit($itemtypeBean, $base_itemtypeid, $upd_itemtypeid);

		// get itemtype group list
		$groups = $this->getFieldGroupsInfo($base_itemtypeid);

		$group_diff = 0;
		if (self::isGroupLinkDiff($base_itemtypeid)) {
			$group_diff = 1;
		}

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_edit') );

		// get common viewdata
		$viewData = array();

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['itemtypeInfo'] = $itemtypeInfo;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['upd_itemtypeid'] = $upd_itemtypeid;
		$viewData['group_diff'] = $group_diff;
		$viewData['complement_diff'] = $this->isComplementDiff($upd_itemtypeid, $base_itemtypeid);
		$viewData['groups'] = $groups;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $perpage;
		$viewData['startpage'] = $startpage;

		$response->setViewData($viewData);
		$response->setForward('edit_success');
		return true;
	}

	protected function doEditsave(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_itemtypeid = $request->getParameter('itemtypeid');
		$mode = $request->getParameter('mode');

		// get base itemtype info
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$baseInfo = $itemtypeBean->getItemtypeEditInfo($base_itemtypeid);
		if (!$baseInfo || count($baseInfo) == 0) {
			die("can't get item type");
		}

		// do copy
		if ($baseInfo['a_released'] == 1 && $baseInfo['b_update_id'] != $base_itemtypeid) {
			// transaction
			$transaction = Xoonips_Transaction::getInstance();
			$transaction->start();

			if (!$this->doCopyItemtype($base_itemtypeid)) {
				$transaction->rollback();
				die("copy item type failure!");
			}

			// success
			$transaction->commit();
		}

		// get edit itemtype info
		$upd_itemtypeid = '';
		$itemtypeInfo = $this->getItemtypeInfoForEdit($itemtypeBean, $base_itemtypeid, $upd_itemtypeid);

		// get itemtype group list
		$groups = $itemtypeBean->getTypeGroups($base_itemtypeid);

		// do update
		$errors = new Xoonips_Errors();
		$name = $request->getParameter('name');
		$description = $request->getParameter('description');
		$weight = $request->getParameter('weight');
		$template = $request->getParameter('template');
		$icon_file = $request->getFile('icon_file');
		$group_ids = $request->getParameter('group_ids');
		$weights = $request->getParameter('weights');

		// do check
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_NAME;
		if ($name=='') {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_edit') );
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
			$itemtypeInfo['a_name'] = $name;
			$itemtypeInfo['a_description'] = $description;
			$itemtypeInfo['a_weight'] = $weight;
			$itemtypeInfo['a_template'] = $template;
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['itemtypeInfo'] = $itemtypeInfo;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['upd_itemtypeid'] = $upd_itemtypeid;
			$viewData['groups'] = $groups;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('edit_success');
			return true;
		} else {
			$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
			if ($itemtypeBean->existItemTypeName($upd_itemtypeid, $name)) {
				// token ticket
				$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_edit') );
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				$itemtypeInfo['a_name'] = $name;
				$itemtypeInfo['a_description'] = $description;
				$itemtypeInfo['a_weight'] = $weight;
				$itemtypeInfo['a_template'] = $template;
				$viewData['breadcrumbs'] = $breadcrumbs;
				$viewData['token_ticket'] = $token_ticket;
				$viewData['itemtypeInfo'] = $itemtypeInfo;
				$viewData['base_itemtypeid'] = $base_itemtypeid;
				$viewData['upd_itemtypeid'] = $upd_itemtypeid;
				$viewData['groups'] = $groups;
				$viewData['title'] = $title;
				$viewData['description'] = $description;
				$viewData['errors'] = $errors->getView($this->dirname);
				$viewData['dirname'] = $this->dirname;

				$response->setViewData($viewData);
				$response->setForward('edit_success');
				return true;
			}
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_edit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update itemtype
		if ( !$this->updateXoonipsItemtype( $upd_itemtypeid, $name, $weight, $description, $template, $icon_file ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// update itemtype group weight
		if ( !$this->updateXoonipsItemtypeGroupOrder($base_itemtypeid, $group_ids, $weights) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		if ($mode == 1) {
			$viewData['url'] .= '?op=edit&amp;itemtypeid='.$base_itemtypeid;
		}
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('editsave_success');
		return true;
	}

	protected function doSorteditsave(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_itemtypeid = $request->getParameter('itemtypeid');
		$mode = $request->getParameter('mode');
		$group_ids = $request->getParameter('group_ids');
		$weights = $request->getParameter('weights');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_edit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update itemtype group weight
		if ( !$this->updateXoonipsItemtypeGroupOrder($base_itemtypeid, $group_ids, $weights) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		if ($mode == 1) {
			$viewData['url'] .= '?op=edit&amp;itemtypeid='.$base_itemtypeid;
		}
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('editsave_success');
		return true;
	}

	private function setBreadcrumbs($title) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL . '/modules/' . $this->dirname . '/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL . '/modules/' . $this->dirname . '/admin/policy.php',
			),
			array(
				'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
				'url' => XOOPS_URL . '/modules/' . $this->dirname.'/admin/policy_item.php'
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_TITLE,
			    'url' => XOOPS_URL . '/modules/' . $this->dirname . '/admin/policy_itemtype.php',
			),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	// get edit itemtype info
	private function getItemtypeInfoForEdit($itemtypeBean, $itemtypeid, &$upd_itemtypeid) {
		$info = $itemtypeBean->getItemtypeEditInfo($itemtypeid);
		$itemtypeInfo = array (
		    'a_name' => $info['a_released']==1 ? $info['b_name'] : $info['a_name'],
			'a_description' => $info['a_released']==1 ? $info['b_description'] : $info['a_description'],
		    'a_weight' => $info['a_released']==1 ? $info['b_weight'] : $info['a_weight'],
		    'a_icon' => $info['a_released']==1 ? $info['b_icon'] : $info['a_icon'],
			'a_template' => $info['a_released']==1 ? $info['b_template'] : $info['a_template'],
		    'b_name' => $info['a_released']==1 ? $info['a_name'] : $info['b_name'],
			'b_description' => $info['a_released']==1 ? $info['a_description'] : $info['b_description'],
		    'b_weight' => $info['a_released']==1 ? $info['a_weight'] : $info['b_weight'],
		    'b_icon' => $info['a_released']==1 ? $info['a_icon'] : $info['b_icon'],
			'b_template' => $info['a_released']==1 ? $info['a_template'] : $info['b_template'],
		);
		$upd_itemtypeid = empty($info['b_item_type_id']) ? $info['a_item_type_id'] : $info['b_item_type_id'];
		return $itemtypeInfo;
	}

	private function getFieldGroupsInfo($itemtypeid) {
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$groupInfos = $itemtypeBean->getTypeGroups($itemtypeid);

		$groups = array();
		foreach ($groupInfos as $group) {
			if($group['edit'] == 1){
				$group['weight'] = $group['edit_weight'];
				$groups[] = $group;
			}
		}
		return $groups;
	}

	private function isGroupDiff($groupid) {
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$info = $groupBean->getGroupEditInfo($groupid, true);
		if ($info['b_name'] != $info['a_name'] || $info['b_xml'] != $info['a_xml']
				|| $info['b_occurrence'] != $info['a_occurrence']
				|| $info['b_weight'] != $info['a_weight']) {
			return true;
		}
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$detailInfos = $detailBean->getGroupDetails($groupid);
		foreach ($detailInfos as $detail) {
			if ($this->isDetailDiff($detailBean, $detail['item_field_detail_id'])) {
				return true;
			}
		}
		return false;
	}

	private function isDiff($base_itemtypeid) {
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$upd_itemtypeid = '';
		$info = $this->getItemtypeInfoForEdit($itemtypeBean, $base_itemtypeid, $upd_itemtypeid);
		if ($info['b_name'] != $info['a_name'] || $info['b_description'] != $info['a_description']
				|| $info['b_weight'] != $info['a_weight'] || $info['b_icon'] != $info['a_icon']
				|| $info['b_template'] != $info['a_template']) {
			return true;
		}

		// get itemtype group list
		if (self::isGroupLinkDiff($base_itemtypeid)) {
			return true;
		}

		if ($this->isComplementDiff($upd_itemtypeid, $base_itemtypeid)) {
			return true;
		}
		return false;
	}

	protected function doCopy(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');

		// itemtype name double check
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$itemtypeObj = $itemtypeBean->getItemType($itemtypeid);
		if ($itemtypeBean->existItemTypeName(0, $itemtypeObj['name']."_"._AM_XOONIPS_LABEL_COPY)) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_NAME_DUPLICATE_MSG;
			$response->setViewData($viewData);
			$response->setForward('copy_success');
			return true;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// copy itemtype
		if ( !$this->doCopyItemtype( $itemtypeid, true ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_COPY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('copy_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_COPY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('copy_success');
		return true;
	}

	protected function doImport(&$request, &$response) {

		$importfile = $request->getFile( 'importfile' );

		if ( empty( $importfile['name'] ) || $importfile['size'] == 0 ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_IMPORT_FILE_NONE;
			$response->setViewData($viewData);
			$response->setForward('import_success');
			return true;
		}

		// check file exists
		if( !file_exists( $importfile['tmp_name'] ) ){
			return false;
		}

		$handler = new Xoonips_ImportItemTypeHandler();
		$itemtype = $handler->parseXml( file_get_contents( $importfile['tmp_name'] ) );

		$errors = $itemtype->getErrors();
		$itemtypeObj = $itemtype->getItemtypeObj();
		$groupObj = $itemtype->getGroupObj();
		$detailObj = $itemtype->getDetailObj();
		$relationObj = $itemtype->getRelationObj();

		if ( !$itemtypeObj ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_IMPORT_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('import_success');
			return true;
		}

		if ( count($errors) > 0 ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = implode( "</br>", $errors );
			$response->setViewData($viewData);
			$response->setForward('import_success');
			return true;
		}

		// itemtype name double check
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		if ($itemtypeBean->existItemTypeName(0, $itemtypeObj['name'])) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_NAME_DUPLICATE_MSG;
			$response->setViewData($viewData);
			$response->setForward('import_success');
			return true;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		if (!$this->doImportItemtype( $itemtypeObj, $groupObj, $detailObj, $relationObj )) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_IMPORT_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('import_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_IMPORT_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('import_success');
		return true;
	}

	protected function doDelete(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');

		// check token ticket
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemtype_default'))) {
			return false;
		}

		// delete message
		$delete_msg = _AM_XOONIPS_POLICY_ITEMTYPE_DELETE_MSG_SUCCESS;

		// delete all
		if (!$this->deleteAll($itemtypeid)) {
			$delete_msg = _AM_XOONIPS_POLICY_ITEMTYPE_DELETE_MSG_FAILURE;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		$viewData['redirect_msg'] = $delete_msg;
		$response->setViewData($viewData);
		$response->setForward('delete_success');
		return true;
	}

	protected function doRelease(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_itemtypeid = $request->getParameter('itemtypeid');

		// get base itemtype info
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$baseInfo = $itemtypeBean->getItemtypeEditInfo($base_itemtypeid);
		if (!$baseInfo || count($baseInfo) == 0) {
			die("can't get item type");
		}

		// do copy
		if ($baseInfo['a_released'] == 1 && $baseInfo['b_update_id'] != $base_itemtypeid) {
			// transaction
			$transaction = Xoonips_Transaction::getInstance();
			$transaction->start();

			if (!$this->doCopyItemtype($base_itemtypeid)) {
				$transaction->rollback();
				die( "copy item type failure!" );
			}

			// success
			$transaction->commit();
		}

		// get edit itemtype info
		$upd_itemtypeid = '';
		$itemtypeInfo = $this->getItemtypeInfoForEdit($itemtypeBean, $base_itemtypeid, $upd_itemtypeid);

		// get itemtype group list
		$groups = $itemtypeBean->getTypeGroups($base_itemtypeid);

		// do update
		$errors = new Xoonips_Errors();
		$name = $request->getParameter('name');
		$description = $request->getParameter('description');
		$weight = $request->getParameter('weight');
		$template = $request->getParameter('template');
		$icon_file = $request->getFile('icon_file');
		$group_ids = $request->getParameter('group_ids');
		$weights = $request->getParameter('weights');

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_edit'));

		// do check
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_NAME;
		if ($name=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['itemtypeInfo'] = $itemtypeInfo;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['upd_itemtypeid'] = $upd_itemtypeid;
			$viewData['groups'] = $groups;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('edit_success');
			return true;
		} else {
			$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
			if ($itemtypeBean->existItemTypeName($upd_itemtypeid, $name)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				$viewData['breadcrumbs'] = $breadcrumbs;
				$viewData['token_ticket'] = $token_ticket;
				$viewData['itemtypeInfo'] = $itemtypeInfo;
				$viewData['base_itemtypeid'] = $base_itemtypeid;
				$viewData['upd_itemtypeid'] = $upd_itemtypeid;
				$viewData['groups'] = $groups;
				$viewData['title'] = $title;
				$viewData['description'] = $description;
				$viewData['errors'] = $errors->getView($this->dirname);
				$viewData['dirname'] = $this->dirname;

				$response->setViewData($viewData);
				$response->setForward('edit_success');
				return true;
			}
		}

		$itemtypeInfo['a_name'] = $name;
		$itemtypeInfo['a_description'] = $description;
		$itemtypeInfo['a_weight'] = $weight;
		$itemtypeInfo['a_template'] = $template;

		// check token ticket
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemtype_edit'))) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update itemtype
		if (!$this->updateXoonipsItemtype($upd_itemtypeid, $name, $weight, $description, $template, $icon_file, true)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_RELEASED_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('release_success');
			return true;
		}

		// update copy data to base data
		if (!$this->releaseXoonipsItemtype($base_itemtypeid, $upd_itemtypeid)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_RELEASED_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('release_success');
			return true;
		}

		// success
		$transaction->commit();

		// delete templates_c file
		$this->deleteTemplatesFile( $base_itemtypeid );

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_RELEASED_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('release_success');
		return true;
	}

	protected function doBreak(&$request, &$response) {
		// get requests
		$itemtypeid = $request->getParameter('upd_itemtypeid');

		// check token ticket
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemtype_edit'))) {
			return false;
		}

		// delete message
		$delete_msg = _AM_XOONIPS_POLICY_ITEMTYPE_BREAK_MSG_SUCCESS;

		// delete all
		if (!$this->deleteAll($itemtypeid)) {
			$delete_msg = _AM_XOONIPS_POLICY_ITEMTYPE_BREAK_MSG_FAILURE;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		$viewData['redirect_msg'] = $delete_msg;
		$response->setViewData($viewData);
		$response->setForward('break_success');
		return true;

	}

	protected function doExport(&$request, &$response) {

		// get requests
		$base_itemtypeid = $request->getParameter('itemtypeid');

		$filename = "itemtype_${base_itemtypeid}.xml";
		$tmpfile = tempnam( '/tmp', 'Itemtype' );

		$fhdl = fopen( $tmpfile, 'w' );
		if ( ! $fhdl ) {
			die( "can't open file '${tmpfile}' for write." );
		}

		// xml head
		if ( ! fwrite( $fhdl, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" ) ) {
			return false;
		}

		// get itemtype info xml
		if ( !$this->getItemtypeInfoXML( $fhdl, $base_itemtypeid) ) {
			return false;
		}

		$size = filesize( $tmpfile );
		header("Cache-Control: none");
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-Type: application/xml");
		if( $size != false ) header("Content-Length: $size");
		readfile( $tmpfile );
		fclose( $fhdl );
		unlink( $tmpfile );
		exit();
	}

	protected function doGroupregister(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = $request->getParameter('occurrence');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_group_register'));

		// get common viewdata
		//$viewData = array();

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['itemtype_name'] = $itemtype_name;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['occurrence'] = $occurrence;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('groupregister_success');
		return true;
	}

	protected function doGroupregistersave(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = $request->getParameter('occurrence');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName( $itemtypeid );

		// do check
		$errors = new Xoonips_Errors();
		if (!$this->doGroupregistersaveInputCheck($itemtypeid, $name, $xml, $errors)) {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_group_register') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['itemtypeid'] = $itemtypeid;
			$viewData['itemtype_name'] = $itemtype_name;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['occurrence'] = $occurrence;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('groupregister_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_group_register') ) ) {
			return false;
		}

		// insert itemtype group
		if ( !$this->insertXoonipsItemtypeGroup( $itemtypeid, $name, $xml, $occurrence ) ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('groupregistersave_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_REGIST_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('groupregistersave_success');
		return true;
	}

	protected function doGroupedit(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get group detail list
		$details = $this->getFieldInfos($groupid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_groupedit'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['itemtype_name'] = $itemtype_name;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['groupid'] = $groupid;
		$viewData['groupInfo'] = $groupInfo;
		$viewData['details'] = $details;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('groupedit_success');
		return true;
	}

	protected function doGroupeditsave(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$mode = $request->getParameter('mode');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get group detail list
		$details = $this->getFieldInfos($groupid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// do update
		$errors = new Xoonips_Errors();
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = $request->getParameter('occurrence');
		$detail_ids = $request->getParameter('detail_ids');
		$weights = $request->getParameter('weights');

		// do check
		if (!$this->doGroupeditsaveInputCheck($itemtypeid, $groupid, $name, $xml, $errors)){
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_groupedit') );
			$groupInfo['a_name'] = $name;
			$groupInfo['a_xml'] = $xml;
			$groupInfo['a_occurrence'] = $occurrence;
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['itemtype_name'] = $itemtype_name;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['itemtypeid'] = $itemtypeid;
			$viewData['groupid'] = $groupid;
			$viewData['groupInfo'] = $groupInfo;
			$viewData['details'] = $details;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('groupedit_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_groupedit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update group
		if ( !$this->updateXoonipsItemtypeGroup( $groupid, $name, $xml, $occurrence ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('groupeditsave_success');
			return true;
		}

		// update detail weight
		if ( !$this->updateXoonipsItemtypeDetailOrder( $detail_ids, $weights ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('groupeditsave_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php';
		if ($mode == 1) {
			$viewData['url'] .= '?op=groupedit&amp;itemtypeid=' . $itemtypeid . '&amp;base_itemtypeid=' . $base_itemtypeid . '&amp;groupid=' . $groupid;
		} else {
			$viewData['url'] .= '?op=edit&amp;itemtypeid=' . $base_itemtypeid;
		}
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('groupeditsave_success');
		return true;
	}

	protected function doGroupdelete(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$groupid = $request->getParameter('groupid');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_edit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// delete all
		if ( !$this->deleteGroupAll( $groupid ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$itemtypeid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_DELETE_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('groupdelete_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$itemtypeid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_DELETE_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('groupdelete_success');
		return true;
	}

	private function setGroupBreadcrumbs($title, $base_itemtypeid) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
				'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
				'url' => XOOPS_URL . '/modules/' . $this->dirname.'/admin/policy_item.php'
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid,
			),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	// get edit field group info
	private function getGroupInfoForEdit($groupid) {
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$info = $groupBean->getGroupEditInfo($groupid, true);
		$groupInfo = array (
		    'a_name' => $info['a_released']==1 ? $info['b_name'] : $info['a_name'],
			'a_xml' => $info['a_released']==1 ? $info['b_xml'] : $info['a_xml'],
		    'a_occurrence' => $info['a_released']==1 ? $info['b_occurrence'] : $info['a_occurrence'],
			'a_weight' => $info['a_released']==1 ? $info['b_weight'] : $info['a_weight'],
			'b_name' => $info['a_released']==1 ? $info['a_name'] : $info['b_name'],
		    'b_xml' => $info['a_released']==1 ? $info['a_xml'] : $info['b_xml'],
			'b_occurrence' => $info['a_released']==1 ? $info['a_occurrence'] : $info['b_occurrence'],
			'b_weight' => $info['a_released']==1 ? $info['a_weight'] : $info['b_weight'],
		);
		return $groupInfo;
	}

	private function getFieldInfos($groupid) {
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$detailInfos = $detailBean->getGroupDetails($groupid);
		$details = array();
		foreach ($detailInfos as $detail) {
			$disdel = false;
			if ($detail['released'] == 0 && empty($detail['update_id']) && $detail['preselect'] == 0) {
				$disdel = true;
			}
			$details[] = array(
				'detail_id' => $detail['item_field_detail_id'],
			    'name' => $detail['name'],
				'weight' => $detail['weight'],
				'disdel' => $disdel,
				'diff' => $this->isDetailDiff($detailBean, $detail['item_field_detail_id'])
			);
		}
		return $details;
	}

	protected function doDetailregister(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$detail_target = $request->getParameter('detail_target');
		$scope_search = $request->getParameter('scope_search');
		$scope_search_arr = $request->getParameter('scope_search_arr');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $base_itemtypeid, $itemtypeid, $groupid);

		// get group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetailregisterListBlock( $view_type, $list );

		// get default block
		$default_block = $this->getDetailregisterDefaultValutBlock( $view_type, $list, $default_value );

		// get datatype info
		$selected_datatype_name = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_detailadd'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['itemtype_name'] = $itemtype_name;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['groupid'] = $groupid;
		$viewData['groupInfo'] = $groupInfo;
		$viewData['viewtypelist'] = $viewtypelist;
		$viewData['datatypelist'] = $datatypelist;
		$viewData['selected_datatype_name'] = $selected_datatype_name;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['data_length'] = $data_length;
		$viewData['data_decimal_places'] = $data_decimal_places;
		$viewData['default_value'] = $default_value;
		$viewData['essential'] = $essential;
		$viewData['detail_display'] = $detail_display;
		$viewData['detail_target'] = $detail_target;
		$viewData['scope_search'] = $scope_search;
		$viewData['scope_search_arr'] = $scope_search_arr;
		$viewData['list_block'] = $list_block;
		$viewData['default_block'] = $default_block;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('detailregister_success');
		return true;
	}

	protected function doDetailregistersave(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$detail_target = $request->getParameter('detail_target');
		$scope_search = $request->getParameter('scope_search');
		$scope_search_arr = $request->getParameter('scope_search_arr');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $base_itemtypeid, $itemtypeid, $groupid);

		// get group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetailregisterListBlock($view_type, $list);

		// get default block
		$default_block = $this->getDetailregisterDefaultValutBlock($view_type, $list, $default_value);

		// get datatype info
		$selected_datatype_name = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// do check
		$errors = new Xoonips_Errors();
		$inputData = array();
		$inputData['name'] = $name;
		$inputData['xml'] = $xml;
		$inputData['view_type'] = $view_type;
		$inputData['data_type'] = $data_type;
		$inputData['list'] = $list;
		$inputData['length'] = $data_length;
		$inputData['length2'] = $data_decimal_places;
		$inputData['default'] = $default_value;

		if (!$this->doDetailregistersaveInputCheck($itemtypeid, $groupid, $inputData, $errors)) {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_detailadd') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['itemtype_name'] = $itemtype_name;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['itemtypeid'] = $itemtypeid;
			$viewData['groupid'] = $groupid;
			$viewData['groupInfo'] = $groupInfo;
			$viewData['viewtypelist'] = $viewtypelist;
			$viewData['datatypelist'] = $datatypelist;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['data_length'] = $data_length;
			$viewData['data_decimal_places'] = $data_decimal_places;
			$viewData['default_value'] = $default_value;
			$viewData['essential'] = $essential;
			$viewData['detail_display'] = $detail_display;
			$viewData['detail_target'] = $detail_target;
			$viewData['scope_search'] = $scope_search;
			$viewData['scope_search_arr'] = $scope_search_arr;
			$viewData['list_block'] = $list_block;
			$viewData['default_block'] = $default_block;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('detailregister_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_detailadd') ) ) {
			return false;
		}

		// insert itemtype detail
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		$maxOrder = $detailBean->getMaxDetailWeight( $groupid );

		$detail_info = array();
		$detail_info['released'] = 0;
		$detail_info['preselect'] = 0;
		$detail_info['table_name'] = "xoonips_item_extend";
		$detail_info['column_name'] = "value";
		$detail_info['item_type_id'] = $itemtypeid;
		$detail_info['group_id'] = $groupid;
		$detail_info['weight'] = $maxOrder + 1;
		$detail_info['name'] = $name;
		$detail_info['xml'] = $xml;
		$detail_info['view_type_id'] = $view_type;
		$detail_info['data_type_id'] = $data_type;
		$detail_info['data_length'] = ($data_length=="") ? -1 : $data_length;
		$detail_info['data_decimal_places'] = ($data_decimal_places=="") ? -1 : $data_decimal_places;
		$detail_info['default_value'] = ($default_value=="") ? NULL : $default_value;
		$detail_info['list'] = ($list=="") ? NULL : $list;
		$detail_info['essential'] = empty($essential) ? 0 : $essential;
		$detail_info['detail_display'] = empty($detail_display) ? 0 : $detail_display;
		$detail_info['detail_target'] = empty($detail_target) ? 0 : $detail_target;
		$detail_info['scope_search'] = empty($scope_search) ? 0 : $scope_search;
		$detail_info['nondisplay'] = 0;
		$detail_info['update_id'] = NULL;

		$new_detail_id = 0;
		if (!$detailBean->insert( $detail_info, $new_detail_id )){
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
		    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('detailregistersave_success');
			return true;
		}

		if (!$detailBean->updateTableName( $new_detail_id )){
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
		    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('detailregistersave_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
	    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_REGIST_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('detailregistersave_success');
		return true;
	}

	protected function doDetailedit(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$detailid = $request->getParameter('detailid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$detail_target = $request->getParameter('detail_target');
		$scope_search = $request->getParameter('scope_search');
		$nondisplay = $request->getParameter('nondisplay');
		$scope_search_arr = $request->getParameter('scope_search_arr');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $base_itemtypeid, $itemtypeid, $groupid);

		// get group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get detail info
		$disabled_arr = '';
		$detailInfo = $this->getDetailInfoForEdit($detailid, $disabled_arr);

		// get default_value title
		if ($detailInfo['b_list']!='' && $detailInfo['b_default_value']!='') {
			$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
			$detailInfo['b_default_value'] = $valueSetBean->getItemTypeValueTitle($detailInfo['b_list'], $detailInfo['b_default_value']);
		}

		// initialization
		if ( $changeop=='' ) {
			$name = $detailInfo['a_name'];
			$xml = $detailInfo['a_xml'];
			$view_type = $detailInfo['a_view_type'];
			$data_type = $detailInfo['a_data_type'];
			$list = $detailInfo['a_list'];
			$data_length = $detailInfo['a_data_length'];
			$data_decimal_places = $detailInfo['a_data_decimal_places'];
			$default_value = $detailInfo['a_default_value'];
			$essential = $detailInfo['a_essential'];
			$detail_display = $detailInfo['a_detail_display'];
			$detail_target = $detailInfo['a_detail_target'];
			$scope_search = $detailInfo['a_scope_search'];
			$nondisplay = $detailInfo['a_nondisplay'];
		}

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetaileditListBlock( $view_type, $list, $disabled_arr );

		// get default block
		$default_block = $this->getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr );

		// get datatype info
		$selected_datatype_name = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);


		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_detailedit'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['itemtype_name'] = $itemtype_name;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['groupid'] = $groupid;
		$viewData['detailid'] = $detailid;
		$viewData['groupInfo'] = $groupInfo;
		$viewData['detailInfo'] = $detailInfo;
		$viewData['viewtypelist'] = $viewtypelist;
		$viewData['datatypelist'] = $datatypelist;
		$viewData['selected_datatype_name'] = $selected_datatype_name;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['view_type'] = $view_type;
		$viewData['data_type'] = $data_type;
		$viewData['data_length'] = $data_length;
		$viewData['data_decimal_places'] = $data_decimal_places;
		$viewData['default_value'] = $default_value;
		$viewData['essential'] = $essential;
		$viewData['detail_display'] =  $detail_display;
		$viewData['detail_target'] = $detail_target;
		$viewData['scope_search'] = $scope_search;
		$viewData['nondisplay'] = $nondisplay;
		$viewData['scope_search_arr'] = $scope_search_arr;
		$viewData['disabled_arr'] = $disabled_arr;
		$viewData['list_block'] = $list_block;
		$viewData['default_block'] = $default_block;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('detailedit_success');
		return true;
	}

	protected function doDetaileditsave(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$detailid = $request->getParameter('detailid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$detail_target = $request->getParameter('detail_target');
		$scope_search = $request->getParameter('scope_search');
		$nondisplay = $request->getParameter('nondisplay');
		$scope_search_arr = $request->getParameter('scope_search_arr');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_DESC;
		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $base_itemtypeid, $itemtypeid, $groupid);

		// get group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get detail info
		$disabled_arr = '';
		$detailInfo = $this->getDetailInfoForEdit($detailid, $disabled_arr);

		// get default_value title
		if ( $detailInfo['b_list']!='' && $detailInfo['b_default_value']!='') {
			$valueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean',$this->dirname,$this->trustDirname);
			$detailInfo['b_default_value'] = $valueSetBean->getItemTypeValueTitle($detailInfo['b_list'], $detailInfo['b_default_value']);
		}

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ($changeop=='vtchange') {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ($changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetaileditListBlock( $view_type, $list, $disabled_arr );

		// get default block
		$default_block = $this->getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr );

		// get datatype info
		$selected_datatype_name = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// do check
		$errors = new Xoonips_Errors();
		$inputData = array();
		$inputData['name'] = $name;
		$inputData['xml'] = $xml;
		$inputData['view_type'] = $view_type;
		$inputData['data_type'] = $data_type;
		$inputData['list'] = $list;
		$inputData['length'] = $data_length;
		$inputData['length2'] = $data_decimal_places;
		$inputData['default'] = $default_value;

		if (!$this->doDetaileditsaveInputCheck($itemtypeid, $groupid, $detailid, $inputData, $errors)) {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemtype_detailedit') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['itemtype_name'] = $itemtype_name;
			$viewData['base_itemtypeid'] = $base_itemtypeid;
			$viewData['itemtypeid'] = $itemtypeid;
			$viewData['groupid'] = $groupid;
			$viewData['detailid'] = $detailid;
			$viewData['groupInfo'] = $groupInfo;
			$viewData['detailInfo'] = $detailInfo;
			$viewData['viewtypelist'] = $viewtypelist;
			$viewData['datatypelist'] = $datatypelist;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['view_type'] = $view_type;
			$viewData['data_type'] = $data_type;
			$viewData['data_length'] = $data_length;
			$viewData['data_decimal_places'] = $data_decimal_places;
			$viewData['default_value'] = $default_value;
			$viewData['essential'] = $essential;
			$viewData['detail_display'] =  $detail_display;
			$viewData['detail_target'] = $detail_target;
			$viewData['scope_search'] = $scope_search;
			$viewData['nondisplay'] = $nondisplay;
			$viewData['scope_search_arr'] = $scope_search_arr;
			$viewData['disabled_arr'] = $disabled_arr;
			$viewData['list_block'] = $list_block;
			$viewData['default_block'] = $default_block;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('detailedit_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_detailedit') ) ) {
			return false;
		}

		// update itemtype detail
		$detail_info = array();
		$detail_info['name'] = $name;
		$detail_info['xml'] = $xml;
		$detail_info['view_type_id'] = $view_type;
		$detail_info['data_type_id'] = $data_type;
		$detail_info['data_length'] = ($data_length=="") ? -1 : $data_length;
		$detail_info['data_decimal_places'] = ($data_decimal_places=="") ? -1 : $data_decimal_places;
		$detail_info['default_value'] = ($default_value=="") ? NULL : $default_value;
		$detail_info['list'] = ($list=="") ? NULL : $list;
		$detail_info['essential'] = empty($essential) ? 0 : $essential;
		$detail_info['detail_display'] = empty($detail_display) ? 0 : $detail_display;
		$detail_info['detail_target'] = empty($detail_target) ? 0 : $detail_target;
		$detail_info['scope_search'] = empty($scope_search) ? 0 : $scope_search;
		$detail_info['nondisplay'] = empty($nondisplay) ? 0 : $nondisplay;

		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		if (!$detailBean->update( $detail_info, $detailid )){
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
		    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('detaileditsave_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
	    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('detaileditsave_success');
		return true;
	}

	protected function doDetaildelete(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$groupid = $request->getParameter('groupid');
		$detailid = $request->getParameter('detailid');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_groupedit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// delete all
		if (!$this->deleteDetailAll($detailid)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
	    			'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_DELETE_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('detaildelete_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
    			'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_DELETE_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('detaildelete_success');
		return true;
	}

	private function setDetailBreadcrumbs($title, $base_itemtypeid, $itemtypeid, $groupid) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_EDIT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid,
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=groupedit&itemtypeid='.$itemtypeid.
		    		'&base_itemtypeid='.$base_itemtypeid.'&groupid='.$groupid,
			),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	// get edit field info
	private function getDetailInfoForEdit($detailid, &$disabled_arr) {
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$dinfo = $detailBean->getDetailEditInfo($detailid, true);
		$disabled_arr = $dinfo['b_released']==1 ? 'disabled="disabled"' : '';
		$b_view_type_id = $dinfo['a_released']==1 ? $dinfo['a_view_type_id'] : $dinfo['b_view_type_id'];
		$b_data_type_id = $dinfo['a_released']==1 ? $dinfo['a_data_type_id'] : $dinfo['b_data_type_id'];
		$detailInfo = array (
		    'a_name' => $dinfo['a_released']==1 ? $dinfo['b_name'] : $dinfo['a_name'],
			'a_xml' => $dinfo['a_released']==1 ? $dinfo['b_xml'] : $dinfo['a_xml'],
			'a_view_type' => $dinfo['a_released']==1 ? $dinfo['b_view_type_id'] : $dinfo['a_view_type_id'],
			'a_data_type' => $dinfo['a_released']==1 ? $dinfo['b_data_type_id'] : $dinfo['a_data_type_id'],
			'a_data_length' => $dinfo['a_released']==1 ? $dinfo['b_data_length'] : $dinfo['a_data_length'],
			'a_data_decimal_places' => $dinfo['a_released']==1 ? $dinfo['b_data_decimal_places'] : $dinfo['a_data_decimal_places'],
			'a_default_value' => $dinfo['a_released']==1 ? $dinfo['b_default_value'] : $dinfo['a_default_value'],
			'a_list' => $dinfo['a_released']==1 ? $dinfo['b_list'] : $dinfo['a_list'],
			'a_essential' => $dinfo['a_released']==1 ? $dinfo['b_essential'] : $dinfo['a_essential'],
			'a_detail_display' => $dinfo['a_released']==1 ? $dinfo['b_detail_display'] : $dinfo['a_detail_display'],
			'a_detail_target' => $dinfo['a_released']==1 ? $dinfo['b_detail_target'] : $dinfo['a_detail_target'],
			'a_scope_search' => $dinfo['a_released']==1 ? $dinfo['b_scope_search'] : $dinfo['a_scope_search'],
			'a_nondisplay' => $dinfo['a_released']==1 ? $dinfo['b_nondisplay'] : $dinfo['a_nondisplay'],
		    'a_weight' => $dinfo['a_released']==1 ? $dinfo['b_weight'] : $dinfo['a_weight'],
		    'b_name' => $dinfo['a_released']==1 ? $dinfo['a_name'] : $dinfo['b_name'],
			'b_xml' => $dinfo['a_released']==1 ? $dinfo['a_xml'] : $dinfo['b_xml'],
			'b_view_type' => $b_view_type_id,
			'b_data_type' => $b_data_type_id,
			'b_view_name' => empty($b_view_type_id) ? "" : Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType($b_view_type_id)->getName(),
			'b_data_name' => empty($b_data_type_id) ? "" : Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($b_data_type_id)->getName(),
			'b_data_length' => $dinfo['a_released']==1 ? $dinfo['a_data_length'] : $dinfo['b_data_length'],
			'b_data_decimal_places' => $dinfo['a_released']==1 ? $dinfo['a_data_decimal_places'] : $dinfo['b_data_decimal_places'],
			'b_default_value' => $dinfo['a_released']==1 ? $dinfo['a_default_value'] : $dinfo['b_default_value'],
			'b_list' => $dinfo['a_released']==1 ? $dinfo['a_list'] : $dinfo['b_list'],
			'b_essential' => $dinfo['a_released']==1 ? $dinfo['a_essential'] : $dinfo['b_essential'],
			'b_detail_display' => $dinfo['a_released']==1 ? $dinfo['a_detail_display'] : $dinfo['b_detail_display'],
			'b_detail_target' => $dinfo['a_released']==1 ? $dinfo['a_detail_target'] : $dinfo['b_detail_target'],
			'b_scope_search' => $dinfo['a_released']==1 ? $dinfo['a_scope_search'] : $dinfo['b_scope_search'],
			'b_nondisplay' => $dinfo['a_released']==1 ? $dinfo['a_nondisplay'] : $dinfo['b_nondisplay'],
		    'b_weight' => $dinfo['a_released']==1 ? $dinfo['a_weight'] : $dinfo['b_weight'],
		);
		return $detailInfo;
	}

	private function isDetailDiff($detailBean, $detailid) {
		$dinfo = $detailBean->getDetailEditInfo($detailid, true);
		return ($dinfo['b_name'] != $dinfo['a_name'] || $dinfo['b_xml'] != $dinfo['a_xml']
				|| $dinfo['b_view_type_id'] != $dinfo['a_view_type_id']
				|| $dinfo['b_data_type_id'] != $dinfo['a_data_type_id']
				|| $dinfo['b_data_length'] != $dinfo['a_data_length']
				|| $dinfo['b_data_decimal_places'] != $dinfo['a_data_decimal_places']
				|| $dinfo['b_default_value'] != $dinfo['a_default_value']
				|| $dinfo['b_list'] != $dinfo['a_list']
				|| $dinfo['b_essential'] != $dinfo['a_essential']
				|| $dinfo['b_detail_display'] != $dinfo['a_detail_display']
				|| $dinfo['b_detail_target'] != $dinfo['a_detail_target']
				|| $dinfo['b_scope_search'] != $dinfo['a_scope_search']
				|| $dinfo['b_nondisplay'] != $dinfo['a_nondisplay']
				|| $dinfo['b_weight'] != $dinfo['a_weight']);
	}

	private function getViewTypeList($view_type) {
		$viewtypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', $this->dirname, $this->trustDirname);
		$viewtypes = $viewtypeBean->getViewtypeList();
		$viewtypelist = array(array('viewtype_id' => '0', 'name' => '-------------'));
		foreach ($viewtypes as $vt) {
			$viewtype['viewtype_id'] = $vt['view_type_id'];
			$viewtype['name'] = $vt['name'];
			$viewtype['selected'] = ($vt['view_type_id'] == $view_type) ? 'selected="selected"' : '';
			$viewtypelist[] = $viewtype;
		}
		return $viewtypelist;
	}

	private function getDataTypeList($view_type, $data_type, &$selected_datatype_name, &$scope_search, &$scope_search_arr) {
		$datatypeBean = Xoonips_BeanFactory::getBean('DataTypeBean', $this->dirname, $this->trustDirname);
		$datatypes = $datatypeBean->selectDatatypesByViewtype($view_type);
		$datatypelist = array(array('datatype_id' => '0', 'name' => '-------------'));
		foreach ($datatypes as $dt) {
			$datatype['datatype_id'] = $dt['data_type_id'];
			$datatype['name'] = $dt['name'];
			$datatype['data_length'] = $dt['data_length'];
			$datatype['data_decimal_places'] = $dt['data_decimal_places'];
			$datatype['selected'] = ($dt['data_type_id'] == $data_type) ? 'selected="selected"' : '';
			if ($datatype['selected'] != '') {
				$selected_datatype_name = $dt['name'];
			}
			$datatypelist[] = $datatype;
		}

		// scope_search contral
		if (intval($data_type) == $datatypeBean->selectByName('char')
				|| intval($data_type) == $datatypeBean->selectByName('varchar')
				|| intval($data_type) == $datatypeBean->selectByName('text')
				|| intval($data_type) == $datatypeBean->selectByName('blob')) {
			$scope_search = '';
			$scope_search_arr = "disabled='disabled'";
		} else {
			$scope_search_arr = '';
		}
		return $datatypelist;
	}

	protected function doComplement(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$select = $request->getParameter('select');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_COMPLEMENT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_COMPLEMENT_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		$baseDetailId=0;
		$groupId=0;
		$relation['detail'] = array();
		$itemtype['detail'] = array();
		$basecomplementlist = array();
		$complementBean = Xoonips_BeanFactory::getBean('ComplementBean', $this->dirname, $this->trustDirname);
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$linkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		if (isset($select) && $select != '') {
			$temp = explode(',', $select);
			$relaId = $temp[0];
			$baseDetailId = $temp[1];
			$groupId = $temp[2];
			$detailrelation = $linkBean->getInfoByItemtypeIdAndComplementId($itemtypeid, $relaId, $baseDetailId, $groupId);

			$relationdetail = $complementBean->getComplementDetailInfo($relaId);
			foreach ($relationdetail as $vars) {
				$relation['detail'][] = array(
			   		'complement_detail_id' => $vars['complement_detail_id'],
					'item_field_detail_id' => '',
					'group_id' => '',
					'title' => $vars['title']
				);
			}
			if (count($detailrelation) > 0) {
				// complement detail
				$relationdetail = $linkBean->getComplementDetailAndDetailLink($relaId, $baseDetailId, $groupId);

				foreach ($relationdetail as $vars) {
					foreach ($relation['detail'] as &$detail) {
						if ($detail['complement_detail_id'] == $vars['complement_detail_id']) {
							$detail['item_field_detail_id'] = $vars['item_field_detail_id'];
							$detail['group_id'] = $vars['group_id'];
						}
					}
				}
			}

			// detail list
			$detaillist = $groupBean->getDetailList($base_itemtypeid, $baseDetailId);

			$itemtype['detail'][] = array(
		    	'detail_id' => '',
		    	'group_id' => '',
				'title' => '--------------',
			);

			foreach ($detaillist as $vars) {
				$itemtype['detail'][] = array(
			      	'detail_id' => $vars['item_field_detail_id'],
			      	'group_id' => $vars['group_id'],
					'title' => $vars['group_name'] . ' : ' . $vars['detail_name']
				);
			}

			$detailInfo = $detailBean->getDetailEditInfo($baseDetailId, true);
			$detailrelation = $linkBean->getInfoByItemtypeIdAndComplementId($base_itemtypeid, $relaId, $detailInfo['b_item_field_detail_id']);
			if (count($detailrelation) == 0) {
				// relation detail
				$relationdetail = $complementBean->getComplementDetailInfo($relaId);
				foreach ($relationdetail as $vars) {
					$basecomplementlist[$vars['complement_detail_id']]['detail_id'] = '';
				}
			} else {
				// complement detail
				$relationdetail = $linkBean->getComplementDetailAndDetailLink($relaId, $detailInfo['b_item_field_detail_id']);
				foreach ($relationdetail as $vars) {
					$basecomplementlist[$vars['complement_detail_id']]['detail_id'] = $vars['item_field_detail_id'];
				}
			}
			$detaillist = $groupBean->getDetailList($base_itemtypeid, $detailInfo['b_item_field_detail_id']);
			foreach ($detaillist as $vars) {
				foreach ($basecomplementlist as &$basecomplement) {
					if ($basecomplement['detail_id'] == $vars['item_field_detail_id']) {
						$basecomplement['title'] = $vars['group_name'] . ' : ' . $vars['detail_name'];
					}
				}
			}
		}

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtypeName = $itmtypeBean->getItemTypeName($itemtypeid);

		// relation list
		$relationlist = $complementBean->getComplementList($base_itemtypeid);

		$itemtype['relation'] = array();
		$itemtype['relation'][] = array(
		    'complement_id' => '',
		    'title' => '--------------',
		    'selected' => ''
		);
		foreach ($relationlist as $vars) {
			$itemtype['relation'][] = array(
		    	'complement_id' => $vars['complement_id'] . ',' . $vars['item_field_detail_id'] . ',' . $vars['group_id'],
		    	'title' => $vars['group_name'] . ' : ' . $vars['detail_name'],
		    	'selected' => ($vars['item_field_detail_id'] == $baseDetailId && $vars['group_id'] == $groupId) ? 'selected="selected"' : ''
		    );
		}

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_relation'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['itemtypename'] = $itemtypeName;
		$viewData['relationlist'] = $itemtype['relation'];
		$viewData['detaillist'] = $itemtype['detail'];
		$viewData['relationdetaillist'] = $relation['detail'];
		$viewData['basecomplementlist'] = $basecomplementlist;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('complement_success');
		return true;
	}

	protected function doComplementsave(&$request, &$response) {

		// check token ticket
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemtype_relation'))) {
			return false;
		}

		// get requests
		$request = new Xoonips_Request();
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');
		$selectid = $request->getParameter('selectid');
		$selectdetailids = $request->getParameter('selectdetailid');

		// drelation message
		$drelation_msg = _AM_XOONIPS_POLICY_ITEMTYPE_RELATION_MSG_SUCCESS;

		// do relation
		if (!$this->insItemtypeDetailRelation($itemtypeid, $selectid, $selectdetailids)) {
			$drelation_msg = _AM_XOONIPS_POLICY_ITEMTYPE_RELATION_MSG_FAILURE;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
		$viewData['redirect_msg'] = $drelation_msg;
		$response->setViewData($viewData);
		$response->setForward('complementsave_success');
		return true;
	}

	private function isComplementDiff($itemtypeid, $base_itemtypeid) {
		$fieldDetails = array();
		$baseFieldDetails = array();

		// complement list
		$complinkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		$complementlist = $complinkBean->getFieldDetailComplementByItemtypeId($itemtypeid);
		foreach ($complementlist as $vars) {
			$fieldDetails[] = array(
		    	'complement_id' => $vars['complement_id'],
				'item_field_detail_id' => $vars['item_field_detail_id'],
		    	'update_id' => $vars['update_id'],
			);
		}
		// complement list
		$complementlist = $complinkBean->getFieldDetailComplementByItemtypeId($base_itemtypeid);
		foreach ($complementlist as $vars) {
			$baseFieldDetails[] = array(
		    	'complement_id' => $vars['complement_id'],
				'item_field_detail_id' => $vars['item_field_detail_id'],
		    	'seq_id' => $vars['seq_id'],
			);
		}

		if (count($fieldDetails) != count($baseFieldDetails)) {
			return true;
		}

		foreach ($fieldDetails as $fieldDetail) {
			$diffflag = true;
			foreach ($baseFieldDetails as $baseFieldDetail) {
				if ($fieldDetail['complement_id'] == $baseFieldDetail['complement_id']) {
					if ($fieldDetail['update_id'] == $baseFieldDetail['seq_id']
					&& $fieldDetail['item_field_detail_id'] != $baseFieldDetail['item_field_detail_id']) {
							return true;
					}

					$diffflag = false;
				}
			}
			if ($diffflag) {
				return true;
			}
		}
		return false;
	}

	private function isComplementDetailDiff($itemtypeid, $base_itemtypeid, $relaId, $baseDetailId) {
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$linkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);

		$complementlist = array();
		$basecomplementlist = array();
		$detailrelation = $linkBean->getInfoByItemtypeIdAndComplementId($itemtypeid, $relaId, $baseDetailId);
		if (count($detailrelation) > 0) {
			// complement detail
			$relationdetail = $linkBean->getComplementDetailAndDetailLink($relaId, $baseDetailId);
			foreach ($relationdetail as $vars) {
				$complementlist[$vars['complement_detail_id']]['detail_id'] = $vars['item_field_detail_id'];
			}

			// detail list
			$detaillist = $groupBean->getDetailList($itemtypeid, $baseDetailId);
			foreach ($detaillist as $vars) {
				foreach ($complementlist as &$complement) {
					if ($complement['detail_id'] == $vars['item_field_detail_id']) {
						$complement['title'] = $vars['group_name'] . ' : ' . $vars['detail_name'];
					}
				}
			}
		}

		$detailInfo = $detailBean->getDetailEditInfo($baseDetailId, true);
		$detailrelation = $linkBean->getInfoByItemtypeIdAndComplementId($base_itemtypeid, $relaId, $detailInfo['b_item_field_detail_id']);
		if (count($detailrelation) > 0) {
			// complement detail
			$relationdetail = $linkBean->getComplementDetailAndDetailLink($relaId, $detailInfo['b_item_field_detail_id']);
			foreach ($relationdetail as $vars) {
				$basecomplementlist[$vars['complement_detail_id']]['detail_id'] = $vars['item_field_detail_id'];
			}

			$detaillist = $groupBean->getDetailList($base_itemtypeid, $detailInfo['b_item_field_detail_id']);
			foreach ($detaillist as $vars) {
				foreach ($basecomplementlist as &$basecomplement) {
					if ($basecomplement['detail_id'] == $vars['item_field_detail_id']) {
						$basecomplement['title'] = $vars['group_name'] . ' : ' . $vars['detail_name'];
					}
				}
			}
		}

		if (count($complementlist) != count($basecomplementlist)) {
			return true;
		}

		foreach ($complementlist as $key => $complement) {
			$diffflag = true;
			foreach ($basecomplementlist as $basekey => $basecomplement) {
				if ($key == $basekey) {
					if ($complement['title'] != $basecomplement['title']) {
						return true;
					} else {
						$diffflag = false;
					}
				}
			}
			if ($diffflag) {
				return true;
			}
		}
		return false;
	}

	// get subtypes
	private function getSubtypes($itemtypeId) {
		$detailbean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		$filetypelist = $detailbean->getFileTypeList( $itemtypeId );
		$ret = '';
		$int = 1;
		foreach($filetypelist as $filetype) {
			if ($int <> 1) {
				$ret .= " / ";
			}
			$ret .= $filetype['title'];
			$int++;
		}
		return $ret;
	}

	// insert itemtype
	function insertXoonipsItemtype( &$itemtype_id, $name, $order, $descrip, $template, $icon ) {

		$itemtype_info = array();
		$itemtype_info['preselect'] = 0;
		$itemtype_info['released'] = 0;
		$itemtype_info['weight'] = $order;
		$itemtype_info['name'] = $name;
		$itemtype_info['description'] = $descrip;
		$itemtype_info['icon'] = NULL;
		$itemtype_info['mime_type'] = NULL;
		$itemtype_info['template'] = $template;
		$itemtype_info['update_id'] = NULL;
		$fileRandName = time();
		if ( !empty( $icon ) ) {
			$itemtype_info['icon'] = "icon_" . $fileRandName . "." . end(explode(".", $icon['name']));
			$itemtype_info['mime_type'] = $icon['type'];
		}
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		if ( !$itemtypeBean->insert($itemtype_info, $itemtype_id) ) return false;
		if ( empty( $icon ) ) return true;

		$uploadDir = XOOPS_ROOT_PATH . "/modules/xoonips/images";
		$uploadfile = $uploadDir . "/" . "icon_" . $fileRandName . "." . end(explode(".", $icon['name']));
		if( !move_uploaded_file( $icon['tmp_name'], $uploadfile) ) {
			return false;
		}
		return true;
	}

	// insert default itemtype group and detail
	private function insertXoonipsItemtypeGroupAndDetail( $itemtype_id ) {

		$typeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);

		$defaultGroups = $groupBean->getDefaultItemTypeGroup();
		foreach($defaultGroups as $group) {
			// insert default itemtype group
			$lgroup['item_type_id'] = $itemtype_id;
			$lgroup['group_id'] = $group['group_id'];
			$lgroup['weight'] = $group['weight'];
			$lgroup['edit_weight'] = $group['weight'];
			$lgroup['edit'] = 1;
			$lgroup['released'] = 0;
			if ( !$typeBean->insertLink($lgroup, $insertId) ) return false;
		}
		return true;
	}

	private function doCopyItemtype( $itemtypeid, $isCopy = false ) {
		$map = array();
		if ($isCopy) {
			$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
			if (!$itemtypeBean->copyById($itemtypeid, $map, false, false, true)) return false;

			if (!$itemtypeBean->copyLinkById($itemtypeid, $map)) return false;
			
			$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);
			if (!$relationBean->copyById($itemtypeid, $map, false, false, true)) return false;
		}
		else
		{
			$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
			if (!$itemtypeBean->copyById($itemtypeid, $map, true)) return false;

			$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);
			if (!$relationBean->copyById($itemtypeid, $map, true, false, true)) return false;
		}
		return true;
	}

	// update itemtype
	private function updateXoonipsItemtype( $itemtype_id, $name, $order, $descrip, $template, $icon, $isRelease = false) {

		$itemtype_info = array();
		$itemtype_info['weight'] = $order;
		$itemtype_info['name'] = $name;
		$itemtype_info['description'] = $descrip;
		$itemtype_info['template'] = $template;
		if ($isRelease) {
			$itemtype_info['released'] = 1;
		}
		else
		{
			$itemtype_info['released'] = 0;
		}

		$hasIcon = false;
		$fileRandName = time();
		if ( !empty( $icon ) ) {
			$itemtype_info['icon'] = "icon_" . $fileRandName .  "." . end(explode(".", $icon['name']));
			$itemtype_info['mime_type'] = $icon['type'];
			$hasIcon = true;
		}
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		if ( !$itemtypeBean->update($itemtype_info, $itemtype_id, $hasIcon) ) return false;
		if ( empty( $icon ) ) return true;

		$uploadDir = XOOPS_ROOT_PATH . "/modules/xoonips/images";
		$uploadfile = $uploadDir . "/" . "icon_" . $fileRandName .  "." . end(explode(".", $icon['name']));
		if( !move_uploaded_file( $icon['tmp_name'], $uploadfile) ) {
			return false;
		}
		return true;
	}

	// update group weight
	private function updateXoonipsItemtypeGroupOrder($typeid, $gids, $orders) {

		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		//update display order
		foreach ( $gids as $key =>$id) {
			if($orders[$key]!= $key+1){
				if (!$itemtypeBean->updateWeightForLink($typeid, $id, $key+1)) return false;
			}
		}
		return true;
	}

	private function doImportItemtype( $itemtypeObj, $groupObj, $detailObj, $relationObj ) {

		$map = array();
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		if (!$itemtypeBean->copyByObj($itemtypeObj, $map, false, true, false)) return false;

		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		if (!$groupBean->copyByObj($groupObj, $map, false, true)) return false;

		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		if (!$detailBean->copyByObj($detailObj, $map, false, true)) return false;

		$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);
		if (!$relationBean->copyByObj($relationObj, $map, false, true)) return false;

		// create extend table
		if (!$this->createItemExtendTable($map['itemtype'][$itemtypeObj['item_type_id']])) return false;

		return true;
	}

	// create extend table
	private function createItemExtendTable($itemtype_id, $isRelease = false){
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		if ($isRelease){
			$newDetails = $detailBean->getNewItemTypeDetail( $itemtype_id );
			if (!$detailBean->createExtendTable($newDetails)) return false;
		} else {
			$detailObj = $detailBean->getReleasedDetail( $itemtype_id );
			if (!$detailBean->createExtendTable($detailObj)) return false;
		}
		return true;
	}

	private function deleteAll($itemtypeid) {

		// delete item_type
		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		if (!$itemtypeBean->delete($itemtypeid)) {
			echo "failure in delete item_type";
			return false;
		}

		// delete item_field_detail_complement_link
		$linkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		if (!$linkBean->deleteByItemtypeId($itemtypeid)) {
			echo "failure in delete item_field_detail_complement_link";
			return false;
		}

		// delete item_type_sort
		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortDetailBean', $this->dirname, $this->trustDirname);
		if (!$sortBean->deleteByItemtypeId($itemtypeid)) {
			echo "failure in delete item_type_sort_detail";
			return false;
		}

		// delete item_type_search_condition_detail
		$conditionBean = Xoonips_BeanFactory::getBean('ItemTypeSearchConditionDetailBean', $this->dirname, $this->trustDirname);
		if (!$conditionBean->deleteByItemtypeId(null, $itemtypeid)) {
			echo "failure in delete item_type_search_condition_detail";
			return false;
		}

		// delete oaipmh_schema_itemtype_link
		$oaipmhBean = Xoonips_BeanFactory::getBean('OaipmhSchemaItemtypeLinkBean', $this->dirname, $this->trustDirname);
		if (!$oaipmhBean->delete(null, $itemtypeid)) {
			echo "failure in delete oaipmh_schema_itemtype_link";
			return false;
		}
		return true;
	}

	// release itemtype
	private function releaseXoonipsItemtype($base_itemtypeid, $itemtype_id) {

		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		if ($base_itemtypeid == $itemtype_id) {
			$info = $itemtypeBean->getItemType($itemtype_id);
			$info['released'] = 1;
			if (!$itemtypeBean->update($info, $itemtype_id, false)) {
				return false;
			}
		} else {
			// itemtype data
			if (!$itemtypeBean->updateCopyToBase($itemtype_id)) {
				return false;
			}
		}

		// itemtype group data
		if (!$itemtypeBean->updateLinkSync($base_itemtypeid, true)) {
			return false;
		}

		// itemtype detail relation data
		$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		if (!$relationBean->updateNewDetailRelation($base_itemtypeid, $itemtype_id)) {
			return false;
		}
		if (!$relationBean->updateCopyToBaseDetailRelation($itemtype_id)) {
			return false;
		}

		// delete copy data
		if (!$itemtypeBean->deleteCopyItemtype($itemtype_id)) {
			return false;
		}

		if (!$relationBean->deleteCopyItemtypeDetailRelation($itemtype_id)) {
			return false;
		}

		return true;
	}

	// delete templates_c file
	private function deleteTemplatesFile($itemtypeId) {
		$reg = '/itemtype%3A' . $itemtypeId . '/';

		$fpath = XOOPS_COMPILE_PATH;
		$fileNames = scandir($fpath);
		if(!$fileNames){
			return false;
		}
		foreach($fileNames as $fileName){
			if(preg_match($reg, $fileName, $matches)==1){
				unlink(XOOPS_COMPILE_PATH."/".$fileName);
				break;
			}
		}
		return true;
	}

	private function getItemtypeInfoXML( $fhdl, $itemtype_id ) {
		$myts =& MyTextSanitizer::getInstance();

		$itemtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$itemtype = $itemtypeBean->getItemType( $itemtype_id );
		if ( !$itemtype ) return false;

		$itemtypeInfo = "<itemtype id=\"$itemtype_id\">\n";
		foreach($itemtype as $key=>$value) {
			$itemtypeInfo .= "<$key>".$myts->htmlSpecialChars($value)."</$key>\n";
		}

		// itemtype xml
		if ( !$this->writefile( $fhdl, $itemtypeInfo ) ) return false;

		// itemtype group xml
		if ( !$this->getItemtypeGroupInfoXML( $fhdl, $itemtype_id) ) return false;

		// itemtype relation detail xml
		if ( !$this->getRelationDetailInfoXML( $fhdl, $itemtype_id) ) return false;

		// itemtype foot
		if ( !fwrite( $fhdl, "</itemtype>\n" ) ) return false;

		return true;
	}

	// get itemtype group XML
	private function getItemtypeGroupInfoXML( $fhdl, $itemtype_id ) {
		$myts =& MyTextSanitizer::getInstance();

		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		$groups = $groupBean->getItemTypeGroups( $itemtype_id );
		if ( !$groups ) return false;

		foreach( $groups as $group ) {
			$groupInfo = "<group id=\"".$group['group_id']."\">\n";
			foreach( $group as $key=>$value ) {
				$groupInfo .= "<$key>".$myts->htmlSpecialChars($value)."</$key>\n";
			}
			if ( !$this->writefile( $fhdl, $groupInfo ) ) return false;

			if ( !$this->getItemtypeDetailInfoXML( $fhdl, $group['group_id'] ) ) return false;

			if ( !fwrite( $fhdl, "</group>\n") ) return false;
		}
		return true;
	}

	// get itemtype detail XML
	private function getItemtypeDetailInfoXML( $fhdl, $group_id ) {
		$myts =& MyTextSanitizer::getInstance();

		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		$details = $detailBean->getItemTypeGroupDetail( $group_id );
		if ( !$details ) return false;

		foreach ( $details as $detail ) {
			$detailInfo = "<detail id=\"".$detail['item_field_detail_id']."\">\n";
			foreach( $detail as $key=>$value ) {
				$detailInfo .= "<$key>".$myts->htmlSpecialChars($value)."</$key>\n";
			}
			$detailInfo .= "</detail>\n";
			if ( !$this->writefile( $fhdl, $detailInfo ) ) return false;
		}
		return true;
	}

	// get itemtype relation detail XML
	private function getRelationDetailInfoXML($fhdl, $itemtype_id) {
		$myts =& MyTextSanitizer::getInstance();

		$complementBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		$complements = $complementBean->getFieldDetailComplementByItemtypeId($itemtype_id);
		if ($complements === false) return false;

		foreach ($complements as $complement) {
			$relaInfo = "<relation id=\"" . $complement['seq_id'] . "\">\n";
			foreach ($complement as $key => $value) {
				$relaInfo .= "<$key>" . $myts->htmlSpecialChars($value) . "</$key>\n";
			}
			$relaInfo .= "</relation>\n";
			if (!$this->writefile($fhdl, $relaInfo)) return false;
		}
		return true;
	}

	private function writefile($fhdl,$info){
		$info2 =  Xoonips_Utils::encodeUtf8($info, Xoonips_Utils::getServerCharset(), true);
		return fwrite($fhdl,$info2);
	}

	private function doGroupregistersaveInputCheck($itemtypeid, $name, $xml, &$errors){
		// group name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_GROUP_NAME;
		if ($name=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupName(0, $name)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		// group xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_XML_TAG;
		if ($xml=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupXml(0, $xml)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		return true;
	}

	// insert itemtype group
	private function insertXoonipsItemtypeGroup( $itemtypeid, $name, $xml, $occurrence ) {
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		$maxOrder = $groupBean->getMaxGroupWeight($itemtypeid);

		$group_info = array();
		$group_info['preselect'] = 0;
		$group_info['released'] = 0;
		$group_info['item_type_id'] = $itemtypeid;
		$group_info['name'] = $name;
		$group_info['xml'] = $xml;
		$group_info['weight'] = $maxOrder + 1;
		$group_info['occurrence'] = $occurrence=='' ? 0 : $occurrence;
		$group_info['update_id'] = NULL;
		$new_group_id = 0;
		return $groupBean->insert($group_info, $new_group_id);
	}

	private function doGroupeditsaveInputCheck($itemtypeid, $group_id, $name, $xml, &$errors){
		// group name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_GROUP_NAME;
		if ($name=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupName($group_id, $name)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		// group xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_XML_TAG;
		if ($xml=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupXml($group_id, $xml)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		return true;
	}

	// update group
	private function updateXoonipsItemtypeGroup( $groupid, $name, $xml, $occurrence ) {
		$group_info = array();
		$group_info['name'] = $name;
		$group_info['xml'] = $xml;
		$group_info['occurrence'] = $occurrence=='' ? 0 : $occurrence;

		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		return $groupBean->update($group_info, $groupid);
	}

	// update detail weight
	private function updateXoonipsItemtypeDetailOrder( $dids, $orders ) {

		if ($dids == '') return true;
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		//update display order
		foreach ( $dids as $key =>$id) {
			if($orders[$key]!= $key+1){
				if (!$detailBean->updateWeight($id, $key+1)) return false;
			}
		}
		return true;
	}

	private function deleteGroupAll( $groupid ) {

		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean',$this->dirname,$this->trustDirname);
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
		$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);

		// delete relation detail
		$details = $detailBean->getItemTypeGroupDetail( $groupid );
		foreach($details as $detail){
			if ( !$relationBean->deleteByBothDetailId( $detail['item_field_detail_id'] ) ) return false;
		}

		// delete detail
		if ( !$detailBean->deleteByGroupId( $groupid ) ) return false;

		// delete group
		if ( !$groupBean->delete( $groupid ) ) return false;

		return true;
	}

	private function doDetailregistersaveInputCheck($itemtypeid, $group_id, $inputData, &$errors){
		// detail name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DETAIL_NAME;
		$viewTypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', $this->dirname, $this->trustDirname);
		$dataTypeBean = Xoonips_BeanFactory::getBean('DataTypeBean', $this->dirname, $this->trustDirname);

		if ($inputData['name']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// name double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
				if ($detailBean->existDetailName(0, $inputData['name'], 0)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// detail xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_XML_TAG;
		if ($inputData['xml']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// xml double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailXml(0, $inputData['xml'], 0)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// view_type
		if ($inputData['view_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_VIEW_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
			$viewtypeObj =Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $inputData['view_type'] );
			if ($viewtypeObj->isMulti()==false && $detailBean->existViewtype(0, $inputData['view_type'])){
				$parameters = array();
				$parameters[] = "";
				$errors->addError("_AM_XOONIPS_POLICY_ITEMTYPE_VIEWTYPE_DUPLICATE_MSG", "", $parameters);
			}
		}

		// data_type
		if ($inputData['data_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// list required when view_type is radio & select
		if (($inputData['view_type'] == $viewTypeBean->selectByName('radio') || $inputData['view_type'] == $viewTypeBean->selectByName('checkbox')) && $inputData['list'] == '') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_SUBTYPES;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length
		if ($inputData['length'] == '') {
			if ($inputData['data_type'] == $dataTypeBean->selectByName('int')) {
				$inputData['length'] = 11;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('float')) {
				$inputData['length'] = 24;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('double')) {
				$inputData['length'] = 53;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('varchar')) {
				$inputData['length'] = 255;
			} elseif ($inputData['data_type'] != $dataTypeBean->selectByName('char')) {
				$inputData['length'] = -1;
			}
		}
		if ($inputData['length']!='' && !is_numeric($inputData['length'])) {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length2
		if ($inputData['length2'] == '') {
			if ($inputData['data_type'] == $dataTypeBean->selectByName('float') || $inputData['data_type'] == $dataTypeBean->selectByName('double')) {
				$inputData['length2'] = 0;
			} else {
				$inputData['length2'] = -1;
			}
		}
		if ($inputData['length2']!='' && !is_numeric($inputData['length2'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH2;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		else
		{
			// 'value' colmun attribute check
			$item = new Xoonips_ItemField();
			$item->setLen($inputData['length']);
			$item->setDecimalPlaces($inputData['length2']);
			$item->setDefault($inputData['default']);
			$datatypeObj = Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($inputData['data_type']);
			$datatypeObj->valueAttrCheck($item, $errors);
			if (count($errors->getErrors()) > 0) {
				return false;
			}
		}
		return true;
	}

	// get list block view
	private function getDetailregisterListBlock( $view_type, $list ){
		if ( empty($view_type) ) {
			return $this->getListBlockHtml( $view_type );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getListBlockView( $list );
	}

	// get default value block view
	private function getDetailregisterDefaultValutBlock( $view_type, $list, $default_value ){
		if ( empty($view_type) ) {
			return $this->getDefaultListBlockHtml( $default_value );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getDefalutValueBlockView( $list, $default_value );
	}

	private function doDetaileditsaveInputCheck($itemtypeid, $group_id, $detailid, $inputData, &$errors){
		// detail name
		$viewTypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', $this->dirname, $this->trustDirname);

		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DETAIL_NAME;
		if ($inputData['name']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// name double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailName($detailid, $inputData['name'], '')) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// detail xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_XML_TAG;
		if ($inputData['xml']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// xml double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailXml($detailid, $inputData['xml'], '')) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// view_type
		if ($inputData['view_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_VIEW_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean',$this->dirname,$this->trustDirname);
			$viewtypeObj =Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $inputData['view_type'] );
			if ($viewtypeObj->isMulti()==false && $detailBean->existViewtype($detailid, $inputData['view_type'], '')){
				$parameters = array();
				$parameters[] = "";
				$errors->addError("_AM_XOONIPS_POLICY_ITEMTYPE_VIEWTYPE_DUPLICATE_MSG", "", $parameters);
			}
		}

		// data_type
		if ($inputData['data_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// list required when view_type is radio & select
		if (($inputData['view_type'] == $viewTypeBean->selectByName('radio') || $inputData['view_type'] == $viewTypeBean->selectByName('select')) && $inputData['list']=='') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_SUBTYPES;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length
		if ($inputData['length']!='' && !is_numeric($inputData['length'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH;
			$errors->addError("_AM_XOONIPS_CHECK_INPUT_ERROR_MSG", "", $parameters);
		}

		// length2
		if ($inputData['length2']!='' && !is_numeric($inputData['length2'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH2;
			$errors->addError("_AM_XOONIPS_CHECK_INPUT_ERROR_MSG", "", $parameters);
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		else
		{
			// 'value' colmun attribute check
			$item = new Xoonips_ItemField();
			$item->setLen($inputData['length']);
			$item->setDecimalPlaces($inputData['length2']);
			$item->setDefault($inputData['default']);
			$datatypeObj = Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($inputData['data_type']);
			$datatypeObj->valueAttrCheck($item, $errors);
			if (count($errors->getErrors()) > 0) {
				return false;
			}
		}
		return true;
	}

	// get list block view
	private function getDetaileditListBlock( $view_type, $list, $disabled_arr ){
		if ( empty($view_type) ) {
			return $this->getListBlockHtml( $view_type );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getListBlockView( $list, $disabled_arr );
	}

	// get default value block view
	private function getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr ){
		if ( empty($view_type) ) {
			return $this->getDefaultListBlockHtml( $default_value );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getDefalutValueBlockView( $list, $default_value, $disabled_arr );
	}

	private function getListBlockHtml( $view_type ){
		$root =& XCube_Root::getSingleton();
		$root->mContext->mModule->setAdminMode(true);
		$controller = $root->getController();
		$render =$controller->mRoot->mContext->mModule->getRenderTarget();
		$render->setTemplateName('policy_itemtype.inc.html');
		$render->setAttribute('flg', true);
		$render->setAttribute('value', $view_type);
		$renderSystem =$controller->mRoot->getRenderSystem($controller->mRoot->mContext->mModule->getRenderSystemName());
		$renderSystem->renderMain($render);
		$ret = $render->getResult();
		return $ret;
	}

	private function getDefaultListBlockHtml( $default_value ){
		$root =& XCube_Root::getSingleton();
		$root->mContext->mModule->setAdminMode(true);
		$controller = $root->getController();
		$render =$controller->mRoot->mContext->mModule->getRenderTarget();
		$render->setTemplateName('policy_itemtype.inc.html');
		$render->setAttribute('flg', false);
		$render->setAttribute('value', $default_value);
		$renderSystem =$controller->mRoot->getRenderSystem($controller->mRoot->mContext->mModule->getRenderSystemName());
		$renderSystem->renderMain($render);
		$ret = $render->getResult();
		return $ret;
	}

	private function deleteDetailAll($detailid) {

		// delete relation detail
		$relationBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		if (!$relationBean->deleteByBothDetailId($detailid)) return false;

		// delete detail
		$detailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
		if (!$detailBean->delete($detailid)) return false;

		return true;
	}

	private function insItemtypeDetailRelation($itemtypeid, $selectid, $selectdetailids) {

		if (isset($selectid) && $selectid != '') {
			$temp = explode(',', $selectid);
			$complementid = $temp[0];
			$baseid = $temp[1];
			$groupid = $temp[2];
		}

		$linkBean = Xoonips_BeanFactory::getBean('ItemFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		foreach ($selectdetailids as $ids) {
			$temp = explode(',', $ids);
			$comDetailId = $temp[0];
			$itemFieldDetailId = $temp[1];

			if ($itemFieldDetailId == '') continue;

			$link_info = array(
			'released' => 0,
			'complement_id' => $complementid,
			'item_type_id' => $itemtypeid,
			'base_item_field_detail_id' => $baseid,
			'complement_detail_id' => $comDetailId,
			'item_field_detail_id' => $itemFieldDetailId,
			'update_id' => 0,
			'group_id' => $groupid,
			);
			if (!$linkBean->update($link_info)) {
				echo "failure in update item_field_detail_complement_link";
				return false;
			}
		}

		return true;
	}

	protected function doGroupregisterng(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName($itemtypeid);

		// get itemtype group list
		$members = $itmtypeBean->getTypeGroups($base_itemtypeid);

		// get groups for select
		$groups = $this->getGroupsForSelect(1, $members);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemtype_group_register'));

		// get common viewdata
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['itemtypeid'] = $itemtypeid;
		$viewData['itemtype_name'] = $itemtype_name;
		$viewData['base_itemtypeid'] = $base_itemtypeid;
		$viewData['groups'] = $groups;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('groupregisterng_success');
		return true;
	}

	protected function doGroupregisterngsave(&$request, &$response) {

		// get requests
		$itemtypeid = $request->getParameter('itemtypeid');
		$base_itemtypeid = $request->getParameter('base_itemtypeid');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setGroupBreadcrumbs($title, $base_itemtypeid);

		// itemtype name
		$itmtypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$itemtype_name = $itmtypeBean->getItemTypeName( $itemtypeid );

		// get groups info
		$groups = array();
		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$count = $groupBean->countItemgroups();
		$groups_objs = $groupBean->getItemgrouplist($count, 0);

		foreach ($groups_objs as $itemgroup) {
			$itemgroupid = $itemgroup['group_id'];
			if ($request->getParameter('checkbox_'.$itemgroupid) || $itemgroup['preselect'] == 1) {
				$groups[] = $itemgroupid;
			}
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_itemtype_group_register') ) ) {
			return false;
		}

		// update link of type and group
		if ( !$this->updateTypeGroupLink($base_itemtypeid, $groups) ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('groupregisterngsave_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemtype.php?'.'op=edit&itemtypeid='.$base_itemtypeid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_SELECT_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('groupregisterngsave_success');
		return true;
	}

	// update link of type and group
	private function updateTypeGroupLink($typeid, $gids) {

		$typeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$groupInfos = $typeBean->getTypeGroups($typeid);

		// update set 0 at all cloumn of edit
		foreach ($groupInfos as $group) {
			$typeBean->updateLinkEdit($typeid, $group['group_id'], 0);
		}

		foreach ($gids as $id) {
			$insert_chk = true;
			foreach ($groupInfos as $group) {
				if ($group['group_id'] == $id) {
					$insert_chk = false;
					break;
				}
			}
			if ($insert_chk) {
				$info = array('item_type_id'=>$typeid,
				'group_id'=>$id,
				'weight'=>255,
				'edit'=>1,
				'edit_weight'=>255,
				'released'=>0);
				$typeBean->insertLink($info, $insertId);
			} else {
				$typeBean->updateLinkEdit($typeid, $id, 1);
			}
		}

		return true;
	}

	private function isGroupLinkDiff($typeid) {
		$typeBean = Xoonips_BeanFactory::getBean('ItemTypeBean',$this->dirname,$this->trustDirname);
		$groupInfos = $typeBean->getTypeGroups($typeid);
		foreach ($groupInfos as $group) {
			if ($group['edit'] != $group['link_release']
			|| $group['edit_weight'] != $group['weight']) {
				return true;
			}
		}
		return false;
	}

	// get groups for select
	private function getGroupsForSelect($mode=1, $members=array()) {
		$groups = array();

		$groupBean = Xoonips_BeanFactory::getBean('ItemFieldGroupBean', $this->dirname, $this->trustDirname);
		$count = $groupBean->countItemgroups();
		$groups_objs = $groupBean->getItemgrouplist($count, 0);

		foreach ($groups_objs as $itemgroup) {
			if ($itemgroup['released'] == 0) {
				continue;
			}
			$group_id = $itemgroup['group_id'];
			$name = $itemgroup['name'];
			$xml = $itemgroup['xml'];
			$preselect = $itemgroup['preselect'];
			$select = 0;

			if ($mode == 0) {
				if ($preselect == 1) {
					$select = 1;
				}
			} else {
				foreach ($members as $member) {
					if ($member['group_id'] == $group_id
					&& $member['edit'] == 1){
						$select = 1;
					}
				}
			}

			$groups[] = array(
			    'groupid' => $group_id,
			    'name' => $name,
			    'xml' => $xml,
				'select' => $select,
				'preselect' => $preselect
			);
		}

		return $groups;
	}

}

