<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class Xoonips_MaintenanceFileSearchAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {
		
		//title
		$title = _AM_XOONIPS_MAINTENANCE_FILESEARCH_TITLE;
		$description = _AM_XOONIPS_MAINTENANCE_FILESEARCH_DESC;
		
		// breadcrumbs
		$breadcrumbs = array(
		  array(
		    'name' => _AM_XOONIPS_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
		  ),
		  array(
		    'name' => _AM_XOONIPS_MAINTENANCE_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/maintenance.php',
		  ),
		  array(
		    'name' => $title,
		  ),
		);
		
		function filesearch_adddot($str) {
			return '.'.$str;
		}
		
		$xoonipsFile = new Xoonips_File($this->dirname, $this->trustDirname, true);
		$modules = $xoonipsFile->fsearch_plugins;
		$plugins = array();
		$evenodd = 'odd';
		foreach ($modules as $module) {
			$plugin['plugin'] = $module['display_name'];
			$plugin['mimetype'] = implode(', ', $module['mime_type']);
			$extensions = array_map('filesearch_adddot', $module['extensions']);
			$plugin['suffixes'] = implode(', ', $extensions);
			$plugin['version'] = $module['version'];
			$plugins[] = $plugin;
		}
		$has_plugins = (count($plugins) == 0) ? false : true;
		
		$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
		$file_count = $fileBean->countFile();
	
		//get common viewdata
		$viewData = array();
		$viewData['plugins'] = $plugins;
		$viewData['file_count'] = $file_count;
		$viewData['title'] = $title;
		$viewData['has_plugins'] = $has_plugins;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doRescan(&$request, &$response) {

		// change internal encoding to UTF-8
		if (extension_loaded('mbstring')) {
			mb_language('uni');
			mb_internal_encoding('UTF-8');
			mb_http_output('pass');
		}
		
		if (!isset($_SERVER['HTTP_REFERER']) || preg_match('/\\/modules\\/xoonips\\//', $_SERVER['HTTP_REFERER']) == 0) {
			die('Turn REFERER on');
		}
		
		$request = new Xoonips_Request();
		$mode = $request->getParameter('mode');
		$num = $request->getParameter('num');
		
		$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
		$total = $fileBean->countFile();
		
		if ($num < 0 || $num > $total) {
			die('fatal error : invalid \'num\' parameter');
		}
		$files = $fileBean->getFiles();
		$file_id = $files[$num - 1]['file_id'];
		if ($file_id === false) {
			die('fatal error : file id not found');
		}
		$xoonipsFile = new Xoonips_File($this->dirname, $this->trustDirname, true);
		if ($mode == 'info') {
			$xoonipsFile->updateFileInfo($file_id);
		} elseif ($mode == 'index') {
			$xoonipsFile->updateFileSearchText($file_id, true);
		} else {
			die('fatal error : invalid \'mode\' parameter');
		}
		
		$data = array(
			'mode' => $mode,
			'num' => $num,
		);
		
		// json
		$encode = json_encode($data);
		
		// output
		header('Content-Type: text/javascript+json; charset=utf-8');
		echo $encode;
		exit();
	}
}

