<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . '/core/XCube_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * Xleprogress_ApprovalEditForm
**/
class Xleprogress_ApprovalEditForm extends XCube_ActionForm
{
	protected /*** string ***/ $_mDirname = null;

	/**
	 * getTokenName
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getTokenName()
	{
		return "module.xleprogress.ApprovalEditForm.TOKEN";
	}

	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	public function prepare($dirname)
	{
		$this->_mDirname = $dirname;
		//
		// Set form properties
		//
		$this->mFormProperties['approval_id'] = new XCube_IntProperty('approval_id');
		$this->mFormProperties['uid'] = new XCube_IntProperty('uid');
		$this->mFormProperties['groupid'] = new XCube_IntProperty('groupid');
		$this->mFormProperties['type_id'] = new XCube_IntProperty('type_id');
		$this->mFormProperties['step'] = new XCube_IntProperty('step');
	
		//
		// Set field properties
		//
		$this->mFieldProperties['approval_id'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['approval_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['approval_id']->addMessage('required', _MD_XLEPROGRESS_ERROR_REQUIRED, _MD_XLEPROGRESS_LANG_APPROVAL_ID);
		$this->mFieldProperties['step'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['step']->setDependsByArray(array('required', 'min'));
		$this->mFieldProperties['step']->addMessage('required', _MD_XLEPROGRESS_ERROR_REQUIRED, _MD_XLEPROGRESS_LANG_STEP);
		$this->mFieldProperties['step']->addMessage('min', _MD_XLEPROGRESS_ERROR_MIN, _MD_XLEPROGRESS_LANG_STEP, '1');
		$this->mFieldProperties['step']->addVar('min', '1');
	}

	/**
	 * load
	 * 
	 * @param	XoopsSimpleObject  &$obj
	 * 
	 * @return	void
	**/
	public function load(/*** XoopsSimpleObject ***/ &$obj)
	{
		$this->set('approval_id', $obj->get('approval_id'));
		$this->set('uid', $obj->get('uid'));
		$this->set('groupid', $obj->get('groupid'));
		$this->set('type_id', $obj->get('type_id'));
		$this->set('step', $obj->get('step'));
	}

	/**
	 * update
	 * 
	 * @param	XoopsSimpleObject  &$obj
	 * 
	 * @return	void
	**/
	public function update(/*** XoopsSimpleObject ***/ &$obj)
	{
		$obj->set('uid', $this->get('uid'));
		$obj->set('groupid', $this->get('groupid'));
		$obj->set('type_id', $this->get('type_id'));
		$obj->set('step', $this->get('step'));
	}

	/**
	 * validateStep
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function validateStep()
	{
		if($this->get('approval_id')>0){
			return;
		}
		$handler = Legacy_Utils::getModuleHandler('approval', $this->_mDirname);
			
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $this->get('type_id')));
		$cri->add(new Criteria('step', $this->get('step')));
		if(count($handler->getObjects($cri))>0){
			$this->addErrorMessage(_MD_XLEPROGRESS_ERROR_DUPLICATED_STEP);
		}
	}

	/**
	 * validateUid
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function validateUid()
	{
		if($this->get('uid')=='' && $this->get('groupid')==''){
			$this->addErrorMessage(_MD_XLEPROGRESS_ERROR_UID_OR_GROUP_REQUIRED);
		}
	}
}
?>
