<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpconference extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Conference');
     
    #Duplicate Table
    $this->add_dup_table('xnpconference_author');
    $this->add_dup_table('xnpconference_item_detail');
  }
  
  /**
   *
   * This function get xnpconference_item_detail table info.
   * 
   * @param int $item_id
   * @return Success:xnpconference_item_detail Array includes fields, Fail:FALSE 
   */
  protected function get_xnpconference_item_detail($item_id){
    $tbl = get_WK_tbl('xnpconference_item_detail');
    $sql = "select * from {$tbl} where conference_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }
  
  /**
   *
   * This function get xnpconference_author table info.
   * 
   * @param int $item_id
   * @return Success:xnpconference_author Array includes fields, Fail:FALSE 
   */  
  protected function get_xnpconference_author($item_id){
    $wktbl = get_WK_tbl('xnpconference_author');
    $sql = "select * from {$wktbl} where conference_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }
  
  /**
   * sub function insert_ctitle
   *
   * @param int $item_id
   * @return int not exist:0,exist:title_id
   */
  protected function get_max_title_id($item_id) {
    $tbl = get_tbl("xoonips_item_title");
    $sql = "select max(title_id) as title_id from {$tbl} where item_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0]['title_id']+1;
    }    
    return 0;
  }

  /**
   * insert into ctitle.
   * 
   * @param array $result_array
   * @param int  $item_id
   * @param string $title
   * @return boolean Success:true,Fail:false
   */

  protected function insert_ctitle($result_array,$item_id,$title) {
    $tbl = XOOPS_DB_PREFIX.'_'.$result_array['table_name'];
    $col = $result_array['column_name'];
    $title1 = $this->db->quote($title);
    $title_id = $this->get_max_title_id($item_id);
    $item_field_detail_id = $result_array['item_field_detail_id'];
    $this->sql1 = "insert into {$tbl} (item_id,item_field_detail_id,title_id,{$col})".
            " values({$item_id},{$item_field_detail_id},{$title_id},{$title1})";
    $result_array = $this->db->exec($this->sql1);
    if($result_array === FALSE){
      return false;
    }
    return true;
  }


  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $conference = $this->get_xnpconference_item_detail($item_id);
    if($conference === FALSE || $conference === NULL){
      return -errmsg(APP_MIGRATE, 'E1701',$item_id);
    }
    
    $presentation_array = $this->get_table_column_by_group('presentation_type');
    if($presentation_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1702');
    }

    $rc = $this->insert_any($presentation_array,$item_id,$conference['presentation_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1716',$item_id);
    }
    
    #conference_title
    $conference_title_array = $this->get_table_column_by_group('ctitle');
    if($conference_title_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1717');
    }

    $rc = $this->insert_ctitle($conference_title_array,$item_id,$conference['conference_title']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1718',$item_id);
    }
    
    #place
    if(strlen($conference['place']) > 0){
      $place_array = $this->get_table_column_by_group('conference_place');
      if($place_array === FALSE){
        return -errmsg(APP_MIGRATE, 'E1706');
      }

      $rc = $this->insert_any($place_array,$item_id,$conference['place']);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1707',$item_id);
      }
    }
 
    #abstract
    if(strlen($conference['abstract'])>0){
      $abstract_array = $this->get_table_column_by_group('presentation_abstract');
      if($abstract_array === FALSE){
        return -errmsg(APP_MIGRATE, 'E1708');
      }
      $rc = $this->insert_any($abstract_array,$item_id,$conference['abstract']);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1709',$item_id);
      }
    }
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit');
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1710');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$conference['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1711',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify');
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1712');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$conference['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1713',$item_id);
    }
    
    #name
    $developer_array = $this->get_table_column_by_item('name');
    if($developer_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1714');
    }
    $author = $this->get_xnpconference_author($item_id);
    foreach ($author as $value) {
      $rc = $this->insert_any($developer_array,$item_id,$value['author'],$value['author_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1715',$item_id);
      }
    }
    
    #date_from,date_to

    $date_from = mktime(0,
                        0,
                        0,
                        $conference['conference_from_month'],
                        $conference['conference_from_mday'],
                        $conference['conference_from_year']);
    $date_to   = mktime(0,
                        0,
                        0,
                        $conference['conference_to_month'],
                        $conference['conference_to_mday'],
                        $conference['conference_to_year']);

    if($date_from > 0){
      $date_from_array = $this->get_table_column_by_group('date_from');
      if($date_from_array === FALSE){
        return -errmsg(APP_MIGRATE, 'E1719');
      }
      $rc = $this->insert_any($date_from_array,$item_id,$date_from);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1720',$item_id);
      }
    }

    if($date_to > 0){
      $date_to_array = $this->get_table_column_by_group('date_to');
      if($date_to_array === FALSE){
        return -errmsg(APP_MIGRATE, 'E1721');
      }

      $rc = $this->insert_any($date_to_array,$item_id,$date_to);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1722',$item_id);
      }
    }
    
    #presentation type
    $conference_presentation_type_array = $this->get_table_column_by_group('conference_presentation_type');
    if($conference_presentation_type_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1723');
    }
    $rc = $this->insert_any($conference_presentation_type_array,$item_id,$conference['presentation_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1724',$item_id);
    }
    return 0;
  }
}
