<?php
/**
 *Duplicates tables 
 */
$duptables = array(
  'xoonips_changelog',
  'xoonips_config',
  'xoonips_event_log',
  'xoonips_file',
  'xoonips_file_type',
  'xoonips_groups',
  'xoonips_groups_users_link',
  'xoonips_index',
  'xoonips_index_group_index_link',
  'xoonips_index_item_link',
  'xoonips_item_basic',
  'xoonips_item_keyword',
  'xoonips_item_title',
  'xoonips_item_type',
  'xoonips_related_to',
  'xoonips_search_text',
  'xoonips_users',
  'users',
  'groups_users_link',
  'xoopsnotifications'
);
/**
 * cmd line common library.
 */

/**
 * output error message
 *
 *
 * @param type $app_id
 * @param type $id
 * @param type $val
 */
function errmsg($app_id,$id,$val=null) {
  $frag = 'english';
  if(strcmp(getenv('LANG'),'ja_JP.UTF-8')==0){
    $frag = 'ja_utf8';
  }
  require_once XOOPS_TRUST_PATH."/modules/xdbmigrate/language/{$frag}/admin.php";
    
  $fmtid = "_AM_XDBMIGRATE_{$id}";
  $fmt = constant($fmtid);
  if(is_null($fmt)){  #Unfind message
    return 0;
  }
  if(is_null($val)){
    fprintf(STDERR, "%s:".$fmt."\n",$id);
  }else{
    fprintf(STDERR, "%s:".$fmt."\n",$id,$val);
  }
  $num = intval(substr($id, 1));
  if($num > 1000){
    set_status($app_id,$num);
  }
  return $num;
}



/**
 * Status update.
 * 
 * @param string $app_id
 * @param string $status 
 * @return boolean 
 */
function set_status($app_id,$status) {
  $dsn = 'mysql:dbname='.XOOPS_DB_NAME.';host='.XOOPS_DB_HOST.';';
  try{
    $dbh = new PDO($dsn,XOOPS_DB_USER,XOOPS_DB_PASS);
    $sql = "update ".XOOPS_DB_PREFIX."_xdbmigrate_status ".
            "set app_id= {$app_id},".
            "status = {$status}";
    $ret = $dbh->query($sql);
    if($ret === FALSE){
      return false;
    }
  }catch(PDOException $e){
    return false;
  }
  return true;
}

function get_WK_tbl($tbl) {
  return XOOPS_DB_PREFIX."_WK_".$tbl;
}

function get_tbl($tbl) {
  return XOOPS_DB_PREFIX."_".$tbl;
}


