<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewTypeDate.class.php';

class User_ViewTypeLastLogin extends Xoonips_ViewTypeDate {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_lastlogin.html';
	}

	public function getDisplayView($field, $value, $groupLoopId) {
       	$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		if ($value > 0) {
			$this->getXoopsTpl()->assign('value', $value + $this->getTimeZoneOffset());
		} else {
			$this->getXoopsTpl()->assign('value', $value);
		}
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$this->getXoopsTpl()->assign('viewType', 'detail');
		if ($value > 0) {
			$this->getXoopsTpl()->assign('value', $value + $this->getTimeZoneOffset());
		} else {
			$this->getXoopsTpl()->assign('value', $value);
		}
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function searchCheck(&$errors, $field, $value, $fieldName) {
		$char = "/^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/";
		if (is_array($value)) {
			$value[0] = trim($value[0]);
			$value[1] = trim($value[1]);
			if ($value[0] !== '') {
				if (!preg_match($char, $value[0])) {
					$parameters = array();
					$parameters[] = $field->getName() . '[from]';
					$errors->addError('_MD_USER_ERROR_DATE', $fieldName, $parameters);
				}
			}
			if ($value[1] !== '') {
				if (!preg_match($char, $value[1])) {				
					$parameters = array();
					$parameters[] = $field->getName() . '[to]';
					$errors->addError('_MD_USER_ERROR_DATE', $fieldName, $parameters);
				}
			}
		} else {
			$value = trim($value);
			if ($value !== '') {
				if (!preg_match($char, $value)) {
					$parameters = array();
					$parameters[] = $field->getName();
					$errors->addError('_MD_USER_ERROR_DATE', $fieldName, $parameters);
				}
			}
		}	
	}
	
	public function doSearch($field, &$data, &$sqlStrings, $groupLoopId, $scopeSearchFlg, $isExact) {
		$tableName = $field->getTableName();
		$columnName = $field->getColumnName();
		$value = $data[$this->getFieldName($field, $groupLoopId)];
		
	    if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}
		if ($value != '') {
			if ($field->getScopeSearch() == 1 && $scopeSearchFlg) {
				$value[0] = trim($value[0]);
				$value[1] = trim($value[1]);
				if ($value[0] != '') {
					$valueArr = array();
					$valueArr = explode('-', $value[0]);
					$value[0] = mktime(0, 0, 0, $valueArr[1], $valueArr[2], $valueArr[0]);
					$v = $field->getDataType()->convertSQLStr($value[0]);
					$tableData[] = "$columnName>=$v";
				} 
				if ($value[1] != '') {
					$valueArr = array();
					$valueArr = explode('-', $value[1]);
					$value[1] = mktime(24, 0, 0, $valueArr[1], $valueArr[2], $valueArr[0]);
					$v = $field->getDataType()->convertSQLStr($value[1]);
					$tableData[] = "$columnName<=$v";
				} 
			} else {
				$value = trim($value);
				$valueArr = array();
				$valueArr = explode('-', $value);
				$value = mktime(0, 0, 0, $valueArr[1], $valueArr[2], $valueArr[0]);
				$value = substr($value, 0, 5);
				$v = $field->getDataType()->convertSQLStrLike($value);
				$tableData[] = "$columnName like '%$v%'";
			}
		}
	}
	
	public function isDisplay($op) {
		if ($op == Xoonips_Enum::OP_TYPE_REGISTRY || $op == Xoonips_Enum::OP_TYPE_EDIT || $op == Xoonips_Enum::OP_TYPE_MANAGER_EDIT || $op == Xoonips_Enum::OP_TYPE_MANAGER_REGISTRY) {
			return false;
		}
		return true;
	}
}

